/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

public class AggregateException
extends RuntimeException {
    private static final long serialVersionUID = 1580760362088821678L;
    private static final String CAUSE_CAPTION = "Caused by: ";
    private static final String SUPPRESSED_CAPTION = "Suppressed: ";
    private static final String AGGREGATION_CAPTION = "additional aggregated exception #";
    private final List<Throwable> throwableList = Collections.synchronizedList(new ArrayList());

    public AggregateException(String message) {
        this(message, Collections.emptyList());
    }

    public AggregateException(String message, List<Throwable> throwables) {
        super(message, throwables.isEmpty() ? null : throwables.get(0));
        this.throwableList.addAll(throwables);
    }

    public synchronized void add(Throwable cause) {
        if (cause != null) {
            this.throwableList.add(cause);
        }
    }

    @Override
    public synchronized Throwable getCause() {
        if (this.throwableList.isEmpty()) {
            return super.getCause();
        }
        return this.throwableList.get(0);
    }

    public synchronized List<Throwable> getThrowableList() {
        return this.throwableList;
    }

    public synchronized boolean isEmpty() {
        return this.throwableList.isEmpty();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.printStackTrace(new WrappedPrintStream(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStackTrace(PrintStreamOrWriter stream) {
        Set<Throwable> dejaVu = Collections.newSetFromMap(new IdentityHashMap());
        dejaVu.add(this);
        Object object = stream.lock();
        synchronized (object) {
            stream.println(this.getClass().getSimpleName() + " - primary exception cause:");
            stream.println(this);
            StackTraceElement[] trace = this.getStackTrace();
            for (StackTraceElement stackTraceElement : trace) {
                stream.println("\tat " + stackTraceElement);
            }
            for (Serializable serializable : this.getSuppressed()) {
                AggregateException.printEnclosedStackTrace((Throwable)serializable, stream, trace, SUPPRESSED_CAPTION, "\t", dejaVu);
            }
            Throwable ourCause = this.getCause();
            if (ourCause != null) {
                AggregateException.printEnclosedStackTrace(ourCause, stream, trace, CAUSE_CAPTION, "", dejaVu);
            }
            int exceptionCounter = 0;
            for (Throwable throwable : this.getThrowableList()) {
                if (++exceptionCounter == 1) continue;
                AggregateException.printEnclosedStackTrace(throwable, stream, trace, AGGREGATION_CAPTION + exceptionCounter + ": ", "", dejaVu);
            }
        }
    }

    protected static void printEnclosedStackTrace(Throwable throwable, PrintStreamOrWriter stream, StackTraceElement[] enclosingTrace, String caption, String prefix, Set<Throwable> dejaVu) {
        assert (Thread.holdsLock(stream.lock()));
        if (dejaVu.contains(throwable)) {
            stream.println("\t[CIRCULAR REFERENCE: " + throwable + "]");
            return;
        }
        dejaVu.add(throwable);
        StackTraceElement[] trace = throwable.getStackTrace();
        int m = trace.length - 1;
        for (int n = enclosingTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(enclosingTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        stream.println(prefix + caption + throwable);
        for (int i = 0; i <= m; ++i) {
            stream.println(prefix + "\tat " + trace[i]);
        }
        if (framesInCommon != 0) {
            stream.println(prefix + "\t... " + framesInCommon + " more");
        }
        for (Throwable se : throwable.getSuppressed()) {
            AggregateException.printEnclosedStackTrace(se, stream, trace, SUPPRESSED_CAPTION, prefix + "\t", dejaVu);
        }
        Throwable ourCause = throwable.getCause();
        if (ourCause != null) {
            AggregateException.printEnclosedStackTrace(ourCause, stream, trace, CAUSE_CAPTION, prefix, dejaVu);
        }
    }

    protected static class WrappedPrintWriter
    implements PrintStreamOrWriter {
        private final PrintWriter printWriter;

        WrappedPrintWriter(PrintWriter printWriter) {
            this.printWriter = printWriter;
        }

        @Override
        public Object lock() {
            return this.printWriter;
        }

        @Override
        public void println(Object o) {
            this.printWriter.println(o);
        }
    }

    protected static class WrappedPrintStream
    implements PrintStreamOrWriter {
        private final PrintStream printStream;

        WrappedPrintStream(PrintStream printStream) {
            this.printStream = printStream;
        }

        @Override
        public Object lock() {
            return this.printStream;
        }

        @Override
        public void println(Object o) {
            this.printStream.println(o);
        }
    }

    protected static interface PrintStreamOrWriter {
        public Object lock();

        public void println(Object var1);
    }
}

