/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi.utils;

import de.gsi.dataset.spi.utils.StringHashMapList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StringHashMapList2
implements Map<Integer, String> {
    private static final long PARALLELISM_THRESHOLD = 1000L;
    private final IntArrayList indices = new IntArrayList(10);
    private final List<String> data = new ArrayList<String>();

    public void addValueAndShiftKeys(int fromIndex, int toIndex, String label) {
        int diff = toIndex - fromIndex;
        int[] array = this.indices.elements();
        int insertIndex = this.getLocalIndexForExternalIndex(fromIndex);
        for (int i = 0; i < this.indices.size(); ++i) {
            if (array[i] < fromIndex) continue;
            array[i] = array[i] + diff;
        }
        if (insertIndex >= 0) {
            throw new IllegalArgumentException("element with index " + fromIndex + " already exists");
        }
        this.indices.add(-insertIndex, fromIndex);
        this.data.add(-insertIndex, label);
    }

    @Override
    public void clear() {
        this.indices.clear();
        this.data.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof Integer)) {
            return false;
        }
        return this.getLocalIndexForExternalIndex((Integer)key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.data.contains(value);
    }

    @Override
    public Set<Map.Entry<Integer, String>> entrySet() {
        HashSet<Map.Entry<Integer, String>> retVal = new HashSet<Map.Entry<Integer, String>>();
        for (int i = 0; i < this.indices.size(); ++i) {
            retVal.add(new AbstractMap.SimpleEntry<Integer, String>(this.indices.getInt(i), this.data.get(i)));
        }
        return retVal;
    }

    public String get(int externalIndex) {
        int index = this.getLocalIndexForExternalIndex(externalIndex);
        return index < 0 ? null : this.data.get(index);
    }

    @Override
    public String get(Object key) {
        if (!(key instanceof Integer)) {
            return null;
        }
        int externalIndex = (Integer)key;
        int index = this.getLocalIndexForExternalIndex(externalIndex);
        return index < 0 ? null : this.data.get(index);
    }

    private final int getLocalIndexForExternalIndex(int externalIndex) {
        int low = 0;
        int high = this.indices.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = this.indices.elements()[mid];
            if (midVal < externalIndex) {
                low = mid + 1;
                continue;
            }
            if (midVal > externalIndex) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public boolean isEmpty() {
        return this.indices.isEmpty();
    }

    @Override
    public Set<Integer> keySet() {
        return new HashSet<Integer>((Collection<Integer>)this.indices);
    }

    @Override
    public String put(Integer key, String value) {
        int index = this.getLocalIndexForExternalIndex(key);
        if (index < 0) {
            if (-index < this.indices.size()) {
                this.indices.add(-index, key.intValue());
                this.data.add(-index, value);
            } else {
                this.indices.add(key.intValue());
                this.data.add(value);
            }
            return null;
        }
        return this.data.set(index, value);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends String> m) {
    }

    public void remove(int fromIndex, int toIndex) {
        int diffLength = toIndex - fromIndex;
        for (int i = 0; i < diffLength; ++i) {
            this.remove(toIndex + i);
        }
    }

    @Override
    public String remove(Object key) {
        if (!(key instanceof Integer)) {
            return null;
        }
        int index = this.getLocalIndexForExternalIndex((Integer)key);
        if (index < 0) {
            return null;
        }
        String retVal = this.data.get(index);
        this.indices.removeInt(index);
        this.data.remove(index);
        return retVal;
    }

    public void setAll(StringHashMapList other) {
        this.clear();
        other.forEachEntry(1000L, kv -> {
            String label = (String)kv.getValue();
            if (label != null && !label.isEmpty()) {
                this.put((Integer)kv.getKey(), label);
            }
        });
    }

    public void shiftKeys(int fromIndex, int toIndex) {
        if (this.indices.isEmpty()) {
            return;
        }
        int diff = toIndex - fromIndex;
        int[] array = this.indices.elements();
        for (int i = 0; i < this.indices.size(); ++i) {
            array[i] = array[i] + diff;
        }
    }

    @Override
    public int size() {
        return this.indices.size();
    }

    @Override
    public Collection<String> values() {
        return this.data;
    }
}

