/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi.utils;

import de.gsi.dataset.spi.utils.MultiArray;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;

public class MultiArrayLong
extends MultiArray<long[]> {
    public static MultiArrayLong wrap(long[] elements) {
        return MultiArrayLong.wrap(elements, 0, elements.length);
    }

    public static MultiArrayLong wrap(long[] elements, int offset, int length) {
        return new MultiArray1DLong(elements, new int[]{length}, offset);
    }

    public static MultiArrayLong wrap(long[] elements, int[] dimensions) {
        return MultiArrayLong.wrap(elements, 0, dimensions);
    }

    public static MultiArrayLong wrap(long[] elements, int offset, int[] dimensions) {
        int nElements = 1;
        for (int ni : dimensions) {
            nElements *= ni;
        }
        AssertUtils.gtOrEqual("Array size", nElements + offset, elements.length);
        switch (dimensions.length) {
            case 1: {
                return new MultiArray1DLong(elements, dimensions, offset);
            }
            case 2: {
                return new MultiArray2DLong(elements, dimensions, offset);
            }
        }
        return new MultiArrayLong(elements, dimensions, offset);
    }

    public static MultiArrayLong allocate(int[] dimensions) {
        switch (dimensions.length) {
            case 1: {
                return new MultiArray1DLong(new long[dimensions[0]], dimensions, 0);
            }
            case 2: {
                return new MultiArray2DLong(new long[dimensions[1] * dimensions[0]], dimensions, 0);
            }
        }
        int nElements = 1;
        for (int ni : dimensions) {
            nElements *= ni;
        }
        return new MultiArrayLong(new long[nElements], dimensions, 0);
    }

    protected MultiArrayLong(long[] elements, int[] dimensions, int offset) {
        super(elements, dimensions, offset);
    }

    public void setStrided(int index, long value) {
        ((long[])this.elements)[index + this.offset] = value;
    }

    public void set(int[] indices, long value) {
        ((long[])this.elements)[this.getIndex((int[])indices)] = value;
    }

    public long getStrided(int index) {
        return ((long[])this.elements)[index + this.offset];
    }

    public long get(int[] indices) {
        return ((long[])this.elements)[this.getIndex(indices)];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiArrayLong)) {
            return false;
        }
        MultiArrayLong that = (MultiArrayLong)o;
        return Arrays.equals(this.dimensions, that.dimensions) && Arrays.equals((long[])this.elements, this.offset, this.offset + this.getElementsCount(), (long[])that.elements, that.offset, that.offset + this.getElementsCount());
    }

    public int hashCode() {
        int result = 1;
        for (int i = this.offset; i < this.offset + this.getElementsCount(); ++i) {
            result = 31 * result + Long.hashCode(((long[])this.elements)[i]);
        }
        result = 31 * result + Arrays.hashCode(this.dimensions);
        return result;
    }

    public static class MultiArray2DLong
    extends MultiArrayLong {
        private final int stride;

        protected MultiArray2DLong(long[] elements, int[] dimensions, int offset) {
            super(elements, dimensions, offset);
            this.stride = dimensions[0];
        }

        public long get(int column, int row) {
            return ((long[])this.elements)[this.offset + column + row * this.stride];
        }

        public void set(int column, int row, long value) {
            ((long[])this.elements)[this.offset + column + row * this.stride] = value;
        }

        public long[] getRow(int row) {
            int index = row * this.stride + this.offset;
            return Arrays.copyOfRange((long[])this.elements, index, index + this.stride);
        }
    }

    public static class MultiArray1DLong
    extends MultiArrayLong {
        protected MultiArray1DLong(long[] elements, int[] dimensions, int offset) {
            super(elements, dimensions, offset);
        }

        public long get(int index) {
            return this.getStrided(index);
        }

        public void set(int index, long value) {
            this.setStrided(index, value);
        }
    }
}

