/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi.utils;

import de.gsi.dataset.spi.utils.MultiArray;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;

public class MultiArrayByte
extends MultiArray<byte[]> {
    public static MultiArrayByte wrap(byte[] elements) {
        return MultiArrayByte.wrap(elements, 0, elements.length);
    }

    public static MultiArrayByte wrap(byte[] elements, int offset, int length) {
        return new MultiArray1DByte(elements, new int[]{length}, offset);
    }

    public static MultiArrayByte wrap(byte[] elements, int[] dimensions) {
        return MultiArrayByte.wrap(elements, 0, dimensions);
    }

    public static MultiArrayByte wrap(byte[] elements, int offset, int[] dimensions) {
        int nElements = 1;
        for (int ni : dimensions) {
            nElements *= ni;
        }
        AssertUtils.gtOrEqual("Array size", nElements + offset, elements.length);
        switch (dimensions.length) {
            case 1: {
                return new MultiArray1DByte(elements, dimensions, offset);
            }
            case 2: {
                return new MultiArray2DByte(elements, dimensions, offset);
            }
        }
        return new MultiArrayByte(elements, dimensions, offset);
    }

    public static MultiArrayByte allocate(int[] dimensions) {
        switch (dimensions.length) {
            case 1: {
                return new MultiArray1DByte(new byte[dimensions[0]], dimensions, 0);
            }
            case 2: {
                return new MultiArray2DByte(new byte[dimensions[1] * dimensions[0]], dimensions, 0);
            }
        }
        int nElements = 1;
        for (int ni : dimensions) {
            nElements *= ni;
        }
        return new MultiArrayByte(new byte[nElements], dimensions, 0);
    }

    protected MultiArrayByte(byte[] elements, int[] dimensions, int offset) {
        super(elements, dimensions, offset);
    }

    public void setStrided(int index, byte value) {
        ((byte[])this.elements)[index + this.offset] = value;
    }

    public void set(int[] indices, byte value) {
        ((byte[])this.elements)[this.getIndex((int[])indices)] = value;
    }

    public byte getStrided(int index) {
        return ((byte[])this.elements)[index + this.offset];
    }

    public byte get(int[] indices) {
        return ((byte[])this.elements)[this.getIndex(indices)];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiArrayByte)) {
            return false;
        }
        MultiArrayByte that = (MultiArrayByte)o;
        return Arrays.equals(this.dimensions, that.dimensions) && Arrays.equals((byte[])this.elements, this.offset, this.offset + this.getElementsCount(), (byte[])that.elements, that.offset, that.offset + this.getElementsCount());
    }

    public int hashCode() {
        int result = 1;
        for (int i = this.offset; i < this.offset + this.getElementsCount(); ++i) {
            result = 31 * result + Byte.hashCode(((byte[])this.elements)[i]);
        }
        result = 31 * result + Arrays.hashCode(this.dimensions);
        return result;
    }

    public static class MultiArray2DByte
    extends MultiArrayByte {
        private final int stride;

        protected MultiArray2DByte(byte[] elements, int[] dimensions, int offset) {
            super(elements, dimensions, offset);
            this.stride = dimensions[0];
        }

        public byte get(int column, int row) {
            return ((byte[])this.elements)[this.offset + column + row * this.stride];
        }

        public void set(int column, int row, byte value) {
            ((byte[])this.elements)[this.offset + column + row * this.stride] = value;
        }

        public byte[] getRow(int row) {
            int index = row * this.stride + this.offset;
            return Arrays.copyOfRange((byte[])this.elements, index, index + this.stride);
        }
    }

    public static class MultiArray1DByte
    extends MultiArrayByte {
        protected MultiArray1DByte(byte[] elements, int[] dimensions, int offset) {
            super(elements, dimensions, offset);
        }

        public byte get(int index) {
            return this.getStrided(index);
        }

        public void set(int index, byte value) {
            this.setStrided(index, value);
        }
    }
}

