/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi.utils;

import de.gsi.dataset.spi.utils.MultiArrayBoolean;
import de.gsi.dataset.spi.utils.MultiArrayByte;
import de.gsi.dataset.spi.utils.MultiArrayChar;
import de.gsi.dataset.spi.utils.MultiArrayDouble;
import de.gsi.dataset.spi.utils.MultiArrayFloat;
import de.gsi.dataset.spi.utils.MultiArrayInt;
import de.gsi.dataset.spi.utils.MultiArrayLong;
import de.gsi.dataset.spi.utils.MultiArrayObject;
import de.gsi.dataset.spi.utils.MultiArrayShort;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Collections;

public abstract class MultiArray<T> {
    protected final T elements;
    private final int elementCount;
    protected final int[] dimensions;
    protected final int[] strides;
    protected final int offset;

    public static <O> MultiArray<O> wrap(O elements, int[] dimensions) {
        return MultiArray.wrap(elements, 0, dimensions);
    }

    public static <O> MultiArray<O> wrap(O elements, int offset, int[] dimensions) {
        if (elements instanceof double[]) {
            return MultiArrayDouble.wrap((double[])elements, offset, dimensions);
        }
        if (elements instanceof float[]) {
            return MultiArrayFloat.wrap((float[])elements, offset, dimensions);
        }
        if (elements instanceof int[]) {
            return MultiArrayInt.wrap((int[])elements, offset, dimensions);
        }
        if (elements instanceof byte[]) {
            return MultiArrayByte.wrap((byte[])elements, offset, dimensions);
        }
        if (elements instanceof char[]) {
            return MultiArrayChar.wrap((char[])elements, offset, dimensions);
        }
        if (elements instanceof long[]) {
            return MultiArrayLong.wrap((long[])elements, offset, dimensions);
        }
        if (elements instanceof short[]) {
            return MultiArrayShort.wrap((short[])elements, offset, dimensions);
        }
        if (elements instanceof boolean[]) {
            return MultiArrayBoolean.wrap((boolean[])elements, offset, dimensions);
        }
        if (elements instanceof Object[]) {
            return MultiArrayObject.wrap((Object[])elements, offset, dimensions);
        }
        throw new IllegalArgumentException("Data type not supported for MultiDimArray");
    }

    public static <O> MultiArray<O> wrap(O elements) {
        return MultiArray.wrap(elements, 0);
    }

    public static <O> MultiArray<O> wrap(O elements, int offset) {
        if (elements instanceof double[]) {
            return MultiArrayDouble.wrap((double[])elements, offset, ((double[])elements).length);
        }
        if (elements instanceof float[]) {
            return MultiArrayFloat.wrap((float[])elements, offset, ((float[])elements).length);
        }
        if (elements instanceof int[]) {
            return MultiArrayInt.wrap((int[])elements, offset, ((int[])elements).length);
        }
        if (elements instanceof byte[]) {
            return MultiArrayByte.wrap((byte[])elements, offset, ((byte[])elements).length);
        }
        if (elements instanceof char[]) {
            return MultiArrayChar.wrap((char[])elements, offset, ((char[])elements).length);
        }
        if (elements instanceof long[]) {
            return MultiArrayLong.wrap((long[])elements, offset, ((long[])elements).length);
        }
        if (elements instanceof short[]) {
            return MultiArrayShort.wrap((short[])elements, offset, ((short[])elements).length);
        }
        if (elements instanceof boolean[]) {
            return MultiArrayBoolean.wrap((boolean[])elements, offset, ((boolean[])elements).length);
        }
        if (elements instanceof Object[]) {
            return MultiArrayObject.wrap((Object[])elements, offset, ((Object[])elements).length);
        }
        throw new IllegalArgumentException("Data type not supported for MultiDimArray");
    }

    protected MultiArray(T elements, int[] dimensions, int offset) {
        AssertUtils.notNull("dimensions", dimensions);
        AssertUtils.notNull("elements", elements);
        this.dimensions = dimensions;
        this.elements = elements;
        this.offset = offset;
        this.strides = new int[dimensions.length];
        this.strides[0] = 1;
        for (int i = 1; i < dimensions.length; ++i) {
            this.strides[i] = this.strides[i - 1] * dimensions[i - 1];
        }
        this.elementCount = this.strides[dimensions.length - 1] * dimensions[dimensions.length - 1];
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getElementsCount() {
        return this.elementCount;
    }

    public int getIndex(int[] indices) {
        int index = this.offset;
        for (int i = 0; i < this.dimensions.length; ++i) {
            if (indices[i] < 0 || indices[i] >= this.dimensions[i]) {
                throw new IndexOutOfBoundsException("Index " + indices[i] + " for dimension " + i + " out of bounds " + this.dimensions[i]);
            }
            index += indices[i] * this.strides[i];
        }
        return index;
    }

    public int[] getIndices(int index) {
        if (index >= this.elementCount + this.offset || index < this.offset) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.offset) {
            return new int[this.dimensions.length];
        }
        int[] indices = new int[this.dimensions.length];
        int ind = index - this.offset;
        for (int i = this.dimensions.length - 1; i >= 0; --i) {
            if (this.dimensions[i] == 0) {
                throw new IndexOutOfBoundsException();
            }
            indices[i] = ind / this.strides[i];
            ind %= this.strides[i];
        }
        return indices;
    }

    public T elements() {
        return this.elements;
    }

    public String toString() {
        return String.format("MultiArray [dimensions = %s, elements = %s]", Collections.singletonList(this.dimensions).toString(), Collections.singletonList(this.elements).toString());
    }
}

