/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi.utils;

import de.gsi.dataset.spi.utils.HashMapHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class IntStringMap
implements Map<Integer, String> {
    private static final String NOT_IMPLEMENTED = "not implemented";
    private static final String FREE_KEY = "";
    private static final String REMOVED_KEY = "";
    private static final String NULL_VALUE = null;
    private Object[] data;
    private boolean hasNull;
    private final float fillFactor;
    private int threshold;
    private int sizeInternal;
    private int mask;
    private int mask2;

    public IntStringMap(int size, float fillFactor) {
        if (fillFactor <= 0.0f || fillFactor >= 1.0f) {
            throw new IllegalArgumentException("FillFactor must be in (0, 1)");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be positive!");
        }
        int capacity = HashMapHelper.arraySize(size, fillFactor);
        this.mask = capacity - 1;
        this.mask2 = capacity * 2 - 1;
        this.fillFactor = fillFactor;
        this.data = new Object[capacity * 2];
        Arrays.fill(this.data, "");
        this.threshold = (int)((float)capacity * fillFactor);
    }

    @Override
    public void clear() {
        Arrays.fill(this.data, "");
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }

    @Override
    public Set<Map.Entry<Integer, String>> entrySet() {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }

    public String get(int key) {
        int ptr = (key & this.mask) << 1;
        Object k = this.data[ptr];
        if (k.equals("")) {
            return null;
        }
        do {
            if (!(k = this.data[ptr = ptr + 2 & this.mask2]).equals("")) continue;
            return null;
        } while (!k.equals(key));
        return (String)this.data[ptr + 1];
    }

    @Override
    public String get(Object key) {
        if (key == null) {
            return NULL_VALUE;
        }
        return this.get(key);
    }

    public int getStartIndex(Object key) {
        return (Integer)key & this.mask;
    }

    @Override
    public boolean isEmpty() {
        return this.sizeInternal == 0;
    }

    @Override
    public Set<Integer> keySet() {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }

    @Override
    public String put(Integer key, String value) {
        int ptr = this.getStartIndex(key) << 1;
        Object k = this.data[ptr];
        if (k.equals("")) {
            this.data[ptr] = key;
            this.data[ptr + 1] = value;
            if (this.sizeInternal >= this.threshold) {
                this.rehash(this.data.length * 2);
            } else {
                ++this.sizeInternal;
            }
            return null;
        }
        if (k.equals(key)) {
            Object ret = this.data[ptr + 1];
            this.data[ptr + 1] = value;
            return (String)ret;
        }
        int firstRemoved = -1;
        if (k.equals("")) {
            firstRemoved = ptr;
        }
        while (true) {
            if ((k = this.data[ptr = ptr + 2 & this.mask2]).equals("")) {
                if (firstRemoved != -1) {
                    ptr = firstRemoved;
                }
                this.data[ptr] = key;
                this.data[ptr + 1] = value;
                if (this.sizeInternal >= this.threshold) {
                    this.rehash(this.data.length * 2);
                } else {
                    ++this.sizeInternal;
                }
                return null;
            }
            if (k.equals(key)) {
                Object ret = this.data[ptr + 1];
                this.data[ptr + 1] = value;
                return (String)ret;
            }
            if (!k.equals("") || firstRemoved != -1) continue;
            firstRemoved = ptr;
        }
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends String> m) {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }

    private void rehash(int newCapacity) {
        this.threshold = (int)((double)newCapacity / 2.0 * (double)this.fillFactor);
        this.mask = newCapacity / 2 - 1;
        this.mask2 = newCapacity - 1;
        int oldCapacity = this.data.length;
        Object[] oldData = this.data;
        this.data = new Object[newCapacity];
        Arrays.fill(this.data, "");
        this.sizeInternal = this.hasNull ? 1 : 0;
        for (int i = 0; i < oldCapacity; i += 2) {
            Object oldKey = oldData[i];
            if (oldKey.equals("") || oldKey.equals("")) continue;
            this.put((Integer)oldKey, (String)oldData[i + 1]);
        }
    }

    @Override
    public String remove(Object key) {
        int ptr = this.getStartIndex(key) << 1;
        Object k = this.data[ptr];
        if (k.equals("")) {
            return null;
        }
        if (k.equals(key)) {
            --this.sizeInternal;
            this.data[ptr] = this.data[ptr + 2 & this.mask2] == "" ? "" : "";
            String ret = (String)this.data[ptr + 1];
            this.data[ptr + 1] = null;
            return ret;
        }
        do {
            if (!(k = this.data[ptr = ptr + 2 & this.mask2]).equals("")) continue;
            return null;
        } while (!k.equals(key));
        --this.sizeInternal;
        this.data[ptr] = this.data[ptr + 2 & this.mask2] == "" ? "" : "";
        String ret = (String)this.data[ptr + 1];
        this.data[ptr + 1] = null;
        return ret;
    }

    @Override
    public int size() {
        return this.sizeInternal;
    }

    @Override
    public Collection<String> values() {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }
}

