/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.GridDataSet;
import de.gsi.dataset.event.AxisChangeEvent;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.locks.DataSetLock;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransposedDataSet
implements DataSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransposedDataSet.class);
    private static final long serialVersionUID = 2019092401L;
    protected final DataSet dataSet;
    protected final int nDims;
    protected int[] permutation;
    private boolean transposed;

    private TransposedDataSet(DataSet dataSet, boolean transposed) {
        if (dataSet == null) {
            throw new IllegalArgumentException("DataSet is null");
        }
        this.dataSet = dataSet;
        this.permutation = new int[dataSet.getDimension()];
        this.transposed = transposed;
        this.nDims = dataSet.getDimension();
        for (int i = 0; i < this.permutation.length; ++i) {
            this.permutation[i] = i;
        }
        if (transposed) {
            this.permutation[0] = 1;
            this.permutation[1] = 0;
        }
    }

    private TransposedDataSet(DataSet dataSet, int[] permutation) {
        if (dataSet == null) {
            throw new IllegalArgumentException("DataSet is null");
        }
        if (permutation == null) {
            throw new IllegalArgumentException("permutation is null");
        }
        for (int i = 0; i < dataSet.getDimension(); ++i) {
            if (permutation[i] < dataSet.getDimension()) continue;
            throw new IndexOutOfBoundsException("permutation[" + i + "] contains dimIndex='" + permutation[i] + "' outside DataSet dimension (" + dataSet.getDimension() + ")");
        }
        this.dataSet = dataSet;
        this.nDims = permutation.length;
        this.permutation = Arrays.copyOf(permutation, this.dataSet.getDimension());
        this.transposed = false;
    }

    @Override
    public AtomicBoolean autoNotification() {
        return this.dataSet.autoNotification();
    }

    @Override
    public double get(int dimIndex, int index) {
        return this.dataSet.get(this.permutation[dimIndex], index);
    }

    @Override
    public List<AxisDescription> getAxisDescriptions() {
        return IntStream.of(this.permutation).mapToObj(this.dataSet::getAxisDescription).collect(Collectors.toList());
    }

    @Override
    public AxisDescription getAxisDescription(int dimIndex) {
        return this.dataSet.getAxisDescription(this.permutation[dimIndex]);
    }

    @Override
    public int getDataCount() {
        return this.dataSet.getDataCount();
    }

    @Override
    public String getDataLabel(int index) {
        return this.dataSet.getDataLabel(index);
    }

    @Override
    public int getDimension() {
        return this.permutation.length;
    }

    @Override
    public int getIndex(int dimIndex, double ... value) {
        AssertUtils.checkArrayDimension("value", value, 1);
        return this.dataSet.getIndex(this.permutation[dimIndex], value);
    }

    @Override
    public String getName() {
        return this.dataSet.getName();
    }

    public int[] getPermutation() {
        return Arrays.copyOf(this.permutation, this.permutation.length);
    }

    @Override
    public String getStyle() {
        return this.dataSet.getStyle();
    }

    @Override
    public String getStyle(int index) {
        return this.dataSet.getStyle(index);
    }

    @Override
    public double[] getValues(int dimIndex) {
        return this.dataSet.getValues(this.permutation[dimIndex]);
    }

    public boolean isTransposed() {
        return this.transposed;
    }

    @Override
    public <D extends DataSet> DataSetLock<D> lock() {
        return this.dataSet.lock();
    }

    @Override
    public DataSet recomputeLimits(int dimension) {
        return this.dataSet.recomputeLimits(this.permutation[dimension]);
    }

    public void setPermutation(int[] permutation) {
        if (permutation == null) {
            throw new IllegalArgumentException("permutation is null");
        }
        this.lock().writeLockGuard(() -> {
            if (permutation.length != this.nDims) {
                throw new IllegalArgumentException("Cannot change number of output dimensions");
            }
            for (int i = 0; i < this.dataSet.getDimension(); ++i) {
                if (permutation[i] < this.dataSet.getDimension()) continue;
                throw new IndexOutOfBoundsException("permutation[" + i + "] contains dimIndex='" + permutation[i] + "' outside DataSet dimension (" + this.dataSet.getDimension() + ")");
            }
            this.permutation = Arrays.copyOf(permutation, this.dataSet.getDimension());
            if (this.transposed) {
                int tmp = this.permutation[1];
                this.permutation[1] = this.permutation[0];
                this.permutation[0] = tmp;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.atDebug().addArgument((Object)this.permutation).log("applied permutation: {}");
            }
        });
        this.invokeListener(new AxisChangeEvent((EventSource)this, "Permutation changed", -1));
    }

    @Override
    public DataSet setStyle(String style) {
        return this.lock().writeLockGuard(() -> this.dataSet.setStyle(style));
    }

    @Override
    public double getValue(int dimIndex, double ... x) {
        return this.dataSet.getValue(this.permutation[dimIndex], this.dataSet.getIndex(this.permutation[0], x[0]));
    }

    @Override
    public DataSet set(DataSet other, boolean copy) {
        throw new UnsupportedOperationException("copy setting transposed data set is not implemented");
    }

    public void setTransposed(boolean transposed) {
        this.lock().writeLockGuard(() -> {
            if (this.transposed != transposed) {
                int tmp = this.permutation[1];
                this.permutation[1] = this.permutation[0];
                this.permutation[0] = tmp;
                this.transposed = transposed;
            }
        });
        this.invokeListener(new AxisChangeEvent((EventSource)this, "(Un)transposed", -1));
    }

    @Override
    public List<EventListener> updateEventListener() {
        return this.dataSet.updateEventListener();
    }

    public static TransposedDataSet permute(DataSet dataSet, int[] permutation) {
        if (dataSet instanceof GridDataSet) {
            return new TransposedGridDataSet((GridDataSet)dataSet, permutation);
        }
        return new TransposedDataSet(dataSet, permutation);
    }

    public static TransposedDataSet transpose(DataSet dataSet) {
        return TransposedDataSet.transpose(dataSet, true);
    }

    public static TransposedDataSet transpose(DataSet dataSet, boolean transpose) {
        if (dataSet instanceof GridDataSet) {
            return new TransposedGridDataSet((GridDataSet)dataSet, transpose);
        }
        return new TransposedDataSet(dataSet, transpose);
    }

    public static class TransposedGridDataSet
    extends TransposedDataSet
    implements GridDataSet {
        private static final long serialVersionUID = 19092601L;

        private TransposedGridDataSet(GridDataSet dataSet, boolean transposed) {
            super((DataSet)dataSet, transposed);
        }

        private TransposedGridDataSet(GridDataSet dataSet, int[] permutation) {
            super((DataSet)dataSet, permutation);
            if (permutation[0] > 1 || permutation[1] > 1 || permutation[2] != 2) {
                throw new IllegalArgumentException("cannot swap first x or y dimension with z dimension (index missmatch)");
            }
        }

        @Override
        public int getDataCount() {
            return this.dataSet.getDataCount();
        }

        @Override
        public void setPermutation(int[] permutation) {
            AssertUtils.notNull("permutation", permutation);
            this.lock().writeLockGuard(() -> {
                if (permutation[0] > 1 || permutation[1] > 1 || permutation[2] != 2) {
                    throw new IllegalArgumentException("cannot swap first x or y dimension with z dimension (index missmatch)");
                }
                super.setPermutation(permutation);
            });
            this.invokeListener(new AxisChangeEvent((EventSource)this, "Permutation changed", -1));
        }

        @Override
        public int getIndex(int dimIndex, double ... value) {
            AssertUtils.checkArrayDimension("value", value, this.getNGrid());
            return this.dataSet.getIndex(this.permutation[dimIndex], this.permute(value));
        }

        private double[] permute(double[] value) {
            double[] ret = new double[this.permutation.length];
            for (int i = 0; i < this.getNGrid(); ++i) {
                if (value.length <= this.permutation[i]) continue;
                ret[i] = value[this.permutation[i]];
            }
            return ret;
        }

        @Override
        public int[] getShape() {
            int[] shapeOrig = ((GridDataSet)this.dataSet).getShape();
            int[] shapePermuted = new int[shapeOrig.length];
            for (int i = 0; i < shapeOrig.length; ++i) {
                shapePermuted[i] = shapeOrig[this.permutation[i]];
            }
            return shapePermuted;
        }

        @Override
        public double getGrid(int dimIndex, int index) {
            return ((GridDataSet)this.dataSet).getGrid(this.permutation[dimIndex], index);
        }

        @Override
        public int getGridIndex(int dimIndex, double x) {
            return ((GridDataSet)this.dataSet).getGridIndex(this.permutation[dimIndex], x);
        }

        @Override
        public double get(int dimIndex, int ... indices) {
            int[] shapeOrig = ((GridDataSet)this.dataSet).getShape();
            int[] indicesPermuted = new int[shapeOrig.length];
            for (int i = 0; i < shapeOrig.length; ++i) {
                if (this.permutation[i] >= indices.length) continue;
                indicesPermuted[this.permutation[i]] = indices[i];
            }
            return ((GridDataSet)this.dataSet).get(this.permutation[dimIndex], indicesPermuted);
        }

        @Override
        public double getValue(int dimIndex, double ... x) {
            return this.dataSet.getValue(this.permutation[dimIndex], this.permute(x));
        }
    }
}

