/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.Histogram1D;
import de.gsi.dataset.Histogram2D;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractHistogram;
import de.gsi.dataset.spi.Histogram;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Histogram2
extends AbstractHistogram
implements Histogram2D {
    private static final long serialVersionUID = -5583974934398282519L;
    protected final Histogram xProjection;
    protected final Histogram yProjection;

    public Histogram2(String name, int nBinsX, double minX, double maxX, int nBinsY, double minY, double maxY, AbstractHistogram.HistogramOuterBounds boundsType) {
        super(name, nBinsX, minX, maxX, nBinsY, minY, maxY, boundsType);
        this.xProjection = new Histogram(name + "-Proj-X", nBinsX, minX, maxX, true, boundsType);
        this.yProjection = new Histogram(name + "-Proj-Y", nBinsY, minY, maxY, false, boundsType);
    }

    @Override
    public int fill(double x, double y) {
        return this.fill(x, y, 1.0);
    }

    @Override
    public int fill(double x, double y, double w) {
        int ret = this.lock().writeLockGuard(() -> {
            this.xProjection.fill(x, w);
            this.yProjection.fill(y, w);
            int bin = super.findBin(x, y);
            super.addBinContent(bin, w);
            return bin;
        });
        this.fireInvalidated(new UpdatedDataEvent(this, "fill()"));
        return ret;
    }

    @Override
    public int findFirstBinAbove(double x, double y) {
        return this.findBin(x, y);
    }

    @Override
    public double get(int dimIndex, int binIndex) {
        if (dimIndex == 2) {
            return this.getBinContent(binIndex);
        }
        return this.getBinCenter(dimIndex, binIndex + 1);
    }

    @Override
    public List<String> getErrorList() {
        return Collections.emptyList();
    }

    @Override
    public int getIndex(int dimIndex, double ... value) {
        AssertUtils.checkArrayDimension("value", value, 1);
        return this.findBin(dimIndex, value[0]);
    }

    @Override
    public List<String> getInfoList() {
        return Collections.emptyList();
    }

    public Histogram1D getProjectionX() {
        return this.xProjection;
    }

    public Histogram1D getProjectionY() {
        return this.yProjection;
    }

    protected double getSum(int dimIndex, int bin) {
        double sum = 0.0;
        for (int i = 0; i < this.getShape(dimIndex); ++i) {
            if (dimIndex == 0) {
                sum += this.get(2, i, bin);
                continue;
            }
            sum += this.get(2, bin, i);
        }
        return sum;
    }

    @Override
    public List<String> getWarningList() {
        String[] axisPrefix = new String[]{"-x", "-y", "-z"};
        LinkedList<String> retVal = new LinkedList<String>(super.getWarningList());
        for (int dim = 0; dim < this.getNGrid(); ++dim) {
            Object axisName;
            Object object = axisName = dim < axisPrefix.length ? axisPrefix[dim] : "-dim" + (dim + 1);
            if (this.getSum(dim, 0) > 0.0) {
                retVal.add("under-range" + (String)axisName);
            }
            if (!(this.getSum(dim, this.getDataCount() - 1) > 0.0)) continue;
            retVal.add("over-range" + (String)axisName);
        }
        return retVal;
    }

    @Override
    public double get(int dimIndex, int ... indices) {
        switch (dimIndex) {
            case 0: {
                return this.xProjection.get(dimIndex, indices[0]);
            }
            case 1: {
                return this.yProjection.get(dimIndex, indices[1]);
            }
            case 2: {
                int bin = indices[1] * this.getShape(0) + indices[0];
                return super.getBinContent(bin);
            }
        }
        throw new IndexOutOfBoundsException("dimIndex out of bounds");
    }

    @Override
    public void reset() {
        this.xProjection.reset();
        this.yProjection.reset();
        super.reset();
    }

    @Override
    public int[] getShape() {
        return new int[]{this.xProjection.getDataCount(), this.yProjection.getDataCount()};
    }

    @Override
    public double getGrid(int dimIndex, int index) {
        switch (dimIndex) {
            case 0: {
                return this.xProjection.get(0, index);
            }
            case 1: {
                return this.yProjection.get(0, index);
            }
        }
        throw new IndexOutOfBoundsException("dim Index out of bound 2");
    }

    @Override
    public DataSet set(DataSet other, boolean copy) {
        throw new UnsupportedOperationException("copy setting transposed data set is not implemented");
    }

    @Override
    public int getGridIndex(int dimIndex, double x) {
        if (dimIndex >= this.getNGrid()) {
            throw new IndexOutOfBoundsException("dim index out of bounds");
        }
        if (this.getShape(dimIndex) == 0) {
            return 0;
        }
        if (!Double.isFinite(x)) {
            return 0;
        }
        if (x <= this.getAxisDescription(dimIndex).getMin()) {
            return 0;
        }
        int lastIndex = this.getShape(dimIndex) - 1;
        if (x >= this.getAxisDescription(dimIndex).getMax()) {
            return lastIndex;
        }
        return Histogram2.binarySearch(x, 0, lastIndex, i -> this.getGrid(dimIndex, i));
    }
}

