/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet3D;
import de.gsi.dataset.GridDataSet;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractGridDataSet;
import de.gsi.dataset.spi.DefaultAxisDescription;
import de.gsi.dataset.spi.utils.MultiArrayDouble;
import java.util.Arrays;
import java.util.stream.IntStream;

public class DoubleGridDataSet
extends AbstractGridDataSet<DoubleGridDataSet>
implements DataSet3D {
    private static final long serialVersionUID = -493232313124620828L;
    protected transient double[][] grid;
    protected transient MultiArrayDouble[] values;
    protected transient int[] shape;
    protected transient int dataCount;

    public DoubleGridDataSet(GridDataSet another) {
        super(another.getName(), another.getDimension());
        this.set(another);
    }

    public DoubleGridDataSet(String name, int dims) {
        this(name, dims, new int[dims - 1]);
    }

    public DoubleGridDataSet(String name, int nDims, int[] shape) {
        super(name, nDims);
        int i;
        this.shape = shape;
        if (shape.length > nDims) {
            throw new IllegalArgumentException("nDims must be greater or equal to grid shape");
        }
        this.grid = new double[shape.length][];
        this.values = new MultiArrayDouble[nDims - shape.length];
        this.dataCount = 1;
        for (i = 0; i < shape.length; ++i) {
            this.dataCount *= shape[i];
            this.grid[i] = IntStream.range(0, shape[i]).asDoubleStream().toArray();
        }
        for (i = shape.length; i < nDims; ++i) {
            this.values[i - shape.length] = MultiArrayDouble.wrap(new double[this.dataCount], 0, shape);
        }
    }

    public DoubleGridDataSet(String name, int[] shape, boolean copy, double[] ... vals) {
        super(name, shape.length + vals.length);
        int i;
        int nDims = shape.length + vals.length;
        this.shape = (int[])shape.clone();
        this.grid = new double[shape.length][];
        this.values = new MultiArrayDouble[vals.length];
        this.dataCount = 1;
        for (i = 0; i < shape.length; ++i) {
            this.dataCount *= shape[i];
            this.grid[i] = IntStream.range(0, shape[i]).asDoubleStream().toArray();
        }
        for (i = shape.length; i < nDims; ++i) {
            if (vals[i - shape.length].length != this.dataCount) {
                throw new IllegalArgumentException("Dimension missmatch between grid and values");
            }
            this.values[i - shape.length] = MultiArrayDouble.wrap(copy ? (double[])vals[i - shape.length].clone() : vals[i - shape.length], 0, shape);
        }
    }

    public DoubleGridDataSet(String name, boolean copy, double[][] grid, double[] ... vals) {
        super(name, grid.length + vals.length);
        this.set(copy, grid, vals);
    }

    @Override
    public double get(int dimIndex, int index) {
        if (dimIndex < this.shape.length) {
            return this.grid[dimIndex][this.values[0].getIndices(index)[dimIndex]];
        }
        return this.values[dimIndex - this.shape.length].getStrided(index);
    }

    @Override
    public int getDataCount() {
        return this.dataCount;
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    @Override
    public int getShape(int dimIndex) {
        return this.shape[dimIndex];
    }

    @Override
    public double getGrid(int dimIndex, int index) {
        if (dimIndex >= this.shape.length) {
            throw new IndexOutOfBoundsException("Grid index out of bounds");
        }
        return this.grid[dimIndex][index];
    }

    @Override
    public double[] getGridValues(int dimIndex) {
        if (dimIndex >= this.shape.length) {
            throw new IndexOutOfBoundsException("Grid index out of bounds");
        }
        return this.grid[dimIndex];
    }

    @Override
    public double get(int dimIndex, int ... indices) {
        if (dimIndex < this.shape.length) {
            return this.grid[dimIndex][indices[dimIndex]];
        }
        return this.values[dimIndex - this.shape.length].get(indices);
    }

    @Override
    public double[] getValues(int dimIndex) {
        if (dimIndex >= this.shape.length) {
            return (double[])this.values[dimIndex - this.shape.length].elements();
        }
        return super.getValues(dimIndex);
    }

    public void set(boolean copy, double[][] grid, double[] ... vals) {
        this.lock().writeLockGuard(() -> {
            int i;
            int nDims = this.getDimension();
            if (nDims != grid.length + vals.length) {
                throw new IllegalArgumentException("grid + value dimensions must match dataset dimensions");
            }
            this.shape = Arrays.stream(grid).mapToInt(doubles -> ((double[])doubles).length).toArray();
            this.grid = copy ? (Object)new double[this.shape.length][] : grid;
            this.dataCount = 1;
            for (i = 0; i < this.shape.length; ++i) {
                this.dataCount *= this.shape[i];
                if (!copy) continue;
                this.grid[i] = (double[])grid[i].clone();
            }
            this.values = new MultiArrayDouble[vals.length];
            for (i = this.shape.length; i < nDims; ++i) {
                if (vals[i - this.shape.length].length != this.dataCount) {
                    throw new IllegalArgumentException("Dimension missmatch between grid and values");
                }
                this.values[i - this.shape.length] = MultiArrayDouble.wrap(copy ? (double[])vals[i - this.shape.length].clone() : vals[i - this.shape.length], 0, this.shape);
            }
        });
        this.fireInvalidated(new UpdatedDataEvent(this));
    }

    @Override
    public GridDataSet set(DataSet another, boolean copy) {
        if (!(another instanceof GridDataSet)) {
            throw new UnsupportedOperationException("other data set has to be of type GridDataSEt");
        }
        GridDataSet anotherGridDataSet = (GridDataSet)another;
        this.lock().writeLockGuard(() -> another.lock().writeLockGuard(() -> {
            int index;
            int i;
            int nDims = this.getDimension();
            if (nDims != another.getDimension()) {
                throw new IllegalArgumentException("datasets must have same number of dimensions to be assigned");
            }
            this.shape = (int[])anotherGridDataSet.getShape().clone();
            this.grid = new double[this.shape.length][];
            this.values = new MultiArrayDouble[nDims - this.shape.length];
            this.dataCount = 1;
            for (i = 0; i < this.shape.length; ++i) {
                this.dataCount *= this.shape[i];
                this.grid[i] = (double[])anotherGridDataSet.getGridValues(i).clone();
            }
            for (i = this.shape.length; i < nDims; ++i) {
                this.values[i - this.shape.length] = MultiArrayDouble.wrap((double[])another.getValues(i).clone(), 0, this.shape);
            }
            this.getDataLabelMap().clear();
            for (index = 0; index < anotherGridDataSet.getDataCount(); ++index) {
                String label = anotherGridDataSet.getDataLabel(index);
                if (label == null) continue;
                this.addDataLabel(index, label);
            }
            this.getDataStyleMap().clear();
            for (index = 0; index < anotherGridDataSet.getDataCount(); ++index) {
                String style = anotherGridDataSet.getStyle(index);
                if (style == null || style.isEmpty()) continue;
                this.addDataStyle(index, style);
            }
            this.setStyle(anotherGridDataSet.getStyle());
            for (int dimIndex = 0; dimIndex < this.getDimension(); ++dimIndex) {
                this.getAxisDescription(dimIndex).set(new DefaultAxisDescription(anotherGridDataSet.getAxisDescription(dimIndex)));
            }
        }));
        this.fireInvalidated(new UpdatedDataEvent(this));
        return this;
    }

    public GridDataSet set(int dimIndex, int[] indices, double value) {
        this.lock().writeLockGuard(() -> this.values[dimIndex - this.shape.length].set(indices, value));
        return (GridDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "set x_" + dimIndex + Arrays.toString(indices) + " = " + value));
    }

    public void clearData() {
        this.set(false, new double[this.shape.length][0], new double[1][0]);
    }
}

