/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.GridDataSet;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.DataRange;

public abstract class AbstractGridDataSet<U>
extends AbstractDataSet<AbstractGridDataSet<U>>
implements GridDataSet {
    public AbstractGridDataSet(String name, int dimension) {
        super(name, dimension);
    }

    @Override
    public int getGridIndex(int dimIndex, double x) {
        if (dimIndex >= this.getNGrid()) {
            throw new IndexOutOfBoundsException("dim index out of bounds");
        }
        if (this.getShape(dimIndex) == 0) {
            return 0;
        }
        if (!Double.isFinite(x)) {
            return 0;
        }
        if (x <= this.getAxisDescription(dimIndex).getMin()) {
            return 0;
        }
        int lastIndex = this.getShape(dimIndex) - 1;
        if (x >= this.getAxisDescription(dimIndex).getMax()) {
            return lastIndex;
        }
        return AbstractGridDataSet.binarySearch(x, 0, lastIndex, i -> this.getGrid(dimIndex, i));
    }

    @Override
    public double getValue(int dimIndex, double ... x) {
        int nGrid = this.getNGrid();
        int[] indices = new int[nGrid];
        double[] pos = new double[nGrid];
        for (int dim = 0; dim < nGrid; ++dim) {
            double x2;
            if (x[dim] < this.getAxisDescription(dim).getMin() || x[dim] > this.getAxisDescription(dim).getMax()) {
                return Double.NaN;
            }
            indices[dim] = this.getGridIndex(dim, x[dim]);
            double x1 = this.getGrid(dim, indices[dim]);
            if (x[dim] < x1) {
                x2 = x1;
                int n = dim;
                indices[n] = indices[n] - 1;
                x1 = this.getGrid(dim, indices[dim]);
            } else {
                x2 = this.getGrid(dim, indices[dim] + 1);
            }
            pos[dim] = (x2 - x[dim]) / (x2 - x1);
        }
        double result = 0.0;
        int[] indicesLoc = new int[nGrid];
        for (int cubeIdx = 0; cubeIdx < 1 << nGrid; ++cubeIdx) {
            System.arraycopy(indices, 0, indicesLoc, 0, nGrid);
            double cornerWeight = 1.0;
            for (int dim = 0; dim < nGrid; ++dim) {
                if ((cubeIdx >> dim & 1) > 0) {
                    int n = dim;
                    indicesLoc[n] = indicesLoc[n] + 1;
                    cornerWeight *= 1.0 - pos[dim];
                    continue;
                }
                cornerWeight *= pos[dim];
            }
            result += cornerWeight * this.get(dimIndex, indicesLoc);
        }
        return result;
    }

    @Override
    public DataSet recomputeLimits(int dimIndex) {
        DataRange newRange = new DataRange();
        if (dimIndex < this.getNGrid()) {
            int dataCount = this.getShape(dimIndex);
            for (int i = 0; i < dataCount; ++i) {
                newRange.add(this.getGrid(dimIndex, i));
            }
        } else {
            int dataCount = this.getDataCount();
            for (int i = 0; i < dataCount; ++i) {
                newRange.add(this.get(dimIndex, i));
            }
        }
        this.getAxisDescription(dimIndex).set(newRange.getMin(), newRange.getMax());
        return this;
    }
}

