/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils.serializer;

import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.serializer.MultiArray;
import java.lang.reflect.Array;
import java.util.Arrays;

class MultiArrayImpl<T>
implements MultiArray<T> {
    private final T elements;
    private final int elementCount;
    protected transient Object[] elementObject;
    protected transient boolean[] elementBoolean;
    protected transient byte[] elementByte;
    protected transient short[] elementShort;
    protected transient int[] elementInt;
    protected transient long[] elementLong;
    protected transient float[] elementFloat;
    protected transient double[] elementDouble;
    protected transient String[] elementString;
    private final int[] dimensions;

    MultiArrayImpl(T elements) {
        this(elements, new int[]{elements == null ? 0 : Array.getLength(elements)});
    }

    MultiArrayImpl(T elements, int[] dimensions) {
        AssertUtils.notNull("elements", elements);
        AssertUtils.notNull("dimensions", dimensions);
        this.elements = elements;
        this.elementCount = Array.getLength(elements);
        AssertUtils.gtEqThanZero("elements.length", this.elementCount);
        this.dimensions = dimensions;
        this.initPrimitiveArrays();
    }

    private void initPrimitiveArrays() {
        if (this.elements.getClass() == Object[].class) {
            this.elementObject = (Object[])this.elements;
        } else if (this.elements.getClass() == boolean[].class) {
            this.elementBoolean = (boolean[])this.elements;
        } else if (this.elements.getClass() == byte[].class) {
            this.elementByte = (byte[])this.elements;
        } else if (this.elements.getClass() == short[].class) {
            this.elementShort = (short[])this.elements;
        } else if (this.elements.getClass() == int[].class) {
            this.elementInt = (int[])this.elements;
        } else if (this.elements.getClass() == long[].class) {
            this.elementLong = (long[])this.elements;
        } else if (this.elements.getClass() == float[].class) {
            this.elementFloat = (float[])this.elements;
        } else if (this.elements.getClass() == double[].class) {
            this.elementDouble = (double[])this.elements;
        } else if (this.elements.getClass() == String[].class) {
            this.elementString = (String[])this.elements;
        }
    }

    @Override
    public T getElements() {
        return this.elements;
    }

    @Override
    public int getElementsCount() {
        return this.elementCount;
    }

    @Override
    public Object get(int index) {
        return this.elementObject[index];
    }

    @Override
    public int getIndex(int[] indices) {
        int index = 0;
        int multiplier = 1;
        for (int i = indices.length - 1; i >= 0; --i) {
            index += indices[i] * multiplier;
            multiplier *= this.getDimensions()[i];
        }
        return index;
    }

    @Override
    public Object get(int[] indices) {
        return this.get(this.getIndex(indices));
    }

    @Override
    public boolean getBoolean(int[] indices) {
        return this.elementBoolean[this.getIndex(indices)];
    }

    @Override
    public byte getByte(int[] indices) {
        return this.elementByte[this.getIndex(indices)];
    }

    @Override
    public short getShort(int[] indices) {
        return this.elementShort[this.getIndex(indices)];
    }

    @Override
    public int getInt(int[] indices) {
        return this.elementInt[this.getIndex(indices)];
    }

    @Override
    public long getLong(int[] indices) {
        return this.elementLong[this.getIndex(indices)];
    }

    @Override
    public float getFloat(int[] indices) {
        return this.elementFloat[this.getIndex(indices)];
    }

    @Override
    public double getDouble(int[] indices) {
        return this.elementDouble[this.getIndex(indices)];
    }

    @Override
    public String getString(int[] indices) {
        return this.elementString[this.getIndex(indices)];
    }

    @Override
    public int[] getDimensions() {
        return this.dimensions;
    }

    public String toString() {
        return String.format("MultiArray [dimensions = %s, elements = %s]", this.dimensions, this.elements.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.dimensions);
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.elements.getClass() != obj.getClass()) {
            return false;
        }
        MultiArrayImpl other = (MultiArrayImpl)obj;
        boolean retValue = false;
        try {
            if (Arrays.equals((Object[])other.elements, (Object[])this.elements)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Arrays.equals((boolean[])other.elements, (boolean[])this.elements)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            retValue = Arrays.equals((byte[])other.elements, (byte[])this.elements);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            retValue = Arrays.equals((short[])other.elements, (short[])this.elements);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            retValue = Arrays.equals((int[])other.elements, (int[])this.elements);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            retValue = Arrays.equals((long[])other.elements, (long[])this.elements);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            retValue = Arrays.equals((float[])other.elements, (float[])this.elements);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            retValue = Arrays.equals((double[])other.elements, (double[])this.elements);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retValue;
    }
}

