/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.testdata.spi;

import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractErrorDataSet;
import de.gsi.dataset.testdata.TestDataSet;

public abstract class AbstractTestFunction<D extends AbstractTestFunction<D>>
extends AbstractErrorDataSet<D>
implements TestDataSet<D> {
    private double[] data;
    private final Object dataLock = new Object();

    public AbstractTestFunction(String name, int count) {
        super(name);
        this.data = this.generateY(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public D update() {
        ((AbstractTestFunction)this.lock()).setAutoNotifaction(false);
        Object object = this.dataLock;
        synchronized (object) {
            this.data = this.generateY(this.data.length);
        }
        this.computeLimits();
        return (D)((AbstractTestFunction)((AbstractTestFunction)((AbstractTestFunction)this.setAutoNotifaction(true)).unlock()).fireInvalidated(new UpdatedDataEvent(this)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDataCount() {
        Object object = this.dataLock;
        synchronized (object) {
            return this.data.length;
        }
    }

    @Override
    public double getX(int index) {
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getY(int index) {
        Object object = this.dataLock;
        synchronized (object) {
            if (index < 0 || index >= this.getDataCount()) {
                return this.getUndefValue();
            }
            return this.data[index];
        }
    }

    @Override
    public double getXErrorNegative(int index) {
        return AbstractTestFunction.getXError();
    }

    @Override
    public double getXErrorPositive(int index) {
        return AbstractTestFunction.getXError();
    }

    @Override
    public double getYErrorNegative(int index) {
        return AbstractTestFunction.getYError();
    }

    @Override
    public double getYErrorPositive(int index) {
        return AbstractTestFunction.getYError();
    }

    private static double getXError() {
        return 0.1;
    }

    private static double getYError() {
        return 0.1;
    }

    @Override
    public DataSetError.ErrorType getErrorType() {
        return DataSetError.ErrorType.XY_ASYMMETRIC;
    }

    @Override
    public String getStyle(int index) {
        return null;
    }

    @Override
    public double[] generateX(int count) {
        double[] retVal = new double[count];
        for (int i = 0; i < count; ++i) {
            retVal[i] = i;
        }
        return retVal;
    }
}

