/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.utils.AssertUtils;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;

public class DoubleDataSet
extends AbstractDataSet<DoubleDataSet>
implements EditableDataSet {
    protected DoubleArrayList xValues;
    protected DoubleArrayList yValues;

    public DoubleDataSet(String name) {
        this(name, 0);
    }

    public DoubleDataSet(String name, int initalSize) {
        super(name);
        AssertUtils.gtEqThanZero("initalSize", initalSize);
        this.xValues = new DoubleArrayList(initalSize);
        this.yValues = new DoubleArrayList(initalSize);
    }

    public DoubleDataSet(DataSet another) {
        super(another.getName());
        this.set(another);
    }

    public DoubleDataSet(String name, double[] xValues, double[] yValues, int initalSize, boolean deepCopy) {
        super(name);
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("Y data", yValues);
        int dataMaxIndex = Math.min(xValues.length, Math.min(yValues.length, initalSize));
        AssertUtils.equalDoubleArrays(xValues, yValues, initalSize);
        if (deepCopy) {
            int size = Math.min(dataMaxIndex, initalSize);
            this.xValues = new DoubleArrayList(initalSize);
            this.yValues = new DoubleArrayList(initalSize);
            this.resize(initalSize);
            System.arraycopy(xValues, 0, this.xValues.elements(), 0, size);
            System.arraycopy(yValues, 0, this.yValues.elements(), 0, size);
        } else {
            this.xValues = DoubleArrayList.wrap((double[])xValues);
            this.yValues = DoubleArrayList.wrap((double[])yValues);
        }
    }

    @Override
    public double[] getXValues() {
        return this.xValues.elements();
    }

    @Override
    public double[] getYValues() {
        return this.yValues.elements();
    }

    @Override
    public int getDataCount() {
        return Math.min(this.xValues.size(), this.yValues.size());
    }

    public DoubleDataSet clearData() {
        this.lock();
        this.xValues.clear();
        this.yValues.clear();
        this.dataLabels.clear();
        this.dataStyles.clear();
        this.clearMetaInfo();
        this.xRange.empty();
        this.yRange.empty();
        return (DoubleDataSet)((DoubleDataSet)this.unlock()).fireInvalidated(new RemovedDataEvent(this, "clearData()"));
    }

    public int getCapacity() {
        return Math.min(this.xValues.elements().length, this.yValues.elements().length);
    }

    public DoubleDataSet increaseCapacity(int amount) {
        this.lock();
        int size = this.getDataCount();
        boolean auto = this.isAutoNotification();
        this.setAutoNotifaction(false);
        this.resize(this.getCapacity() + amount);
        this.resize(size);
        this.setAutoNotifaction(auto);
        return (DoubleDataSet)this.unlock();
    }

    public DoubleDataSet resize(int size) {
        this.lock();
        this.xValues.size(size);
        this.yValues.size(size);
        return (DoubleDataSet)((DoubleDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this, "increaseCapacity()"));
    }

    public DoubleDataSet trim() {
        this.lock();
        this.xValues.trim(0);
        this.yValues.trim(0);
        return (DoubleDataSet)((DoubleDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this, "increaseCapacity()"));
    }

    @Override
    public double getX(int index) {
        return this.xValues.elements()[index];
    }

    @Override
    public double getY(int index) {
        return this.yValues.elements()[index];
    }

    public DoubleDataSet add(double x, double y) {
        return this.add(this.getDataCount(), x, y, null);
    }

    public DoubleDataSet add(double x, double y, String label) {
        this.lock();
        this.xValues.add(x);
        this.yValues.add(y);
        if (label != null && !label.isEmpty()) {
            this.addDataLabel(this.xValues.size() - 1, label);
        }
        this.xRange.add(x);
        this.yRange.add(y);
        return (DoubleDataSet)((DoubleDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this, "add"));
    }

    public DoubleDataSet add(double[] xValuesNew, double[] yValuesNew) {
        this.lock();
        AssertUtils.notNull("X coordinates", xValuesNew);
        AssertUtils.notNull("Y coordinates", yValuesNew);
        AssertUtils.equalDoubleArrays(xValuesNew, yValuesNew);
        this.xValues.addElements(this.xValues.size(), xValuesNew);
        this.yValues.addElements(this.yValues.size(), yValuesNew);
        this.xRange.add(xValuesNew);
        this.yRange.add(yValuesNew);
        return (DoubleDataSet)((DoubleDataSet)this.unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    @Override
    public DoubleDataSet add(int index, double x, double y) {
        return this.add(index, x, y, null);
    }

    public DoubleDataSet add(int index, double x, double y, String label) {
        this.lock();
        int indexAt = Math.max(0, Math.min(index, this.getDataCount() + 1));
        this.xValues.add(indexAt, x);
        this.yValues.add(indexAt, y);
        this.dataLabels.addValueAndShiftKeys(indexAt, this.xValues.size(), label);
        this.dataStyles.shiftKeys(indexAt, this.xValues.size());
        this.xRange.add(x);
        this.yRange.add(y);
        return (DoubleDataSet)((DoubleDataSet)this.unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    public DoubleDataSet add(int index, double[] x, double[] y) {
        this.lock();
        AssertUtils.notNull("X coordinates", x);
        AssertUtils.notNull("Y coordinates", y);
        int min = Math.min(x.length, y.length);
        AssertUtils.equalDoubleArrays(x, y, min);
        int indexAt = Math.max(0, Math.min(index, this.getDataCount() + 1));
        this.xValues.addElements(indexAt, x, 0, min);
        this.yValues.addElements(indexAt, y, 0, min);
        this.xRange.add(x, min);
        this.yRange.add(y, min);
        this.dataLabels.shiftKeys(indexAt, this.xValues.size());
        this.dataStyles.shiftKeys(indexAt, this.xValues.size());
        return (DoubleDataSet)((DoubleDataSet)this.unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    @Override
    public EditableDataSet remove(int index) {
        return this.remove(index, index + 1);
    }

    public DoubleDataSet remove(int fromIndex, int toIndex) {
        this.lock();
        AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
        AssertUtils.indexInBounds(toIndex, this.getDataCount(), "toIndex");
        AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
        this.xValues.removeElements(fromIndex, toIndex);
        this.yValues.removeElements(fromIndex, toIndex);
        this.dataLabels.remove(fromIndex, toIndex);
        this.dataLabels.remove(fromIndex, toIndex);
        this.xRange.empty();
        this.yRange.empty();
        return (DoubleDataSet)((DoubleDataSet)this.unlock()).fireInvalidated(new RemovedDataEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DoubleDataSet set(int index, double x, double y) {
        this.lock();
        try {
            int dataCount = Math.max(index + 1, this.getDataCount());
            this.xValues.size(dataCount);
            this.yValues.size(dataCount);
            this.xValues.elements()[index] = x;
            this.yValues.elements()[index] = y;
            this.dataLabels.remove(index);
            this.dataStyles.remove(index);
            this.xRange.empty();
            this.yRange.empty();
        }
        finally {
            this.unlock();
        }
        return (DoubleDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "set - single"));
    }

    public DoubleDataSet set(double[] xValues, double[] yValues, boolean copy) {
        this.lock();
        AssertUtils.notNull("X coordinates", xValues);
        AssertUtils.notNull("Y coordinates", yValues);
        int dataMaxIndex = Math.min(xValues.length, yValues.length);
        AssertUtils.equalDoubleArrays(xValues, yValues, dataMaxIndex);
        this.dataLabels.clear();
        this.dataStyles.clear();
        if (copy) {
            this.resize(0);
            this.xValues.addElements(0, xValues);
            this.yValues.addElements(0, yValues);
        } else {
            this.xValues = DoubleArrayList.wrap((double[])xValues);
            this.yValues = DoubleArrayList.wrap((double[])yValues);
        }
        this.computeLimits();
        return (DoubleDataSet)((DoubleDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this));
    }

    public DoubleDataSet set(double[] xValues, double[] yValues) {
        return this.set(xValues, yValues, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleDataSet set(int index, double[] x, double[] y) {
        this.lock();
        try {
            this.resize(Math.max(index + x.length, this.xValues.size()));
            System.arraycopy(x, 0, this.xValues.elements(), index, x.length);
            System.arraycopy(y, 0, this.yValues.elements(), index, y.length);
            this.dataLabels.remove(index, index + x.length);
            this.dataStyles.remove(index, index + x.length);
            this.xRange.empty();
            this.yRange.empty();
        }
        finally {
            this.unlock();
        }
        return (DoubleDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "set - via arrays"));
    }

    public DoubleDataSet set(DataSet other) {
        int index;
        this.lock();
        other.lock();
        boolean oldAuto = this.isAutoNotification();
        this.setAutoNotifaction(false);
        this.dataLabels.clear();
        for (index = 0; index < other.getDataCount(); ++index) {
            String label = other.getDataLabel(index);
            if (label == null || label.isEmpty()) continue;
            this.addDataLabel(index, label);
        }
        this.dataStyles.clear();
        for (index = 0; index < other.getDataCount(); ++index) {
            String style = other.getStyle(index);
            if (style == null || style.isEmpty()) continue;
            this.addDataStyle(index, style);
        }
        this.setStyle(other.getStyle());
        this.set(other.getXValues(), other.getYValues(), true);
        this.setAutoNotifaction(oldAuto);
        other.unlock();
        return (DoubleDataSet)((DoubleDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this));
    }
}

