/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.InvalidatedEvent;
import de.gsi.dataset.spi.AbstractErrorDataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.CircularBuffer;
import de.gsi.dataset.utils.DoubleCircularBuffer;

public class CircularDoubleErrorDataSet
extends AbstractErrorDataSet<DoubleErrorDataSet>
implements DataSetError {
    protected DoubleCircularBuffer xValues;
    protected DoubleCircularBuffer yValues;
    protected DoubleCircularBuffer yErrorsPos;
    protected DoubleCircularBuffer yErrorsNeg;
    protected CircularBuffer<String> dataTag;
    protected CircularBuffer<String> dataStyles;

    public CircularDoubleErrorDataSet(String name, int initalSize) {
        super(name);
        AssertUtils.gtEqThanZero("initalSize", initalSize);
        this.xValues = new DoubleCircularBuffer(initalSize);
        this.yValues = new DoubleCircularBuffer(initalSize);
        this.yErrorsPos = new DoubleCircularBuffer(initalSize);
        this.yErrorsNeg = new DoubleCircularBuffer(initalSize);
        this.dataTag = new CircularBuffer(initalSize);
        this.dataStyles = new CircularBuffer(initalSize);
        this.setErrorType(DataSetError.ErrorType.Y_ASYMMETRIC);
    }

    @Override
    public int getDataCount() {
        return this.xValues.available();
    }

    @Override
    public double getX(int index) {
        return this.xValues.get(index);
    }

    @Override
    public double getY(int index) {
        return this.yValues.get(index);
    }

    @Override
    public double getXErrorNegative(int index) {
        return 0.0;
    }

    @Override
    public double getXErrorPositive(int index) {
        return 0.0;
    }

    @Override
    public double getYErrorNegative(int index) {
        return this.yErrorsNeg.get(index);
    }

    @Override
    public double getYErrorPositive(int index) {
        return this.yErrorsPos.get(index);
    }

    public CircularDoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos, String tag, String style) {
        this.lock();
        this.xValues.put(x);
        this.yValues.put(y);
        this.yErrorsPos.put(yErrorPos);
        this.yErrorsNeg.put(yErrorNeg);
        this.dataTag.put(tag);
        this.dataStyles.put(style);
        this.computeLimits();
        this.unlock();
        this.fireInvalidated(new InvalidatedEvent(this));
        return this;
    }

    public CircularDoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos, String tag) {
        return this.add(x, y, yErrorNeg, yErrorPos, tag, null);
    }

    public CircularDoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos) {
        return this.add(x, y, yErrorNeg, yErrorPos, null);
    }

    public CircularDoubleErrorDataSet add(double[] xVals, double[] yVals, double[] yErrNeg, double[] yErrPos) {
        this.lock();
        AssertUtils.notNull("X coordinates", xVals);
        AssertUtils.notNull("Y coordinates", yVals);
        AssertUtils.notNull("Y error neg", yErrNeg);
        AssertUtils.notNull("Y error pos", yErrPos);
        AssertUtils.equalDoubleArrays(xVals, yVals);
        AssertUtils.equalDoubleArrays(xVals, yErrNeg);
        AssertUtils.equalDoubleArrays(xVals, yErrPos);
        this.xValues.put(xVals, xVals.length);
        this.yValues.put(yVals, yVals.length);
        this.yErrorsNeg.put(yErrNeg, yErrNeg.length);
        this.yErrorsPos.put(yErrPos, yErrPos.length);
        this.dataTag.put((String[])new String[yErrPos.length], yErrPos.length);
        this.dataStyles.put((String[])new String[yErrPos.length], yErrPos.length);
        this.computeLimits();
        this.unlock();
        this.fireInvalidated(new InvalidatedEvent(this));
        return this;
    }

    public CircularDoubleErrorDataSet reset() {
        this.lock();
        this.xValues.reset();
        this.yValues.reset();
        this.yErrorsNeg.reset();
        this.yErrorsPos.reset();
        this.dataTag.reset();
        this.dataStyles.reset();
        this.xRange.empty();
        this.yRange.empty();
        this.unlock();
        this.fireInvalidated(new InvalidatedEvent(this));
        return this;
    }

    @Override
    public String getDataLabel(int index) {
        String tag = this.dataTag.get(index);
        if (tag == null) {
            return this.getName() + "(" + index + "," + this.getX(index) + "," + this.getY(index) + ")";
        }
        return tag;
    }

    @Override
    public String getStyle(int index) {
        return this.dataStyles.get(index);
    }
}

