/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet3D;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.DataRange;

public abstract class AbstractDataSet3D<D extends AbstractDataSet3D<D>>
extends AbstractDataSet<D>
implements DataSet3D {
    protected DataRange zRange = new DataRange();

    public AbstractDataSet3D(String name) {
        super(name);
    }

    @Override
    public int getDataCount() {
        return this.getXDataCount() * this.getYDataCount();
    }

    @Override
    public DataRange getZRange() {
        if (!this.zRange.isDefined()) {
            this.computeLimits();
        }
        return this.zRange;
    }

    @Override
    protected D computeLimits() {
        int i;
        this.lock();
        this.xRange.empty();
        this.yRange.empty();
        this.zRange.empty();
        int xDataCount = this.getXDataCount();
        int yDataCount = this.getYDataCount();
        for (i = 0; i < xDataCount; ++i) {
            for (int j = 0; j < yDataCount; ++j) {
                this.zRange.add(this.getZ(i, j));
            }
            this.xRange.add(this.getX(i));
        }
        for (i = 0; i < yDataCount; ++i) {
            this.yRange.add(this.getY(i));
        }
        return (D)((AbstractDataSet3D)this.unlock());
    }

    @Override
    public int getXIndex(double x) {
        if (this.getXDataCount() == 0) {
            return 0;
        }
        if (x < this.getX(0)) {
            return 0;
        }
        int lastIndex = this.getXDataCount() - 1;
        if (x > this.getX(lastIndex)) {
            return lastIndex;
        }
        return this.binarySearchX(x, 0, lastIndex);
    }

    @Override
    public int getYIndex(double y) {
        if (this.getYDataCount() == 0) {
            return 0;
        }
        if (y < this.getY(0)) {
            return 0;
        }
        int lastIndex = this.getYDataCount() - 1;
        if (y > this.getY(lastIndex)) {
            return lastIndex;
        }
        return this.binarySearchY(y, 0, lastIndex);
    }
}

