/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.renderer.spi.ContourDataSetRenderer;
import de.gsi.chart.renderer.spi.utils.ColorGradient;
import de.gsi.chart.utils.AxisSynchronizer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet3D;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.math.TMath;
import de.gsi.math.samples.EMDSample;
import de.gsi.math.samples.utils.AbstractDemoApplication;
import de.gsi.math.samples.utils.DemoChart;
import de.gsi.math.spectra.SpectrumTools;
import de.gsi.math.spectra.fft.DoubleFFT_1D;
import de.gsi.math.spectra.wavelet.ContinuousWavelet;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Random;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.layout.VBox;

public class WaveletScalogram
extends AbstractDemoApplication {
    private static final int MAX_POINTS = 1024;
    public static final boolean LOAD_EXAMPLE_DATA = true;
    private DataSet3D fdataset;
    private DefaultDataSet fwavelet;
    private DefaultDataSet ffourier;
    private double[] yValues;

    private DataSet3D createDataSet() {
        double nu = 50.0;
        int nQuantx = 512;
        int nQuanty = 1024;
        double fmin = 0.05;
        double fmax = 0.5;
        this.yValues = this.readDemoData(1);
        final ContinuousWavelet wtrafo = new ContinuousWavelet();
        new Thread(){

            @Override
            public void run() {
                WaveletScalogram.this.fdataset = (DataSet3D)wtrafo.getScalogram(WaveletScalogram.this.yValues, 512, 1024, 50.0, 0.05, 0.5);
            }
        }.start();
        do {
            this.sleep(1000);
            int status = wtrafo.getStatus();
            if (status <= 10) continue;
            System.out.println(status + " % of computation done");
        } while (wtrafo.isBusy());
        this.sleep(1000);
        DoubleFFT_1D fft = new DoubleFFT_1D(this.yValues.length);
        double[] fftSpectra = Arrays.copyOf(this.yValues, this.yValues.length);
        fft.realForward(fftSpectra);
        double[] frequency1 = wtrafo.getScalogramFrequencyAxis(512, 1024, 50.0, 0.05, 0.5);
        double[] magWavelet = new double[frequency1.length];
        int nboundary = this.fdataset.getXDataCount() / 20;
        for (int i = 0; i < this.fdataset.getYDataCount(); ++i) {
            double val = 0.0;
            int count = 0;
            for (int j = nboundary; j < this.fdataset.getXDataCount() - nboundary; ++j) {
                val += this.fdataset.getZ(j, i);
                ++count;
            }
            magWavelet[i] = val / (double)count;
        }
        double[] magFourier = SpectrumTools.computeMagnitudeSpectrum_dB((double[])fftSpectra, (boolean)true);
        double[] frequency2 = SpectrumTools.computeFrequencyScale((int)(fftSpectra.length / 2));
        double maxWavelet = TMath.Maximum((double[])magWavelet);
        int i = 0;
        while (i < magWavelet.length) {
            int n = i++;
            magWavelet[n] = magWavelet[n] - maxWavelet;
        }
        double maxFourier = TMath.Maximum((double[])magFourier);
        int i2 = 0;
        while (i2 < magFourier.length) {
            int n = i2++;
            magFourier[n] = magFourier[n] - maxFourier;
        }
        this.fwavelet = new DefaultDataSet("Wavelet magnitude", frequency1, magWavelet, frequency1.length, true);
        this.ffourier = new DefaultDataSet("Fourier magnitude", frequency2, magFourier, frequency2.length, true);
        return this.fdataset;
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    private double[] loadSyntheticData() {
        double[] yModel = new double[1024];
        Random rnd = new Random();
        for (int i = 0; i < this.yValues.length; ++i) {
            double x = i;
            double offset = 0.0;
            double error = 0.1 * rnd.nextGaussian();
            offset = i > 500 ? -20.0 : 0.0;
            yModel[i] = i > 100 && i < 700 ? 0.7 * Math.sin(TMath.TwoPi() * 2.0E-4 * x * (x + offset)) : 0.0;
            int n = i;
            yModel[n] = yModel[n] + (i > 50 && i < 500 ? 1.0 * Math.sin(TMath.TwoPi() * 0.25 * x) : 0.0);
            double mod = Math.cos(TMath.TwoPi() * 0.01 * x);
            int n2 = i;
            yModel[n2] = yModel[n2] + (i > 300 && i < 900 ? 1.0 * Math.sin(TMath.TwoPi() * (0.4 - 5.0E-4 * mod) * x) : 0.0);
            int n3 = i;
            yModel[n3] = yModel[n3] + 0.5 * Math.sin(TMath.TwoPi() * ((0.1 + 5.0E-8 * x * x) * x));
            yModel[i] = yModel[i] + error;
        }
        return yModel;
    }

    @Override
    public Node getContent() {
        DemoChart chart1 = new DemoChart();
        chart1.getXAxis().setLabel("time");
        chart1.getXAxis().setUnit("turns");
        chart1.getYAxis().setAutoRangeRounding(false);
        chart1.getYAxis().setAutoRangePadding(0.0);
        chart1.getYAxis().setLabel("frequency");
        chart1.getYAxis().setUnit("fs");
        ContourDataSetRenderer contourChartRenderer = new ContourDataSetRenderer();
        chart1.getRenderers().set(0, (Object)contourChartRenderer);
        contourChartRenderer.setColorGradient(ColorGradient.RAINBOW);
        contourChartRenderer.getDatasets().add((Object)this.createDataSet());
        DemoChart chart2 = new DemoChart();
        chart2.getXAxis().setLabel("frequency");
        chart2.getXAxis().setUnit("fs");
        chart2.getYAxis().setLabel("magnitude");
        chart1.getXAxis().setAutoRangeRounding(false);
        chart1.getXAxis().setAutoRangePadding(0.0);
        chart2.getDatasets().addAll((Object[])new DataSet[]{this.fwavelet, this.ffourier});
        AxisSynchronizer sync = new AxisSynchronizer();
        sync.add((Axis)chart2.getXAxis());
        sync.add((Axis)chart1.getYAxis());
        return new VBox(new Node[]{chart1, chart2});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private double[] readDemoData(int index) {
        String fileName = index <= 1 ? "./rawDataCPS2.dat" : "./rawDataLHCInj.dat";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(EMDSample.class.getResourceAsStream(fileName)));){
            String line = reader.readLine();
            int nDim = line == null ? 0 : Integer.parseInt(line);
            double[] ret = new double[nDim];
            for (int i = 0; i < nDim && (line = reader.readLine()) != null; ++i) {
                String[] x = line.split("\t");
                ret[i] = Double.parseDouble(x[1]);
            }
            double[] dArray = ret;
            return dArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new double[1000];
        }
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

