/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.math.TMath;
import de.gsi.math.TMathConstants;
import de.gsi.math.functions.RandomWalkFunction;
import de.gsi.math.samples.WaveletScalogram;
import de.gsi.math.samples.utils.AbstractDemoApplication;
import de.gsi.math.samples.utils.DemoChart;
import de.gsi.math.spectra.wavelet.CDFWavelet;
import de.gsi.math.spectra.wavelet.FastWaveletTransform;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Random;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.layout.VBox;

public class WaveletDenoising
extends AbstractDemoApplication {
    private static final int MAX_POINTS = 512;
    private static final boolean LOAD_EXAMPLE_DATA = false;
    private DataSet fraw;
    private DataSet fdata;
    private DataSet freconstructed;
    private DataSet fspectraModel;
    private DataSet fspectra;
    private DataSet fspectraFit;

    private void initData() {
        int i;
        RandomWalkFunction func = new RandomWalkFunction("rand1", 0.1);
        double[] xValues = new double[512];
        double[] yValues = new double[512];
        double[] yModel = new double[512];
        Random rnd = new Random();
        for (int i2 = 0; i2 < xValues.length; ++i2) {
            double x = i2;
            double offset = 0.0;
            double error = 0.2 * rnd.nextGaussian();
            if (i2 > xValues.length / 2) {
                offset = -0.05;
            }
            xValues[i2] = x;
            yValues[i2] = func.getValue(0.0);
            yModel[i2] = Math.sin(TMathConstants.TwoPi() * 3.0E-4 * x * (x + offset));
            yModel[i2] = Math.sin(TMathConstants.TwoPi() * 0.05 * x);
            if (i2 < 100 || i2 > 400) {
                yModel[i2] = 0.0;
            }
            yValues[i2] = yModel[i2] + 0.0 * error;
        }
        CDFWavelet wvTrafo1 = new CDFWavelet();
        FastWaveletTransform wvTrafo3 = new FastWaveletTransform();
        boolean trafo1 = false;
        double[] ySmooth = Arrays.copyOf(yValues, yValues.length);
        double[] ySModel = Arrays.copyOf(yModel, yModel.length);
        wvTrafo3.transform(ySmooth);
        wvTrafo3.transform(ySModel);
        double[] recon = Arrays.copyOf(ySmooth, yValues.length);
        double[] reconAbs = Arrays.copyOf(ySmooth, yValues.length);
        for (i = 0; i < reconAbs.length; ++i) {
            reconAbs[i] = Math.abs(recon[i]);
        }
        for (i = 0; i < 0; ++i) {
            recon[i] = 0.0;
        }
        this.fspectraModel = new DefaultDataSet("model", xValues, ySModel, xValues.length, true);
        this.fspectra = new DefaultDataSet("raw data", xValues, ySmooth, xValues.length, true);
        this.fspectraFit = new DefaultDataSet("reconstructed", xValues, Arrays.copyOf(recon, recon.length), xValues.length, true);
        wvTrafo3.invTransform(recon);
        double error1 = TMath.RMS((double[])TMath.Difference((double[])yValues, (double[])yModel));
        double error2 = TMath.RMS((double[])TMath.Difference((double[])recon, (double[])yModel));
        if (error1 > error2) {
            System.out.printf("improved noise floor from %f \t-> %f \t(%f %%)\n", error1, error2, (error1 - error2) / error1 * 100.0);
        } else {
            System.err.printf("deteriorated noise floor from %f \t-> %f \t(%f %%)\n", error1, error2, (error1 - error2) / error1 * 100.0);
        }
        this.fdata = new DefaultDataSet("model ", xValues, yModel, xValues.length, true);
        this.fraw = new DefaultDataSet("raw data", xValues, yValues, xValues.length, true);
        this.freconstructed = new DefaultDataSet("reconstructed", xValues, recon, xValues.length, true);
    }

    @Override
    public Node getContent() {
        this.initData();
        DemoChart chart1 = new DemoChart();
        chart1.getXAxis().setLabel("time");
        chart1.getDatasets().addAll((Object[])new DataSet[]{this.fdata, this.fraw, this.freconstructed});
        DemoChart chart2 = new DemoChart();
        chart2.getXAxis().setLabel("frequency");
        chart2.getDatasets().addAll((Object[])new DataSet[]{this.fspectraModel, this.fspectra, this.fspectraFit});
        return new VBox(new Node[]{chart1, chart2});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private double[][] readDemoData() {
        String fileName = "./BBQSpectra.dat";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(WaveletScalogram.class.getResourceAsStream("./BBQSpectra.dat")));){
            String line = reader.readLine();
            int nDim = line == null ? 0 : Integer.parseInt(line);
            double[][] ret = new double[2][nDim];
            for (int i = 0; i < nDim && (line = reader.readLine()) != null; ++i) {
                String[] x = line.split("\t");
                ret[0][i] = Double.parseDouble(x[0]);
                ret[1][i] = Double.parseDouble(x[1]);
            }
            double[][] dArray = ret;
            return dArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new double[10][10];
        }
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

