/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.marker.DefaultMarker;
import de.gsi.chart.marker.Marker;
import de.gsi.chart.plugins.DataPointTooltip;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.LineStyle;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.dataset.spi.DefaultErrorDataSet;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;

public class ScatterAndBubbleRendererSample
extends Application {
    private static String demoDataFile = "testdata/2017_OECD_data.csv";
    private final Map<String, Double> lifeExpectancyWomen = new ConcurrentHashMap<String, Double>();
    private final Map<String, Double> lifeExpectancyMen = new ConcurrentHashMap<String, Double>();
    private final Map<String, Double> gdpPerCapita = new ConcurrentHashMap<String, Double>();
    private final Map<String, Double> population = new ConcurrentHashMap<String, Double>();
    private double maxPopulation = 1.0;

    public void start(Stage primaryStage) {
        this.loadDemoData(demoDataFile);
        ProcessingProfiler.setVerboseOutputState((boolean)true);
        ProcessingProfiler.setLoggerOutputState((boolean)true);
        ProcessingProfiler.setDebugState((boolean)false);
        DefaultErrorDataSet bubbleDataSet1a = new DefaultErrorDataSet("women");
        DefaultErrorDataSet bubbleDataSet1b = new DefaultErrorDataSet("men");
        DefaultDataSet bubbleDataSet2a = new DefaultDataSet("women");
        DefaultDataSet bubbleDataSet2b = new DefaultDataSet("men");
        Map sortedGDP = this.gdpPerCapita.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
        int count = 0;
        for (Map.Entry entry : sortedGDP.entrySet()) {
            String country = (String)entry.getKey();
            double gdp = (Double)entry.getValue();
            double popSize = 0.2 * this.population.get(country) / this.maxPopulation;
            bubbleDataSet1a.add(gdp, this.lifeExpectancyWomen.get(country).doubleValue(), Math.sqrt(popSize), Math.sqrt(popSize), country);
            bubbleDataSet1b.add(gdp, this.lifeExpectancyMen.get(country).doubleValue(), Math.sqrt(popSize), Math.sqrt(popSize), country);
            bubbleDataSet2a.add(gdp, this.lifeExpectancyWomen.get(country).doubleValue(), country);
            bubbleDataSet2b.add(gdp, this.lifeExpectancyMen.get(country).doubleValue(), country);
            String markerSize = "markerSize=" + 40.0 * Math.sqrt(this.population.get(country) / this.maxPopulation) + "; index=" + count + ";";
            bubbleDataSet2a.addDataStyle(count, markerSize);
            bubbleDataSet2b.addDataStyle(count, markerSize);
            if (country.equals("FRA")) {
                bubbleDataSet2a.addDataStyle(count, markerSize + "markerColor=darkblue; markerType=circle2;");
                bubbleDataSet2b.addDataStyle(count, markerSize + "markerColor=darkred; markerType=circle2;");
            } else if (country.equals("JPN")) {
                bubbleDataSet2a.addDataStyle(count, markerSize + "markerColor=green; markerType=diamond;");
                bubbleDataSet2b.addDataStyle(count, markerSize + "markerColor=lightgreen; markerType=diamond;");
            }
            ++count;
        }
        Chart chart1 = ScatterAndBubbleRendererSample.getDefaultChart("Bubble-Chart via DataSetError interface");
        ErrorDataSetRenderer errorRenderer1 = new ErrorDataSetRenderer();
        errorRenderer1.setMarkerSize(1.0);
        errorRenderer1.setPolyLineStyle(LineStyle.NONE);
        errorRenderer1.setErrorType(ErrorStyle.ERRORBARS);
        errorRenderer1.setDrawMarker(false);
        errorRenderer1.setDrawBubbles(true);
        chart1.getRenderers().setAll((Object[])new Renderer[]{errorRenderer1});
        errorRenderer1.getDatasets().addAll((Object[])new DataSet[]{bubbleDataSet1a, bubbleDataSet1b});
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(new Scene((Parent)chart1, 800.0, 600.0));
        primaryStage.setOnCloseRequest(evt -> System.exit(0));
        primaryStage.show();
        Stage secondaryStage = new Stage();
        Chart chart2 = ScatterAndBubbleRendererSample.getDefaultChart("Scatter-Chart via addDataStyle(<index>, <String>) interface");
        ErrorDataSetRenderer errorRenderer2 = new ErrorDataSetRenderer();
        errorRenderer2.setMarkerSize(5.0);
        errorRenderer2.setPolyLineStyle(LineStyle.NONE);
        errorRenderer2.setErrorType(ErrorStyle.NONE);
        errorRenderer2.setDrawMarker(true);
        bubbleDataSet2a.setStyle("markerType=circle;");
        bubbleDataSet2b.setStyle("markerType=circle;");
        errorRenderer2.setMarker((Marker)DefaultMarker.DIAMOND);
        errorRenderer2.setDrawBubbles(false);
        chart2.getRenderers().setAll((Object[])new Renderer[]{errorRenderer2});
        errorRenderer2.getDatasets().addAll((Object[])new DataSet[]{bubbleDataSet2a, bubbleDataSet2b});
        secondaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        secondaryStage.setScene(new Scene((Parent)chart2, 800.0, 600.0));
        secondaryStage.setOnCloseRequest(evt -> System.exit(0));
        secondaryStage.show();
    }

    private static Chart getDefaultChart(String title) {
        DefaultNumericAxis xAxis = new DefaultNumericAxis("GDP", "USD/capita");
        xAxis.setAutoUnitScaling(true);
        xAxis.setAutoRangePadding(0.05);
        xAxis.setAutoRanging(false);
        xAxis.setLowerBound(15000.0);
        xAxis.setUpperBound(75000.0);
        DefaultNumericAxis yAxis = new DefaultNumericAxis("life-expectancy", "years");
        yAxis.setAutoRangePadding(0.05);
        XYChart chart = new XYChart((Axis)xAxis, (Axis)yAxis);
        chart.setTitle(title);
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new DataPointTooltip());
        HBox.setHgrow((Node)chart, (Priority)Priority.ALWAYS);
        return chart;
    }

    private void loadDemoData(String fileName) {
        try (BufferedReader csvReader = Files.newBufferedReader(Paths.get(((Object)((Object)this)).getClass().getResource(fileName).toURI()));){
            String row = csvReader.readLine();
            while ((row = csvReader.readLine()) != null) {
                String[] data = row.split(",");
                double pop = 1000000.0 * Double.parseDouble(data[7]);
                this.maxPopulation = Math.max(this.maxPopulation, pop);
                this.lifeExpectancyWomen.put(data[0], 65.0 + Double.parseDouble(data[2]));
                this.lifeExpectancyMen.put(data[0], 65.0 + Double.parseDouble(data[3]));
                this.gdpPerCapita.put(data[0], Double.parseDouble(data[5]));
                this.population.put(data[0], pop);
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

