/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.PolarTickStep;
import de.gsi.chart.renderer.datareduction.DefaultDataReducer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.dataset.spi.DefaultErrorDataSet;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class PolarPlotSample
extends Application {
    private static final int N_SAMPLES = 10000;

    public void start(Stage primaryStage) {
        StackPane root = new StackPane();
        DefaultNumericAxis xAxis = new DefaultNumericAxis("phi");
        DefaultNumericAxis yAxis = new DefaultNumericAxis("r");
        yAxis.setLowerBound(0.001);
        yAxis.setUpperBound(1000.0);
        yAxis.setForceZeroInRange(true);
        yAxis.setLogAxis(true);
        XYChart chart = new XYChart((Axis)xAxis, (Axis)yAxis);
        chart.setAnimated(false);
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new EditAxis());
        root.getChildren().add((Object)chart);
        chart.setPolarPlot(true);
        chart.setPolarStepSize(PolarTickStep.THIRTY);
        ErrorDataSetRenderer renderer = (ErrorDataSetRenderer)chart.getRenderers().get(0);
        renderer.setDrawMarker(true);
        DefaultDataReducer reducer = (DefaultDataReducer)renderer.getRendererDataReducer();
        reducer.setMinPointPixelDistance(3);
        DefaultErrorDataSet dataSet1 = new DefaultErrorDataSet("myData");
        DefaultDataSet dataSet2 = new DefaultDataSet("myData2");
        renderer.getDatasets().addAll((Object[])new DataSet[]{dataSet1, dataSet2});
        for (int n = 0; n < 10000; ++n) {
            double x = (double)n * 0.1;
            double y1 = 0.1 + Math.pow(20.0 * (double)n / 10000.0, 2.0);
            double y2 = 0.001 + 0.01 * Math.pow(200.0 * Math.cos(Math.toRadians((double)n * 0.1)), 4.0);
            dataSet1.add(x, y1);
            dataSet2.add(x, y2);
        }
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> System.exit(0));
        primaryStage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

