/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples.utils;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.DataPointTooltip;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Panner;
import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.chart.plugins.TableViewer;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.LineStyle;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.ui.geometry.Side;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.Priority;
import jfxtras.scene.layout.HBox;
import jfxtras.scene.layout.VBox;

public class DemoChart
extends XYChart {
    private List<DefaultNumericAxis> yAxes = new ArrayList<DefaultNumericAxis>();
    private List<ErrorDataSetRenderer> renderer = new ArrayList<ErrorDataSetRenderer>();

    public DemoChart() {
        this(1);
    }

    public DemoChart(int nAxes) {
        super((Axis)new DefaultNumericAxis("x-axis"), (Axis)new DefaultNumericAxis("y-axis"));
        if (nAxes <= 0) {
            throw new IllegalArgumentException("nAxes= " + nAxes + " must be >=1");
        }
        ErrorDataSetRenderer defaultRenderer = (ErrorDataSetRenderer)this.getRenderers().get(0);
        defaultRenderer.setPolyLineStyle(LineStyle.NORMAL);
        defaultRenderer.setErrorType(ErrorStyle.ERRORCOMBO);
        this.renderer.add(defaultRenderer);
        this.getYAxis().setAutoRangePadding(0.05);
        this.yAxes.add(this.getYAxis());
        for (int i = 1; i < nAxes; ++i) {
            DefaultNumericAxis yAxis = new DefaultNumericAxis("y-axis" + i);
            yAxis.setAutoRangePadding(0.05);
            yAxis.setSide(Side.RIGHT);
            this.yAxes.add(yAxis);
            ErrorDataSetRenderer newRenderer = new ErrorDataSetRenderer();
            newRenderer.getAxes().addAll((Object[])new Axis[]{this.getXAxis(), yAxis});
            this.getRenderers().add((Object)newRenderer);
            this.renderer.add(newRenderer);
        }
        this.getPlugins().add((Object)new ParameterMeasurements());
        this.getPlugins().add((Object)new Zoomer());
        this.getPlugins().add((Object)new Panner());
        this.getPlugins().add((Object)new TableViewer());
        this.getPlugins().add((Object)new EditAxis());
        this.getPlugins().add((Object)new DataPointTooltip());
        VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
    }

    public DefaultNumericAxis getXAxis() {
        return (DefaultNumericAxis)super.getXAxis();
    }

    public DefaultNumericAxis getYAxis() {
        return (DefaultNumericAxis)super.getYAxis();
    }

    public DefaultNumericAxis getYAxis(int index) {
        return this.yAxes.get(index);
    }

    public ErrorDataSetRenderer getRenderer() {
        return this.renderer.get(0);
    }

    public ErrorDataSetRenderer getRenderer(int index) {
        return this.renderer.get(index);
    }
}

