/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples;

import de.gsi.chart.renderer.spi.ContourDataSetRenderer;
import de.gsi.chart.renderer.spi.utils.ColorGradient;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet3D;
import de.gsi.dataset.spi.DefaultErrorDataSet;
import de.gsi.math.TMath;
import de.gsi.math.matrix.MatrixD;
import de.gsi.math.samples.utils.AbstractDemoApplication;
import de.gsi.math.samples.utils.DemoChart;
import de.gsi.math.spectra.EEMD;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.layout.VBox;

public class EMDSample
extends AbstractDemoApplication {
    private static final int MAX_POINTS = 1024;
    private static final boolean LOAD_EXAMPLE_DATA = true;
    private DataSet3D dataset;
    private DataSet[] fmodeDataSets = new DataSet[10];
    private double[][] fmodeData = new double[10][];
    private double[] yValues;

    public void initData() {
        this.yValues = this.readDemoData(1);
        this.createModeDataSet();
    }

    private double[] loadSyntheticData() {
        double[] yModel = new double[1024];
        for (int i = 0; i < this.yValues.length; ++i) {
            double x = i;
            double offset = 0.0;
            double error = 0.1 * RANDOM.nextGaussian();
            offset = i > 500 ? -20.0 : 0.0;
            yModel[i] = i > 100 && i < 700 ? 0.7 * Math.sin(TMath.TwoPi() * 2.0E-4 * x * (x + offset)) : 0.0;
            int n = i;
            yModel[n] = yModel[n] + (i > 50 && i < 500 ? 1.0 * Math.sin(TMath.TwoPi() * 0.25 * x) : 0.0);
            double mod = Math.cos(TMath.TwoPi() * 0.01 * x);
            if (i < 470) {
                mod = 0.0;
            }
            int n2 = i;
            yModel[n2] = yModel[n2] + (i > 300 && i < 900 ? 1.0 * Math.sin(TMath.TwoPi() * (0.4 - 5.0E-4 * mod) * x) : 0.0);
            int n3 = i;
            yModel[n3] = yModel[n3] + 0.5 * Math.sin(TMath.TwoPi() * ((0.1 + 5.0E-8 * x * x) * x));
            yModel[i] = yModel[i] + error;
        }
        return Arrays.copyOf(yModel, yModel.length);
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    private DataSet3D createDataSet() {
        int nQuantx = 1024;
        int nQuanty = 1024;
        final EEMD trafoHHT = new EEMD();
        new Thread(){

            @Override
            public void run() {
                EMDSample.this.dataset = trafoHHT.getScalogram(EMDSample.this.yValues, 1024, 1024);
            }
        }.start();
        try {
            do {
                this.sleep(100);
                int status = trafoHHT.getStatus();
                if (status <= 10) continue;
                System.out.println(status + " % of computation done");
            } while (trafoHHT.isBusy());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.dataset;
    }

    private void createModeDataSet() {
        EEMD trafoHHT = new EEMD();
        MatrixD emd = trafoHHT.eemd(this.yValues, 0.0, 1.0);
        double[] time = new double[this.yValues.length];
        for (int i = 0; i < time.length; ++i) {
            time[i] = i;
        }
        for (int nmode = 0; nmode < emd.getColumnDimension() - 1; ++nmode) {
            String name;
            String string = name = nmode == 0 ? "raw" : "mode" + nmode;
            if (nmode >= this.fmodeDataSets.length) continue;
            this.fmodeData[nmode] = new double[time.length];
            for (int j = 0; j < this.fmodeData[nmode].length; ++j) {
                this.fmodeData[nmode][j] = emd.get(j, nmode) - (double)(5 * nmode);
            }
            System.out.printf("%s mean = %f\n", name, (TMath.Mean((double[])this.fmodeData[nmode]) + (double)(2 * nmode)) / TMath.PeakToPeak((double[])this.fmodeData[nmode]));
            this.fmodeDataSets[nmode] = new DefaultErrorDataSet(name, time, this.fmodeData[nmode], new double[time.length], new double[time.length], time.length, true);
        }
    }

    @Override
    public Node getContent() {
        this.initData();
        DemoChart chart1 = new DemoChart();
        chart1.getXAxis().setLabel("time");
        chart1.getXAxis().setUnit("turns");
        chart1.getYAxis().setLabel("frequency");
        chart1.getYAxis().setUnit("fs");
        ContourDataSetRenderer contourChartRenderer = new ContourDataSetRenderer();
        chart1.getRenderers().set(0, (Object)contourChartRenderer);
        contourChartRenderer.setColorGradient(ColorGradient.RAINBOW);
        contourChartRenderer.getDatasets().add((Object)this.createDataSet());
        DemoChart chart2 = new DemoChart();
        chart2.getXAxis().setLabel("time");
        chart2.getXAxis().setUnit("turns");
        chart2.getYAxis().setLabel("amplitude");
        chart2.getYAxis().setUnit("[a.u.]");
        for (int i = 0; i < this.fmodeDataSets.length; ++i) {
            if (this.fmodeDataSets[i] == null) continue;
            chart2.getDatasets().add((Object)this.fmodeDataSets[i]);
        }
        return new VBox(new Node[]{chart1, chart2});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private double[] readDemoData(int index) {
        String fileName = index <= 1 ? "./rawDataCPS2.dat" : "./rawDataLHCInj.dat";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(EMDSample.class.getResourceAsStream(fileName)));){
            String line = reader.readLine();
            int nDim = line == null ? 0 : Integer.parseInt(line);
            double[] ret = new double[nDim];
            for (int i = 0; i < nDim && (line = reader.readLine()) != null; ++i) {
                String[] x = line.split("\t");
                ret[i] = Double.parseDouble(x[1]);
            }
            double[] dArray = ret;
            return dArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new double[1000];
        }
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

