/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples.legacy.utils;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.datareduction.DefaultDataReducer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.renderer.spi.ReducingLineRenderer;
import de.gsi.chart.samples.legacy.utils.AbstractTestApplication;
import de.gsi.chart.samples.legacy.utils.ChartTestCase;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DoubleDataSet;
import de.gsi.dataset.testdata.spi.SineFunction;
import javafx.application.Application;
import javafx.scene.Node;

public class TestChart
extends AbstractTestApplication
implements ChartTestCase {
    protected int nSamples = 50000;
    protected final XYChart chart;
    protected final DefaultNumericAxis xAxis = new DefaultNumericAxis();
    protected final DefaultNumericAxis yAxis = new DefaultNumericAxis("irrelevant y-axis test case 2", -1.1, 1.1, 0.2);
    protected SineFunction testFunction = new SineFunction("test", this.nSamples, true);
    protected final DoubleDataSet dataSet = new DoubleDataSet("test");

    @Override
    public void initChart() {
        test = new TestChart(false);
    }

    public TestChart() {
        this(false);
    }

    public TestChart(boolean altRenderer) {
        this.chart = new XYChart((Axis)this.xAxis, (Axis)this.yAxis);
        this.chart.legendVisibleProperty().set(true);
        this.chart.setAnimated(false);
        this.chart.setLegendVisible(false);
        this.xAxis.setAutoRangeRounding(false);
        this.chart.getDatasets().setAll((Object[])new DataSet[]{this.testFunction});
        if (altRenderer) {
            this.xAxis.setLabel("x-axis (new Chart - ReducingLinerenderer)");
            this.yAxis.setLabel("irrelevant y-axis - ReducingLinerenderer");
            ReducingLineRenderer renderer = new ReducingLineRenderer();
            renderer.setMaxPoints(750);
            this.chart.getRenderers().set(0, (Object)renderer);
            this.chart.getCanvas().widthProperty().addListener((ch, o, n) -> renderer.setMaxPoints(Math.max(750, (int)(n.doubleValue() / 5.0))));
        } else {
            this.xAxis.setLabel("x-axis (new Chart - ErrorDataSetRenderer)");
            this.yAxis.setLabel("irrelevant y-axis - ErrorDataSetRenderer");
            ErrorDataSetRenderer renderer = (ErrorDataSetRenderer)this.chart.getRenderers().get(0);
            renderer.setDrawBars(false);
            renderer.setDrawMarker(false);
            renderer.setErrorType(ErrorStyle.NONE);
            renderer.setParallelImplementation(false);
            DefaultDataReducer reducer = (DefaultDataReducer)renderer.getRendererDataReducer();
            reducer.setMinPointPixelDistance(5);
        }
        this.setNumberOfSamples(1000);
        this.updateDataSet();
    }

    @Override
    public Node getChart(int nSamples) {
        return this.chart;
    }

    @Override
    public void updateDataSet() {
        this.testFunction.update();
    }

    @Override
    public void setNumberOfSamples(int nSamples) {
        this.nSamples = nSamples;
        this.testFunction = new SineFunction("test", nSamples, true);
        this.chart.getDatasets().setAll((Object[])new DataSet[]{this.testFunction});
        this.xAxis.setUpperBound((double)nSamples - 1.0);
        this.xAxis.setLowerBound(0.0);
        this.xAxis.setTickUnit((double)nSamples / 20.0);
        this.updateDataSet();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

