/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.utils.PeriodicScreenCapture;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DoubleDataSet;
import de.gsi.dataset.utils.DataSetSerialiser;
import de.gsi.dataset.utils.DataSetUtils;
import de.gsi.dataset.utils.serializer.FastByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class WriteDataSetToFileSample
extends Application {
    private static final int N_SAMPLES = 100;
    private static final String CSV_FILE_NAME_1 = "{dataSetName}.csv.zip";
    private static final String CSV_FILE_NAME_2 = "test2.dat.gz";
    private static final String CSV_FILE_NAME_SYSTEMTIME = "test_systemtime_{systemTime;date}_MagnetNr{magNr;int}.csv.gz";
    private static final String CSV_FILE_NAME_1_TIMESTAMED = "test1_{yMin;double}-{yMax;float;%.2e}_{acqTimeStamp;date}.csv.zip";
    private static final String CSV_FILE_NAME_2_TIMESTAMED = "test2_{yMin}-{yMax;float;%.2f}_{acqTimeStamp;int}.dat.gz";
    private static final String PNG_FILE_NAME = "test.png";
    private static final int DEFAULT_DELAY = 2;
    private static final int DEFAULT_PERIOD = 5;
    private static long now = System.currentTimeMillis();
    private static DoubleDataSet dataSet1;
    private static DoubleDataSet dataSet2;
    private static FastByteBuffer fastByteBuffer;

    public void start(Stage primaryStage) {
        String userHome = System.getProperty("user.home");
        XYChart chart1 = new XYChart((Axis)new DefaultNumericAxis(), (Axis)new DefaultNumericAxis());
        XYChart chart2 = new XYChart();
        now = System.currentTimeMillis();
        dataSet1 = WriteDataSetToFileSample.getDemoDataSet(now, true);
        dataSet2 = WriteDataSetToFileSample.getDemoDataSet(now, false);
        dataSet2.getMetaInfo().put("magNr", Integer.toString(5));
        chart1.getDatasets().setAll((Object[])new DataSet[]{dataSet1, dataSet2});
        Scene scene = new Scene((Parent)chart1, 800.0, 600.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName() + " - original");
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> System.exit(0));
        Stage secondaryStage = new Stage();
        secondaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName() + " - recovered");
        secondaryStage.setScene(new Scene((Parent)chart2, 800.0, 600.0));
        secondaryStage.setOnCloseRequest(evt -> System.exit(0));
        primaryStage.show();
        secondaryStage.show();
        System.err.println("userHome = " + userHome);
        Path path = Paths.get(userHome + "/ChartSamples", new String[0]);
        String fileName = PNG_FILE_NAME;
        boolean addDateTimeToFileName = true;
        DataSetUtils.writeDataSetToFile((DataSet)dataSet1, (Path)path, (String)CSV_FILE_NAME_1, (boolean)false);
        DataSetUtils.writeDataSetToFile((DataSet)dataSet2, (Path)path, (String)CSV_FILE_NAME_2, (boolean)true);
        DataSetUtils.writeDataSetToFile((DataSet)dataSet2, (Path)path, (String)CSV_FILE_NAME_SYSTEMTIME, (boolean)false);
        PeriodicScreenCapture screenCapture = new PeriodicScreenCapture(path, PNG_FILE_NAME, scene, 2.0, 5.0, true);
        screenCapture.addListener(obs -> {
            long userTimeStampMillis = System.currentTimeMillis();
            dataSet1.getMetaInfo().put("acqTimeStamp", Long.toString(userTimeStampMillis));
            dataSet2.getMetaInfo().put("acqTimeStamp", Long.toString(userTimeStampMillis));
            String actualFileName1 = DataSetUtils.writeDataSetToFile((DataSet)dataSet1, (Path)path, (String)CSV_FILE_NAME_1_TIMESTAMED, (boolean)false);
            String actualFileName2 = DataSetUtils.writeDataSetToFile((DataSet)dataSet2, (Path)path, (String)CSV_FILE_NAME_2_TIMESTAMED, (boolean)true);
            boolean asFloat = true;
            fastByteBuffer.reset();
            DataSetSerialiser.writeDataSetToByteArray((DataSet)dataSet2, (FastByteBuffer)fastByteBuffer, (boolean)asFloat);
            System.out.println("written bytes to byte buffer = " + fastByteBuffer.getPosition());
            fastByteBuffer.reset();
            System.out.println("write data time-stamped to directory = " + path);
            System.out.println("actualFileName1 = " + actualFileName1);
            System.out.println("actualFileName2 = " + actualFileName2);
            DataSet recoveredDataSet1 = DataSetUtils.readDataSetFromFile((String)actualFileName1);
            DataSet recoveredDataSet2 = DataSetUtils.readDataSetFromFile((String)actualFileName2);
            DataSet recoveredDataSet3 = DataSetSerialiser.readDataSetFromByteArray((FastByteBuffer)fastByteBuffer);
            chart2.getDatasets().clear();
            if (recoveredDataSet1 != null) {
                chart2.getDatasets().add((Object)recoveredDataSet1);
            }
            if (recoveredDataSet2 != null) {
                chart2.getDatasets().add((Object)recoveredDataSet2);
            }
            if (recoveredDataSet3 != null) {
                chart2.getDatasets().add((Object)recoveredDataSet3);
            }
            now = System.currentTimeMillis();
            dataSet1 = WriteDataSetToFileSample.getDemoDataSet(now, true);
            dataSet2 = WriteDataSetToFileSample.getDemoDataSet(now, false);
            chart1.getDatasets().setAll((Object[])new DataSet[]{dataSet1, dataSet2});
        });
        screenCapture.start();
    }

    private static DoubleDataSet getDemoDataSet(long now, boolean isSine) {
        DoubleDataSet dataSet = new DoubleDataSet((isSine ? "sine" : "cosine") + "data set #1 @t=" + now);
        double[] xValues = new double[100];
        double[] yValues = new double[100];
        for (int n = 0; n < 100; ++n) {
            double phase = Math.toRadians(10.0 * (double)n + (double)now / 1000.0);
            xValues[n] = n;
            yValues[n] = isSine ? Math.sin(phase) : Math.cos(phase);
        }
        dataSet.set(xValues, yValues);
        return dataSet;
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    static {
        fastByteBuffer = new FastByteBuffer();
    }
}

