/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.axes.spi.format.DefaultTimeFormatter;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.datareduction.DefaultDataReducer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.chart.utils.SimplePerformanceMeter;
import de.gsi.dataset.spi.CircularDoubleErrorDataSet;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.time.ZoneOffset;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.stage.Stage;

public class RollingBufferSample
extends Application {
    public static final int DEBUG_UPDATE_RATE = 1000;
    protected static final int MIN_PIXEL_DISTANCE = 0;
    public static final int N_SAMPLES = 3000;
    public static final int UPDATE_PERIOD = 40;
    public static final int BUFFER_CAPACITY = 750;
    public final CircularDoubleErrorDataSet rollingBufferDipoleCurrent = new CircularDoubleErrorDataSet("dipole current [A]", 750);
    public final CircularDoubleErrorDataSet rollingBufferBeamIntensity = new CircularDoubleErrorDataSet("beam intensity [ppp]", 750);
    private final ErrorDataSetRenderer beamIntensityRenderer = new ErrorDataSetRenderer();
    private final ErrorDataSetRenderer dipoleCurrentRenderer = new ErrorDataSetRenderer();
    final DefaultNumericAxis yAxis1 = new DefaultNumericAxis("beam intensity", "ppp");
    final DefaultNumericAxis yAxis2 = new DefaultNumericAxis("dipole current", "A");
    protected Timer timer;

    protected void initErrorDataSetRenderer(ErrorDataSetRenderer eRenderer) {
        eRenderer.setErrorType(ErrorStyle.ERRORSURFACE);
        eRenderer.setErrorType(ErrorStyle.NONE);
        eRenderer.setDashSize(0);
        eRenderer.setPointReduction(true);
        eRenderer.setDrawMarker(false);
        DefaultDataReducer reductionAlgorithm = (DefaultDataReducer)eRenderer.getRendererDataReducer();
        reductionAlgorithm.setMinPointPixelDistance(0);
    }

    public void start(Stage primaryStage) {
        ProcessingProfiler.setVerboseOutputState((boolean)true);
        ProcessingProfiler.setLoggerOutputState((boolean)true);
        ProcessingProfiler.setDebugState((boolean)false);
        BorderPane root = new BorderPane();
        Scene scene = new Scene((Parent)root, 1800.0, 400.0);
        root.setCenter((Node)this.initComponents(scene));
        long startTime = ProcessingProfiler.getTimeStamp();
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> System.exit(0));
        primaryStage.show();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"for showing");
    }

    public BorderPane initComponents(Scene scene) {
        BorderPane root = new BorderPane();
        this.generateData();
        this.initErrorDataSetRenderer(this.beamIntensityRenderer);
        this.initErrorDataSetRenderer(this.dipoleCurrentRenderer);
        DefaultNumericAxis xAxis1 = new DefaultNumericAxis("time");
        xAxis1.setAutoRangeRounding(false);
        xAxis1.setTickLabelRotation(45.0);
        xAxis1.setMinorTickCount(30);
        xAxis1.invertAxis(false);
        xAxis1.setTimeAxis(true);
        this.yAxis2.setSide(Side.RIGHT);
        this.yAxis2.setAnimated(false);
        this.dipoleCurrentRenderer.getAxes().add((Object)this.yAxis2);
        XYChart chart = new XYChart((Axis)xAxis1, (Axis)this.yAxis1);
        chart.legendVisibleProperty().set(true);
        chart.setAnimated(false);
        chart.getRenderers().set(0, (Object)this.beamIntensityRenderer);
        chart.getRenderers().add((Object)this.dipoleCurrentRenderer);
        chart.getPlugins().add((Object)new EditAxis());
        this.beamIntensityRenderer.getDatasets().add((Object)this.rollingBufferBeamIntensity);
        this.dipoleCurrentRenderer.getDatasets().add((Object)this.rollingBufferDipoleCurrent);
        if (xAxis1.isTimeAxis() && xAxis1.getAxisLabelFormatter() instanceof DefaultTimeFormatter) {
            DefaultTimeFormatter axisFormatter = (DefaultTimeFormatter)xAxis1.getAxisLabelFormatter();
            axisFormatter.setTimeZoneOffset(ZoneOffset.UTC);
            axisFormatter.setTimeZoneOffset(ZoneOffset.ofHoursMinutes(5, 0));
        }
        this.yAxis1.setForceZeroInRange(true);
        this.yAxis2.setForceZeroInRange(true);
        this.yAxis1.setAutoRangeRounding(true);
        this.yAxis2.setAutoRangeRounding(true);
        root.setTop((Node)this.getHeaderBar(chart, scene));
        long startTime = ProcessingProfiler.getTimeStamp();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data to chart");
        startTime = ProcessingProfiler.getTimeStamp();
        root.setCenter((Node)chart);
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding chart into StackPane");
        return root;
    }

    private HBox getHeaderBar(XYChart chart, Scene scene) {
        Button newDataSet = new Button("new DataSet");
        newDataSet.setOnAction(evt -> Platform.runLater((Runnable)this.getTask()));
        Button startTimer = new Button("timer");
        startTimer.setOnAction(evt -> {
            if (this.timer == null) {
                this.timer = new Timer();
                this.rollingBufferBeamIntensity.reset();
                this.rollingBufferDipoleCurrent.reset();
                this.timer.scheduleAtFixedRate(this.getTask(), 0L, 40L);
            } else {
                this.timer.cancel();
                this.timer = null;
            }
        });
        Region spacer = new Region();
        spacer.setMinWidth(Double.NEGATIVE_INFINITY);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        SimplePerformanceMeter meter = new SimplePerformanceMeter(scene, 1000L);
        Label fxFPS = new Label();
        fxFPS.setFont(Font.font((String)"Monospaced", (double)12.0));
        Label chartFPS = new Label();
        chartFPS.setFont(Font.font((String)"Monospaced", (double)12.0));
        Label cpuLoadProcess = new Label();
        cpuLoadProcess.setFont(Font.font((String)"Monospaced", (double)12.0));
        Label cpuLoadSystem = new Label();
        cpuLoadSystem.setFont(Font.font((String)"Monospaced", (double)12.0));
        meter.fxFrameRateProperty().addListener((ch, o, n) -> {
            String fxRate = String.format("%4.1f", meter.getFxFrameRate());
            String actualRate = String.format("%4.1f", meter.getActualFrameRate());
            String cpuProcess = String.format("%5.1f", meter.getProcessCpuLoad());
            String cpuSystem = String.format("%5.1f", meter.getSystemCpuLoad());
            fxFPS.setText(String.format("%-6s: %4s %s", "JavaFX", fxRate, "FPS, "));
            chartFPS.setText(String.format("%-6s: %4s %s", "Actual", actualRate, "FPS, "));
            cpuLoadProcess.setText(String.format("%-11s: %4s %s", "Process-CPU", cpuProcess, "%"));
            cpuLoadSystem.setText(String.format("%-11s: %4s %s", "System -CPU", cpuSystem, "%"));
        });
        return new HBox(new Node[]{newDataSet, startTimer, spacer, new VBox(new Node[]{fxFPS, chartFPS}), new VBox(new Node[]{cpuLoadProcess, cpuLoadSystem})});
    }

    protected TimerTask getTask() {
        return new TimerTask(){
            int updateCount = 0;

            @Override
            public void run() {
                Platform.runLater(() -> {
                    RollingBufferSample.this.generateData();
                    if (this.updateCount % 20 == 0) {
                        System.out.println("update iteration #" + this.updateCount);
                    }
                    ++this.updateCount;
                });
            }
        };
    }

    private static double square(double frequency, double t) {
        double sine = 100.0 * Math.sin(Math.PI * 2 * frequency * t);
        double squarePoint = Math.signum(sine);
        return squarePoint >= 0.0 ? squarePoint : 0.0;
    }

    private static double sine(double frequency, double t) {
        return Math.sin(Math.PI * 2 * frequency * t);
    }

    public static double rampFunctionDipoleCurrent(double t) {
        int second = (int)Math.floor(t);
        double subSecond = t - (double)second;
        double offset = 0.3;
        double y = 100.0 * RollingBufferSample.sine(1.0, subSecond - offset);
        if (second % 5 == 0) {
            offset = 0.1;
            y = 100.0 * Math.pow(RollingBufferSample.sine(1.5, subSecond - offset), 2.0);
        }
        if (y <= 0.0 || subSecond < offset) {
            y = 0.0;
        }
        return y + 10.0;
    }

    public static double rampFunctionBeamIntensity(double t) {
        int second = (int)Math.floor(t);
        double subSecond = t - (double)second;
        double offset = 0.3;
        double y = (1.0 - 0.1 * subSecond) * 1.0E9;
        double gate = RollingBufferSample.square(2.0, subSecond - offset) * RollingBufferSample.square(1.0, subSecond - offset);
        if (second % 5 == 0) {
            offset = 0.1;
            gate = Math.pow(RollingBufferSample.square(3.0, subSecond - offset), 2.0);
        }
        if (gate <= 0.0 || subSecond < offset) {
            gate = 0.0;
        }
        return gate * y;
    }

    private void generateData() {
        long startTime = ProcessingProfiler.getTimeStamp();
        double now = (double)System.currentTimeMillis() / 1000.0 + 1.0;
        if (this.rollingBufferDipoleCurrent.getDataCount() == 0) {
            this.rollingBufferBeamIntensity.setAutoNotifaction(false);
            this.rollingBufferDipoleCurrent.setAutoNotifaction(false);
            for (int n = 3000; n >= 0; --n) {
                double t = now - (double)(n * 40) / 1000.0;
                double y = 25.0 * RollingBufferSample.rampFunctionDipoleCurrent(t);
                double y2 = 100.0 * RollingBufferSample.rampFunctionBeamIntensity(t);
                double ey = 1.0;
                this.rollingBufferDipoleCurrent.add(t, y, 1.0, 1.0);
                this.rollingBufferBeamIntensity.add(t, y2, 1.0, 1.0);
            }
            this.rollingBufferBeamIntensity.setAutoNotifaction(true);
            this.rollingBufferDipoleCurrent.setAutoNotifaction(true);
        } else {
            this.rollingBufferDipoleCurrent.setAutoNotifaction(false);
            double t = now;
            double y = 25.0 * RollingBufferSample.rampFunctionDipoleCurrent(t);
            double y2 = 100.0 * RollingBufferSample.rampFunctionBeamIntensity(t);
            double ey = 1.0;
            this.rollingBufferDipoleCurrent.add(t, y, 1.0, 1.0);
            this.rollingBufferBeamIntensity.add(t, y2, 1.0, 1.0);
            this.rollingBufferDipoleCurrent.setAutoNotifaction(true);
        }
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data into DataSet");
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

