/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Panner;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.spi.MountainRangeRenderer;
import de.gsi.chart.samples.ContourChartSample;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet3D;
import de.gsi.dataset.spi.AbstractDataSet3D;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class MountainRangeRendererSample
extends Application {
    public void start(Stage stage) {
        stage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        DefaultNumericAxis xAxis = new DefaultNumericAxis();
        xAxis.setAnimated(false);
        xAxis.setAutoRangeRounding(false);
        xAxis.setLabel("X Position");
        DefaultNumericAxis yAxis = new DefaultNumericAxis();
        yAxis.setAnimated(false);
        yAxis.setAutoRangeRounding(false);
        yAxis.setLabel("Y Position");
        XYChart chart = new XYChart((Axis)xAxis, (Axis)yAxis);
        chart.setTitle("Test data");
        chart.setAnimated(false);
        MountainRangeRenderer mountainRangeRenderer = new MountainRangeRenderer();
        chart.getRenderers().set(0, (Object)mountainRangeRenderer);
        chart.getDatasets().setAll((Object[])new DataSet[]{this.createTestData()});
        chart.setLegendVisible(true);
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new Panner());
        chart.getPlugins().add((Object)new EditAxis());
        Scene scene = new Scene((Parent)chart, 800.0, 600.0);
        stage.setScene(scene);
        stage.show();
    }

    private DataSet3D createData() {
        double[] x;
        double[] y = x = new double[]{-12.0, -9.0, -8.0, -7.0, -6.0, -5.0, -4.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 12.0};
        double[][] z = new double[x.length][y.length];
        for (int yIndex = 0; yIndex < y.length; ++yIndex) {
            for (int xIndex = 0; xIndex < x.length; ++xIndex) {
                z[xIndex][yIndex] = Math.sin(y[yIndex] * x[xIndex]);
            }
        }
        return new DefaultData("demoDataSet", MountainRangeRendererSample.toNumbers(x), MountainRangeRendererSample.toNumbers(y), z);
    }

    public static double gaussian(double x, double mean, double sigma) {
        double norm = 1.0 / (sigma * Math.sqrt(Math.PI * 2));
        double is = 1.0 / sigma;
        double i2s2 = 0.5 * is * is;
        double xMinusMean = x - mean;
        return norm * Math.exp(-xMinusMean * xMinusMean * i2s2);
    }

    private DataSet3D createTestData() {
        double val;
        int i;
        int nPointsX = 2000;
        int nPointsY = 100;
        double[] x = new double[2000];
        double[] y = new double[100];
        for (i = 0; i < x.length; ++i) {
            x[i] = val = ((double)i / (double)x.length - 0.5) * 10.0;
        }
        for (i = 0; i < y.length; ++i) {
            y[i] = val = ((double)i / (double)y.length - 0.5) * 10.0;
        }
        double[][] z = new double[x.length][y.length];
        for (int yIndex = 0; yIndex < y.length; ++yIndex) {
            for (int xIndex = 0; xIndex < x.length; ++xIndex) {
                double t = x[xIndex];
                double yRel = (double)yIndex / (double)y.length;
                double mean1 = -3.5;
                double mean2 = -1.0;
                double mean3 = 1.0;
                double mean4 = 3.5;
                double width1 = 2.0 * (1.0 - yRel);
                double width4 = 0.2 + 0.05 * Math.sin(Math.PI * 5 * yRel);
                double y1 = MountainRangeRendererSample.gaussian(t, -3.5, width1);
                double y2 = MountainRangeRendererSample.gaussian(t, -1.0 + 0.3 * Math.sin(7.853981633974483 * yRel), 0.2);
                double y3 = MountainRangeRendererSample.gaussian(t, 1.0 + 0.3 * Math.sin(7.853981633974483 * yRel), 0.2);
                double y4 = MountainRangeRendererSample.gaussian(t, 3.5, width4);
                z[xIndex][yIndex] = y1 + y2 + y3 + y4;
            }
        }
        return new DefaultData("demoDataSet", MountainRangeRendererSample.toNumbers(x), MountainRangeRendererSample.toNumbers(y), z);
    }

    private static Number[] toNumberArray(String[] stringValues) {
        Number[] numberValues = new Number[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            numberValues[i] = Double.valueOf(stringValues[i]);
        }
        return numberValues;
    }

    private static Number[] toNumbers(double[] array) {
        Number[] result = new Number[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataSet3D readImage() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(ContourChartSample.class.getResourceAsStream("./testdata/image.txt")));){
            reader.readLine();
            String[] x = reader.readLine().split(" ");
            reader.readLine();
            String[] y = reader.readLine().split(" ");
            reader.readLine();
            String[] z = reader.readLine().split(" ");
            Number[] xValues = MountainRangeRendererSample.toNumberArray(x);
            Number[] yValues = MountainRangeRendererSample.toNumberArray(y);
            double[][] zValues = new double[x.length][y.length];
            int i = 0;
            for (int yIdx = 0; yIdx < y.length; ++yIdx) {
                for (int xIdx = 0; xIdx < x.length; ++xIdx) {
                    zValues[xIdx][yIdx] = Double.parseDouble(z[i++]);
                }
            }
            DefaultData defaultData = new DefaultData("contour data", xValues, yValues, zValues);
            return defaultData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    public class DefaultData
    extends AbstractDataSet3D<DefaultData> {
        private final Number[] xValues;
        private final Number[] yValues;
        private final double[][] zValues;

        DefaultData(String name, Number[] xValues, Number[] yValues, double[][] zValues) {
            super(name);
            this.xValues = xValues;
            this.yValues = yValues;
            this.zValues = zValues;
        }

        public double getZ(int xIndex, int yIndex) {
            return this.zValues[xIndex][yIndex];
        }

        public void set(int xIndex, int yIndex, double x, double y, double z) {
            this.xValues[xIndex] = x;
            this.yValues[yIndex] = y;
            this.zValues[xIndex][yIndex] = z;
        }

        public int getXDataCount() {
            return this.xValues.length;
        }

        public int getYDataCount() {
            return this.yValues.length;
        }

        public double getX(int i) {
            return this.xValues[i].doubleValue();
        }

        public double getY(int i) {
            return this.yValues[i].doubleValue();
        }

        public String getStyle(int index) {
            return null;
        }
    }
}

