/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.LineStyle;
import de.gsi.chart.renderer.spi.ContourDataSetRenderer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.renderer.spi.MetaDataRenderer;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.Histogram2;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class Histogram2DimSample
extends Application {
    private static final int UPDATE_DELAY = 1000;
    private static final int UPDATE_PERIOD = 100;
    private static final int UPDATE_N_SAMPLES = 10;
    private static final int N_BINS_X = 120;
    private static final int N_BINS_Y = 120;
    private final Histogram2 histogram1 = new Histogram2("hist1", 120, 0.0, 20.0, 120, 0.0, 30.0);
    private final Histogram2 histogram2 = new Histogram2("hist2", 120, 0.0, 20.0, 120, 0.0, 30.0);
    int counter = 0;
    Random rnd = new Random();

    public void start(Stage primaryStage) {
        StackPane root = new StackPane();
        DefaultNumericAxis xAxis = new DefaultNumericAxis("x-Axis");
        xAxis.setAutoRanging(true);
        xAxis.setAutoRangeRounding(false);
        xAxis.setSide(Side.BOTTOM);
        DefaultNumericAxis yAxis = new DefaultNumericAxis("y-Axis");
        yAxis.setAutoRanging(true);
        yAxis.setAutoRangeRounding(false);
        yAxis.setSide(Side.LEFT);
        DefaultNumericAxis zAxis = new DefaultNumericAxis("z Amplitude");
        zAxis.setAnimated(false);
        zAxis.setAutoRangeRounding(false);
        zAxis.setAutoRanging(true);
        zAxis.setSide(Side.RIGHT);
        DefaultNumericAxis yAxis1 = new DefaultNumericAxis("y-Axis x-Projection", 0.0, 1000.0, 10.0);
        yAxis1.setLogAxis(false);
        yAxis1.setAnimated(false);
        yAxis1.setAutoRangeRounding(true);
        yAxis1.setAutoRangePadding(0.05);
        yAxis1.setForceZeroInRange(true);
        yAxis1.setAutoRanging(false);
        yAxis1.setAutoGrowRanging(true);
        yAxis1.setSide(Side.RIGHT);
        yAxis1.upperBoundProperty().addListener((ch, o, n) -> System.err.println("x-projection upper bound = " + n + " vs " + this.histogram1.getProjectionX().getYMax() + "  " + this.histogram2.getProjectionX().getYMax()));
        DefaultNumericAxis xAxis1 = new DefaultNumericAxis("x-Axis y-Projection", -1.0, 1000.0, 10.0);
        xAxis1.setLogAxis(false);
        xAxis1.setAutoRangeRounding(true);
        xAxis1.setAutoRangePadding(0.05);
        xAxis1.setForceZeroInRange(true);
        xAxis1.setAutoRanging(false);
        xAxis1.setAutoGrowRanging(true);
        xAxis1.setSide(Side.TOP);
        xAxis1.upperBoundProperty().addListener((ch, o, n) -> System.err.println("y-projection upper bound = " + n + " vs " + this.histogram1.getProjectionY().getYMax() + "  " + this.histogram2.getProjectionY().getYMax()));
        final XYChart chart = new XYChart((Axis)xAxis, (Axis)yAxis);
        chart.setAnimated(false);
        ContourDataSetRenderer heatMap = new ContourDataSetRenderer();
        heatMap.getAxes().addAll((Object[])new Axis[]{xAxis, yAxis, zAxis});
        heatMap.getDatasets().addAll((Object[])new DataSet[]{this.histogram1, this.histogram2});
        chart.getRenderers().set(0, (Object)heatMap);
        ErrorDataSetRenderer projectionRendererX = new ErrorDataSetRenderer();
        projectionRendererX.getAxes().addAll((Object[])new Axis[]{xAxis, yAxis1});
        projectionRendererX.getDatasets().addAll((Object[])new DataSet[]{this.histogram1.getProjectionX(), this.histogram2.getProjectionX()});
        this.histogram1.getProjectionX().setStyle("dsIndex=0");
        this.histogram2.getProjectionX().setStyle("dsIndex=1");
        projectionRendererX.setPolyLineStyle(LineStyle.HISTOGRAM);
        projectionRendererX.setPointReduction(false);
        chart.getRenderers().add((Object)projectionRendererX);
        ErrorDataSetRenderer projectionRendererY = new ErrorDataSetRenderer();
        projectionRendererY.getAxes().addAll((Object[])new Axis[]{xAxis1, yAxis});
        projectionRendererY.getDatasets().addAll((Object[])new DataSet[]{this.histogram1.getProjectionY(), this.histogram2.getProjectionY()});
        this.histogram1.getProjectionY().setStyle("dsIndex=0");
        this.histogram2.getProjectionY().setStyle("dsIndex=1");
        projectionRendererY.setPolyLineStyle(LineStyle.HISTOGRAM);
        projectionRendererY.setPointReduction(false);
        chart.getRenderers().add((Object)projectionRendererY);
        MetaDataRenderer metaRenderer = new MetaDataRenderer((Chart)chart);
        metaRenderer.getDatasets().addAll((Object[])new DataSet[]{this.histogram2, this.histogram1});
        chart.getRenderers().add((Object)metaRenderer);
        chart.legendVisibleProperty().set(true);
        chart.getPlugins().add((Object)new ParameterMeasurements());
        chart.getPlugins().add((Object)new EditAxis());
        Zoomer zoomer = new Zoomer();
        zoomer.setSliderVisible(false);
        chart.getPlugins().add((Object)zoomer);
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        root.getChildren().add((Object)chart);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> System.exit(0));
        primaryStage.show();
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Histogram2DimSample.this.fillData();
                chart.requestLayout();
            }
        }, 1000L, 100L);
    }

    private void fillData() {
        ++this.counter;
        this.histogram1.setAutoNotifaction(false);
        this.histogram1.setAutoNotifaction(false);
        double angle = 0.7853981633974483;
        for (int i = 0; i < 10; ++i) {
            double x0 = this.rnd.nextGaussian() * 0.5 + 5.0;
            double y0 = this.rnd.nextGaussian() * 0.5 + 5.0;
            double x = this.rnd.nextGaussian() * 1.5;
            double y = this.rnd.nextGaussian() * 0.5;
            double x1 = x * Math.sin(0.7853981633974483) + y * Math.cos(0.7853981633974483);
            double x2 = x * Math.cos(0.7853981633974483) - y * Math.sin(0.7853981633974483);
            this.histogram1.fill(x0, y0);
            this.histogram2.fill(x1 + 14.0, x2 + 20.0);
        }
        this.histogram1.setAutoNotifaction(false);
        this.histogram2.setAutoNotifaction(false);
        this.histogram1.fireInvalidated(null);
        this.histogram2.fireInvalidated(null);
        if (this.counter % 500 == 0) {
            this.counter = 0;
            this.histogram1.reset();
            this.histogram2.reset();
        }
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

