/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.Chart;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.axes.spi.MetricPrefix;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Stage;

public class AxisRangeScalingSample
extends Application {
    private static final String CHART_CSS = Chart.class.getResource("chart.css").toExternalForm();

    public void start(Stage primaryStage) {
        VBox root = new VBox();
        root.setAlignment(Pos.CENTER);
        DefaultNumericAxis xAxis1 = new DefaultNumericAxis("standard axis label w/o unit", 0.0, 100.0, 1.0);
        VBox.setMargin((Node)xAxis1, (Insets)new Insets(20.0, 10.0, 20.0, 10.0));
        root.getChildren().add((Object)xAxis1);
        DefaultNumericAxis xAxis2 = new DefaultNumericAxis("axis label", 0.0, 100.0, 1.0);
        VBox.setMargin((Node)xAxis2, (Insets)new Insets(20.0, 10.0, 20.0, 10.0));
        xAxis2.setUnit("m");
        root.getChildren().add((Object)xAxis2);
        DefaultNumericAxis xAxis3 = new DefaultNumericAxis("current", 0.0, 100.0, 1.0);
        VBox.setMargin((Node)xAxis3, (Insets)new Insets(20.0, 10.0, 20.0, 10.0));
        xAxis3.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
        xAxis3.setUnit("A");
        xAxis3.getAxisLabel().setFill((Paint)Color.RED.darker());
        root.getChildren().add((Object)xAxis3);
        DefaultNumericAxis xAxis4 = new DefaultNumericAxis("very large current", 1000.0, 100000.0, 100.0);
        VBox.setMargin((Node)xAxis4, (Insets)new Insets(20.0, 10.0, 20.0, 10.0));
        xAxis4.setUnitScaling(1000.0);
        xAxis4.setUnitScaling(MetricPrefix.KILO);
        xAxis4.setUnit("A");
        xAxis4.getAxisLabel().setFont(Font.font((String)"Times", (double)25.0));
        xAxis4.getAxisLabel().setFill((Paint)Color.RED.darker());
        root.getChildren().add((Object)xAxis4);
        DefaultNumericAxis xAxis5 = new DefaultNumericAxis("small voltage", 0.0, 1.0E-5, 1.0E-6);
        VBox.setMargin((Node)xAxis5, (Insets)new Insets(20.0, 10.0, 20.0, 10.0));
        xAxis5.setUnitScaling(MetricPrefix.MICRO);
        xAxis5.setUnit("V");
        root.getChildren().add((Object)xAxis5);
        DefaultNumericAxis xAxis6 = new DefaultNumericAxis("tiny voltage", 0.0, 1.1E-8, 1.0E-9);
        VBox.setMargin((Node)xAxis6, (Insets)new Insets(20.0, 10.0, 20.0, 10.0));
        xAxis6.setUnitScaling(MetricPrefix.NANO);
        xAxis6.setUnit("V");
        root.getChildren().add((Object)xAxis6);
        DefaultNumericAxis xAxis7 = new DefaultNumericAxis("non-metric scaling voltage variable", 0.0, 2.5E-5, 1.0E-6);
        VBox.setMargin((Node)xAxis7, (Insets)new Insets(20.0, 10.0, 20.0, 10.0));
        xAxis7.setUnitScaling(2.5E-6);
        xAxis7.setUnit("V");
        root.getChildren().add((Object)xAxis7);
        DefaultNumericAxis xAxis8 = new DefaultNumericAxis("non-metric scaling voltage variable w/o unit", 0.0, 2.5E-5, 1.0E-6);
        VBox.setMargin((Node)xAxis8, (Insets)new Insets(20.0, 10.0, 20.0, 10.0));
        xAxis8.setUnitScaling(2.5E-6);
        root.getChildren().add((Object)xAxis8);
        final DefaultNumericAxis xAxis9 = new DefaultNumericAxis("dynamic Axis", -0.0, 0.001, 1.0);
        VBox.setMargin((Node)xAxis9, (Insets)new Insets(20.0, 10.0, 20.0, 10.0));
        xAxis9.setUnit("V");
        xAxis9.setAutoUnitScaling(true);
        xAxis9.setMinorTickCount(10);
        xAxis9.setAutoRangeRounding(true);
        root.getChildren().add((Object)xAxis9);
        final Label xAxis9Text = new Label();
        root.getChildren().add((Object)xAxis9Text);
        Timer timer = new Timer();
        TimerTask task = new TimerTask(){
            int counter = -9;
            boolean directionUpwards = true;

            @Override
            public void run() {
                this.counter = this.directionUpwards ? ++this.counter : --this.counter;
                Platform.runLater(() -> {
                    double power = Math.pow(10.0, this.counter);
                    xAxis9.upperBoundProperty().set(power);
                    String text = "actual SI range for dynamic axis: [" + xAxis9.getLowerBound() + " V, " + xAxis9.getUpperBound() + " V]";
                    xAxis9Text.setText(text);
                });
                if (this.counter >= 9 || this.counter <= -9) {
                    this.directionUpwards = !this.directionUpwards;
                }
            }
        };
        timer.scheduleAtFixedRate(task, 0L, TimeUnit.SECONDS.toMillis(2L));
        Scene scene = new Scene((Parent)root, 800.0, 700.0);
        scene.getStylesheets().setAll((Object[])new String[]{CHART_CSS});
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> System.exit(0));
        primaryStage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

