/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DoubleDataSet;
import de.gsi.math.DataSetMath;
import de.gsi.math.filter.iir.Butterworth;
import de.gsi.math.samples.utils.AbstractDemoApplication;
import de.gsi.math.samples.utils.DemoChart;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipInputStream;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.layout.VBox;

public class IIRFilterSample
extends AbstractDemoApplication {
    private static final int ORDER = 32;
    private final double sampling = 1.0E8;
    private final double center = 2.8E7;
    private final double width = 500000.0;
    private DataSet fraw;
    private DataSet fraw1;
    private DataSet fraw2;
    private DataSet fspectra;
    private DataSet fspectra1;
    private DataSet fspectra2;

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private DataSet readDemoData(int offset, int nSamples) {
        block35: {
            Butterworth bandPass = new Butterworth();
            bandPass.bandPass(32, 1.0E8, 2.8E7, 500000.0);
            Butterworth lowPass = new Butterworth();
            lowPass.lowPass(32, 1.0E8, 500000.0);
            DoubleDataSet ret = new DoubleDataSet("raw data@" + offset);
            InputStream inputStream = IIRFilterSample.class.getResourceAsStream("./20190319_Schottky_SumX.csv.zip");
            try {
                ZipInputStream zipStream = new ZipInputStream(inputStream);
                Throwable throwable = null;
                while (true) {
                    DoubleDataSet doubleDataSet;
                    Throwable throwable2;
                    BufferedReader reader;
                    block36: {
                        block37: {
                            if (zipStream.getNextEntry() == null) break block35;
                            reader = new BufferedReader(new InputStreamReader(zipStream));
                            throwable2 = null;
                            for (int i = 0; i < 2; ++i) {
                                reader.readLine();
                            }
                            int count = 0;
                            int n = 0;
                            System.err.println("start reading from " + offset);
                            String line = reader.readLine();
                            while ((line = reader.readLine()) != null) {
                                String[] str = line.split(",");
                                double s = Math.sin(6.251769380643688E8 * (double)count);
                                double y = lowPass.filter(s * bandPass.filter(Double.parseDouble(str[1])));
                                if (count >= offset && n < nSamples && count % 100 == 0) {
                                    ret.add((double)n / 1.0E8, y);
                                    ++n;
                                }
                                ++count;
                            }
                            System.err.println("finished reading nSamples(total) = " + count);
                            doubleDataSet = ret;
                            if (reader == null) break block36;
                            if (throwable2 == null) break block37;
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            break block36;
                        }
                        reader.close();
                    }
                    return doubleDataSet;
                    catch (Throwable throwable4) {
                        try {
                            try {
                                try {
                                    throwable2 = throwable4;
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    if (reader != null) {
                                        if (throwable2 != null) {
                                            try {
                                                reader.close();
                                            }
                                            catch (Throwable throwable6) {
                                                throwable2.addSuppressed(throwable6);
                                            }
                                        } else {
                                            reader.close();
                                        }
                                    }
                                    throw throwable5;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                zipStream.closeEntry();
                            }
                        }
                        catch (Throwable throwable7) {
                            throwable = throwable7;
                            throw throwable7;
                        }
                        catch (Throwable throwable8) {
                            throw throwable8;
                        }
                    }
                }
                finally {
                    if (zipStream != null) {
                        if (throwable != null) {
                            try {
                                zipStream.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                        } else {
                            zipStream.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void initData() {
        double fs = 1.0E8;
        int nBins = 32768;
        this.fraw = this.readDemoData(27500, 32768);
        this.fraw1 = this.readDemoData(77500, 32768);
        this.fraw2 = this.readDemoData(177500, 32768);
        System.err.println("length 0 = " + this.fraw.getDataCount());
        System.err.println("length 1 = " + this.fraw1.getDataCount());
        System.err.println("length 2 = " + this.fraw2.getDataCount());
        this.fspectra = DataSetMath.magnitudeSpectrumDecibel((DataSet)this.fraw);
        this.fspectra1 = DataSetMath.magnitudeSpectrumDecibel((DataSet)this.fraw1);
        this.fspectra2 = DataSetMath.magnitudeSpectrumDecibel((DataSet)this.fraw2);
    }

    @Override
    public Node getContent() {
        this.initData();
        DemoChart chart1 = new DemoChart();
        chart1.getXAxis().setLabel("time");
        chart1.getXAxis().setUnit("s");
        chart1.getYAxis().setLabel("magnitude");
        chart1.getYAxis().setUnit("a.u.");
        chart1.getDatasets().addAll((Object[])new DataSet[]{this.fraw1, this.fraw2});
        DemoChart chart2 = new DemoChart();
        chart2.getXAxis().setLabel("frequency [fs]");
        chart2.getXAxis().setUnit("fs");
        chart2.getYAxis().setLabel("magnitude");
        chart2.getYAxis().setUnit("a.u.");
        chart2.getDatasets().addAll((Object[])new DataSet[]{this.fspectra, this.fspectra1, this.fspectra2});
        return new VBox(new Node[]{chart1, chart2});
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

