/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.samples;

import de.gsi.dataset.samples.legacy.DoubleDataSet;
import de.gsi.dataset.spi.FloatDataSet;
import de.gsi.dataset.utils.ProcessingProfiler;
import de.gsi.math.TRandom;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.ArrayList;

public class FloatToDoubleBenchmarkSample {
    private static final int N_DIM = 2000;
    protected double[][] matrixD = new double[2000][2000];
    protected float[][] matrixF = new float[2000][2000];
    protected double[] vectorInD = new double[2000];
    protected float[] vectorInF = new float[2000];
    protected double[] vectorOutD = new double[2000];
    protected float[] vectorOutF = new float[2000];
    protected ArrayList<Double> doubleList = new ArrayList(2000);
    protected DoubleArrayList doubleArrayList = new DoubleArrayList(2000);
    protected double[] doubleArray = new double[2000];
    protected de.gsi.dataset.spi.DoubleDataSet dataSet1 = new de.gsi.dataset.spi.DoubleDataSet("test", 2000);
    protected DoubleDataSet dataSet2 = new DoubleDataSet("test", 2000);
    protected FloatDataSet dataSet3 = new FloatDataSet("test", 2000);

    public FloatToDoubleBenchmarkSample() {
        TRandom rnd = new TRandom(0L);
        for (int i = 0; i < 2000; ++i) {
            double val;
            for (int j = 0; j < 2000; ++j) {
                double val2;
                this.matrixD[i][j] = val2 = rnd.Rndm() - 0.5;
                this.matrixF[i][j] = (float)val2;
            }
            this.vectorInD[i] = val = rnd.Rndm() - 0.5;
            this.vectorInF[i] = (float)val;
            this.doubleList.add(i, val);
            this.doubleArrayList.add(i, val);
            this.doubleArray[i] = val;
            this.dataSet1.add((double)i, val);
            this.dataSet2.add(i, val);
            this.dataSet3.add((float)i, (float)val);
        }
    }

    public void testMatrixVectorMultiplicationDouble(int nIterations) {
        int i;
        long start = ProcessingProfiler.getTimeStamp();
        for (int iter = 0; iter < nIterations; ++iter) {
            for (i = 0; i < 2000; ++i) {
                this.vectorOutD[i] = 0.0;
                for (int j = 0; j < 2000; ++j) {
                    int n = i;
                    this.vectorOutD[n] = this.vectorOutD[n] + this.matrixD[i][j] * this.vectorInD[j];
                }
            }
            this.vectorInD = this.vectorOutD;
        }
        int rowSum = 0;
        for (i = 0; i < 2000; ++i) {
            rowSum = (int)((double)rowSum + this.vectorOutD[i]);
        }
        ProcessingProfiler.getTimeDiff((long)start, (String)("testMatrixVectorMultiplicationDouble() result = " + rowSum));
    }

    public void testMatrixVectorMultiplicationFloat(int nIterations) {
        int i;
        long start = ProcessingProfiler.getTimeStamp();
        for (int iter = 0; iter < nIterations; ++iter) {
            for (i = 0; i < 2000; ++i) {
                this.vectorOutF[i] = 0.0f;
                for (int j = 0; j < 2000; ++j) {
                    int n = i;
                    this.vectorOutF[n] = this.vectorOutF[n] + this.matrixF[i][j] * this.vectorInF[j];
                }
            }
            this.vectorInF = this.vectorOutF;
        }
        int rowSum = 0;
        for (i = 0; i < 2000; ++i) {
            rowSum = (int)((double)rowSum + this.vectorOutD[i]);
        }
        ProcessingProfiler.getTimeDiff((long)start, (String)("testMatrixVectorMultiplicationDouble() result = " + rowSum));
    }

    public void testDoubleListNative(int nIterations) {
        long start = ProcessingProfiler.getTimeStamp();
        for (int iter = 0; iter < nIterations; ++iter) {
            double temp = this.doubleList.get(0);
            for (int i = 1; i < 2000; ++i) {
                this.doubleList.set(i - 1, this.doubleList.get(i));
            }
            this.doubleList.set(this.doubleList.size() - 1, temp);
        }
        ProcessingProfiler.getTimeDiff((long)start, (String)("testDoubleList() result = " + this.doubleList.get(0)));
    }

    public void testDoubleArrayList1(int nIterations) {
        long start = ProcessingProfiler.getTimeStamp();
        for (int iter = 0; iter < nIterations; ++iter) {
            double temp = this.doubleArrayList.getDouble(0);
            for (int i = 1; i < 2000; ++i) {
                this.doubleArrayList.set(i - 1, this.doubleArrayList.getDouble(i));
            }
            this.doubleArrayList.set(this.doubleArrayList.size() - 1, temp);
        }
        ProcessingProfiler.getTimeDiff((long)start, (String)("testDoubleArrayList() result = " + this.doubleArrayList.getDouble(0)));
    }

    public void testDoubleArrayList2(int nIterations) {
        long start = ProcessingProfiler.getTimeStamp();
        for (int iter = 0; iter < nIterations; ++iter) {
            double temp = this.doubleArrayList.elements()[0];
            for (int i = 1; i < 2000; ++i) {
                this.doubleArrayList.elements()[i - 1] = this.doubleArrayList.elements()[i];
            }
            this.doubleArrayList.elements()[1999] = temp;
        }
        ProcessingProfiler.getTimeDiff((long)start, (String)("testDoubleArrayList() result = " + this.doubleArrayList.getDouble(0)));
    }

    public void testDoubleArrayPlain(int nIterations) {
        long start = ProcessingProfiler.getTimeStamp();
        for (int iter = 0; iter < nIterations; ++iter) {
            double temp = this.doubleArray[0];
            for (int i = 1; i < 2000; ++i) {
                this.doubleArray[i - 1] = this.doubleArray[i];
            }
            this.doubleArray[1999] = temp;
        }
        ProcessingProfiler.getTimeDiff((long)start, (String)("testDoubleArray() result = " + this.doubleArray[0]));
    }

    public void testDoubleDataSetOld1(int nIterations, boolean notify, boolean lock) {
        long start = ProcessingProfiler.getTimeStamp();
        if (lock) {
            this.dataSet2.lock();
        }
        if (!notify) {
            this.dataSet2.setAutoNotifaction(false);
        }
        for (int iter = 0; iter < nIterations / 2; ++iter) {
            double tempX = this.dataSet2.getX(0);
            double tempY = this.dataSet2.getY(0);
            for (int i = 1; i < 2000; ++i) {
                this.dataSet2.set(i - 1, this.dataSet2.getX(i), this.dataSet2.getY(i));
            }
            this.dataSet2.set(this.dataSet1.getDataCount() - 1, tempX, tempY);
        }
        if (!notify) {
            this.dataSet2.setAutoNotifaction(true);
        }
        if (lock) {
            this.dataSet2.unlock();
        }
        ProcessingProfiler.getTimeDiff((long)start, (String)("testDoubleDataSetOld1() result = " + this.dataSet2.getY(0)));
    }

    public void testDoubleDataSetOld2(int nIterations, boolean notify, boolean lock) {
        long start = ProcessingProfiler.getTimeStamp();
        if (lock) {
            this.dataSet2.lock();
        }
        if (!notify) {
            this.dataSet2.setAutoNotifaction(false);
        }
        for (int iter = 0; iter < nIterations / 2; ++iter) {
            double tempX = this.dataSet2.getXValues()[0];
            double tempY = this.dataSet2.getYValues()[0];
            for (int i = 1; i < 2000; ++i) {
                this.dataSet2.getXValues()[i - 1] = this.dataSet2.getXValues()[i];
                this.dataSet2.getYValues()[i - 1] = this.dataSet2.getYValues()[i];
            }
            this.dataSet2.getXValues()[1999] = tempX;
            this.dataSet2.getYValues()[1999] = tempY;
        }
        if (!notify) {
            this.dataSet2.setAutoNotifaction(true);
        }
        if (lock) {
            this.dataSet2.unlock();
        }
        ProcessingProfiler.getTimeDiff((long)start, (String)("testDoubleDataSetOld2() result = " + this.dataSet2.getY(0)));
    }

    public void testDoubleDataSetNew1(int nIterations, boolean notify, boolean lock) {
        long start = ProcessingProfiler.getTimeStamp();
        if (lock) {
            this.dataSet1.lock();
        }
        if (!notify) {
            this.dataSet1.setAutoNotifaction(false);
        }
        for (int iter = 0; iter < nIterations / 2; ++iter) {
            double tempX = this.dataSet1.getX(0);
            double tempY = this.dataSet1.getY(0);
            for (int i = 1; i < 2000; ++i) {
                this.dataSet1.set(i - 1, this.dataSet1.getX(i), this.dataSet1.getY(i));
            }
            this.dataSet1.set(this.dataSet1.getDataCount() - 1, tempX, tempY);
        }
        if (!notify) {
            this.dataSet1.setAutoNotifaction(true);
        }
        if (lock) {
            this.dataSet1.unlock();
        }
        ProcessingProfiler.getTimeDiff((long)start, (String)("testDoubleDataSetNew1() result = " + this.dataSet1.getY(0)));
    }

    public void testDoubleDataSetNew2(int nIterations, boolean notify, boolean lock) {
        long start = ProcessingProfiler.getTimeStamp();
        if (lock) {
            this.dataSet1.lock();
        }
        if (!notify) {
            this.dataSet1.setAutoNotifaction(false);
        }
        for (int iter = 0; iter < nIterations / 2; ++iter) {
            double tempX = this.dataSet1.getXValues()[0];
            double tempY = this.dataSet1.getYValues()[0];
            for (int i = 1; i < 2000; ++i) {
                this.dataSet1.getXValues()[i - 1] = this.dataSet1.getXValues()[i];
                this.dataSet1.getYValues()[i - 1] = this.dataSet1.getYValues()[i];
            }
            this.dataSet1.getXValues()[1999] = tempX;
            this.dataSet1.getYValues()[1999] = tempY;
        }
        if (!notify) {
            this.dataSet1.setAutoNotifaction(true);
        }
        if (lock) {
            this.dataSet1.unlock();
        }
        ProcessingProfiler.getTimeDiff((long)start, (String)("testDoubleDataSetNew2() result = " + this.dataSet1.getY(0)));
    }

    public void testFloatDataSetNew1(int nIterations, boolean notify, boolean lock) {
        long start = ProcessingProfiler.getTimeStamp();
        if (lock) {
            this.dataSet3.lock();
        }
        if (!notify) {
            this.dataSet3.setAutoNotifaction(false);
        }
        for (int iter = 0; iter < nIterations / 2; ++iter) {
            double tempX = this.dataSet3.getX(0);
            double tempY = this.dataSet3.getY(0);
            for (int i = 1; i < 2000; ++i) {
                this.dataSet3.set(i - 1, this.dataSet3.getX(i), this.dataSet3.getY(i));
            }
            this.dataSet3.set(this.dataSet3.getDataCount() - 1, tempX, tempY);
        }
        if (!notify) {
            this.dataSet3.setAutoNotifaction(true);
        }
        if (lock) {
            this.dataSet3.unlock();
        }
        ProcessingProfiler.getTimeDiff((long)start, (String)("testFloatDataSetNew1() result = " + this.dataSet3.getY(0)));
    }

    public void testFloatDataSetNew2(int nIterations, boolean notify, boolean lock) {
        long start = ProcessingProfiler.getTimeStamp();
        if (lock) {
            this.dataSet3.lock();
        }
        if (!notify) {
            this.dataSet3.setAutoNotifaction(false);
        }
        for (int iter = 0; iter < nIterations / 2; ++iter) {
            double tempX = this.dataSet3.getXFloatValues()[0];
            double tempY = this.dataSet3.getYFloatValues()[0];
            for (int i = 1; i < 2000; ++i) {
                this.dataSet3.getXFloatValues()[i - 1] = this.dataSet3.getXFloatValues()[i];
                this.dataSet3.getYFloatValues()[i - 1] = this.dataSet3.getYFloatValues()[i];
            }
            this.dataSet3.getXFloatValues()[1999] = (float)tempX;
            this.dataSet3.getYFloatValues()[1999] = (float)tempY;
        }
        if (!notify) {
            this.dataSet3.setAutoNotifaction(true);
        }
        if (lock) {
            this.dataSet3.unlock();
        }
        ProcessingProfiler.getTimeDiff((long)start, (String)("testFloatDataSetNew2() result = " + this.dataSet3.getY(0)));
    }

    public static void main(String[] args) {
        ProcessingProfiler.setVerboseOutputState((boolean)true);
        ProcessingProfiler.setDebugState((boolean)true);
        int nIterations = 1000;
        FloatToDoubleBenchmarkSample benchmark = new FloatToDoubleBenchmarkSample();
        System.err.println("\n\n\ndouble array access performance test:");
        int nMul = 100;
        benchmark.testDoubleListNative(100000);
        benchmark.testDoubleArrayList1(100000);
        benchmark.testDoubleArrayList2(100000);
        benchmark.testDoubleArrayPlain(100000);
        benchmark.testDoubleDataSetOld1(100000, false, false);
        benchmark.testDoubleDataSetOld2(100000, false, false);
        benchmark.testDoubleDataSetNew1(100000, false, false);
        benchmark.testDoubleDataSetNew2(100000, false, false);
        benchmark.testFloatDataSetNew1(100000, false, false);
        benchmark.testFloatDataSetNew2(100000, false, false);
        System.out.println("");
        benchmark.testDoubleListNative(100000);
        benchmark.testDoubleArrayList1(100000);
        benchmark.testDoubleArrayList2(100000);
        benchmark.testDoubleArrayPlain(100000);
        benchmark.testDoubleDataSetOld1(100000, false, false);
        benchmark.testDoubleDataSetOld2(100000, false, false);
        benchmark.testDoubleDataSetNew1(100000, false, false);
        benchmark.testDoubleDataSetNew2(100000, false, false);
        benchmark.testFloatDataSetNew1(100000, false, false);
        benchmark.testFloatDataSetNew2(100000, false, false);
        System.out.println("");
        benchmark.testDoubleListNative(100000);
        benchmark.testDoubleArrayList1(100000);
        benchmark.testDoubleArrayList2(100000);
        benchmark.testDoubleArrayPlain(100000);
        benchmark.testDoubleDataSetOld1(100000, false, false);
        benchmark.testDoubleDataSetOld2(100000, false, false);
        benchmark.testDoubleDataSetNew1(100000, false, false);
        benchmark.testDoubleDataSetNew2(100000, false, false);
        benchmark.testFloatDataSetNew1(100000, false, false);
        benchmark.testFloatDataSetNew2(100000, false, false);
    }
}

