/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.samples;

import de.gsi.dataset.spi.CircularDoubleErrorDataSet;
import de.gsi.dataset.spi.FifoDoubleErrorDataSet;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.util.Timer;
import java.util.TimerTask;

public class FifoDoubleErrorDataSetSample {
    public static void main(String[] args) {
        int bufferLength = 10;
        int fillBufferLength = 35;
        FifoDoubleErrorDataSet buffer1 = new FifoDoubleErrorDataSet("test", 10, 10.0);
        CircularDoubleErrorDataSet buffer2 = new CircularDoubleErrorDataSet("test", 10);
        for (int i = 0; i < 35; ++i) {
            double delta = i >= 13 ? 5.0 : 0.0;
            double t = (double)i + delta;
            if (i == 13) {
                System.err.println("jump in time by +" + delta);
            }
            buffer1.add(t, (double)i, 0.0, 0.0);
            buffer2.add(t, (double)i, 0.0, 0.0);
            int max1 = Math.max(0, buffer1.getDataCount() - 1);
            int max2 = Math.max(0, buffer2.getDataCount() - 1);
            String msg = String.format("%2d - [ %2d vs. %2d , %2d vs. %2d] - length = %2d vs %2d", i, (int)buffer1.getX(0), (int)buffer2.getX(0), (int)buffer1.getX(max1), (int)buffer2.getX(max2), max1, max2);
            System.err.println(msg);
        }
        ProcessingProfiler.setVerboseOutputState((boolean)true);
        ProcessingProfiler.setLoggerOutputState((boolean)true);
        ProcessingProfiler.setDebugState((boolean)true);
        long start = ProcessingProfiler.getTimeStamp();
        FifoDoubleErrorDataSet buffer3 = new FifoDoubleErrorDataSet("test", 1000, 100.0);
        for (int i = 0; i < 10000; ++i) {
            buffer3.add((double)i, 1.0, 0.0, 0.0);
        }
        ProcessingProfiler.getTimeDiff((long)start, (String)"init and write 10k times");
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                System.gc();
            }
        }, 5L, 2000L);
        while (true) {
            buffer3.add((double)System.currentTimeMillis() * 0.001, 1.0, 0.0, 0.0);
        }
    }
}

