/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.samples;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.testdata.spi.RandomDataGenerator;
import de.gsi.dataset.utils.DataSetSerialiser;
import de.gsi.dataset.utils.DataSetUtils;
import de.gsi.dataset.utils.ProcessingProfiler;
import de.gsi.dataset.utils.serializer.FastByteBuffer;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.TimeUnit;

public class DataSetToByteArraySample {
    private static final int N_SAMPLES = 100000;
    private final DoubleErrorDataSet original = new DoubleErrorDataSet("init", 100000);
    private final ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
    private final FastByteBuffer byteBuffer = new FastByteBuffer();

    public DataSetToByteArraySample() {
        System.err.println(DataSetToByteArraySample.class.getSimpleName() + " - init");
        this.generateData(this.original);
        System.err.println(DataSetToByteArraySample.class.getSimpleName() + " - generated data");
        DataSetUtils.writeDataSetToByteArray((DataSet)this.original, (ByteArrayOutputStream)this.byteOutput, (boolean)false, (boolean)false);
        System.err.printf("byte buffer array length with string encoding =%s%n", DataSetToByteArraySample.humanReadableByteCount(this.byteOutput.size(), true));
        DataSetUtils.writeDataSetToByteArray((DataSet)this.original, (ByteArrayOutputStream)this.byteOutput, (boolean)true, (boolean)true);
        System.err.printf("byte buffer array length with 32-bit binary encoding =  =%s%n", DataSetToByteArraySample.humanReadableByteCount(this.byteOutput.size(), true));
        DataSetUtils.writeDataSetToByteArray((DataSet)this.original, (ByteArrayOutputStream)this.byteOutput, (boolean)true, (boolean)false);
        System.err.printf("byte buffer array length with 64-bit binary encoding =  =%s%n", DataSetToByteArraySample.humanReadableByteCount(this.byteOutput.size(), true));
        this.byteBuffer.ensureCapacity(this.byteOutput.size() + 1000);
    }

    protected boolean floatIdentity(double a, double b) {
        return (double)Math.abs((float)a - (float)b) <= 2.0 / Math.pow(2.0, 23.0);
    }

    public void testDataSetUtilsIdentity(boolean binary, boolean asFloat32) {
        DataSetUtils.writeDataSetToByteArray((DataSet)this.original, (ByteArrayOutputStream)this.byteOutput, (boolean)binary, (boolean)asFloat32);
        DoubleErrorDataSet dataSet = DataSetUtils.readDataSetFromByteArray((byte[])this.byteOutput.toByteArray());
        this.testIdentityCore(binary, asFloat32, this.original, dataSet);
        System.err.printf("testDataSetUtilsIdentity passed for %s-bit %s-based encoding with partial meta-data%n", asFloat32 ? "32" : "64", binary ? "binary" : "string");
    }

    public void testDataSetSerialiserIdentity(boolean withMetaData, boolean asFloat32) {
        DataSetSerialiser.setMetaDataSerialised((boolean)true);
        DataSetSerialiser.setDataLablesSerialised((boolean)false);
        this.byteBuffer.reset();
        DataSetSerialiser.writeDataSetToByteArray((DataSet)this.original, (FastByteBuffer)this.byteBuffer, (boolean)asFloat32);
        this.byteBuffer.reset();
        DoubleErrorDataSet dataSet = (DoubleErrorDataSet)DataSetSerialiser.readDataSetFromByteArray((FastByteBuffer)this.byteBuffer);
        this.testIdentityCore(true, asFloat32, this.original, dataSet);
        this.testIdentityLabelsAndStyles(true, asFloat32, this.original, dataSet);
        this.testIdentityMetaData(true, asFloat32, this.original, dataSet);
        System.err.printf("testDataSetSerialiserIdentity passed for %s-bit binary-based encoding %s meta-data%n", asFloat32 ? "32" : "64", withMetaData ? "with" : "w/o");
    }

    public void testIdentityCore(boolean binary, boolean asFloat32, DoubleErrorDataSet originalDS, DoubleErrorDataSet testDS) {
        String binaryStr;
        String string = binaryStr = binary ? "binary-based" : "string-based";
        if (originalDS.getDataCount() != testDS.getDataCount()) {
            throw new IllegalStateException("data set counts do not match (" + binaryStr + "): original = " + originalDS.getDataCount() + " vs. copy = " + testDS.getDataCount());
        }
        if (!originalDS.getName().equals(testDS.getName())) {
            throw new IllegalStateException("data set name do not match (" + binaryStr + "): original = " + originalDS.getName() + " vs. copy = " + testDS.getName());
        }
        for (int i = 0; i < originalDS.getDataCount(); ++i) {
            double x0 = originalDS.getX(i);
            double y0 = originalDS.getY(i);
            double exn0 = originalDS.getXErrorNegative(i);
            double exp0 = originalDS.getXErrorPositive(i);
            double eyn0 = originalDS.getYErrorNegative(i);
            double eyp0 = originalDS.getYErrorPositive(i);
            double x1 = testDS.getX(i);
            double y1 = testDS.getY(i);
            double exn1 = testDS.getXErrorNegative(i);
            double exp1 = testDS.getXErrorPositive(i);
            double eyn1 = testDS.getYErrorNegative(i);
            double eyp1 = testDS.getYErrorPositive(i);
            if (asFloat32) {
                if (this.floatIdentity(x0, x1) && this.floatIdentity(y0, y1) && this.floatIdentity(exn0, exn1) && this.floatIdentity(exp0, exp1) && this.floatIdentity(eyn0, eyn1) && eyp0 == eyp1) continue;
                String diff = String.format("(x=%e - %e, y=%e - %e, exn=%e - %e, exp=%e - %e, eyn=%e - %e, eyp=%e - %e)", x0, x1, y0, y1, exn0, exn1, exp0, exp1, eyn0, eyn1, eyp0, eyp1);
                String delta = String.format("(dx=%e, dy=%e, dexn=%e, dexp=%e, deyn=%e, deyp=%e)", x0 - x1, y0 - y1, exn0 - exn1, exp0 - exp1, eyn0 - eyn1, eyp0 - eyp1);
                String msg = String.format("data set values do not match (%s): original-copy = at index %d%n%s%n%s%n", binaryStr, i, diff, delta);
                throw new IllegalStateException(msg);
            }
            if (x0 == x1 && y0 == y1 && exn0 == exn1 && exp0 == exp1 && eyn0 == eyn1 && eyp0 == eyp1) continue;
            String diff = String.format("(x=%e - %e, y=%e - %e, exn=%e - %e, exp=%e - %e, eyn=%e - %e, eyp=%e - %e)", x0, x1, y0, y1, exn0, exn1, exp0, exp1, eyn0, eyn1, eyp0, eyp1);
            String delta = String.format("(dx=%e, dy=%e, dexn=%e, dexp=%e, deyn=%e, deyp=%e)", x0 - x1, y0 - y1, exn0 - exn1, exp0 - exp1, eyn0 - eyn1, eyp0 - eyp1);
            String msg = String.format("data set values do not match (%s): original-copy = at index %d%n%s%n%s%n", binaryStr, i, diff, delta);
            throw new IllegalStateException(msg);
        }
    }

    public void testIdentityLabelsAndStyles(boolean binary, boolean asFloat32, DoubleErrorDataSet originalDS, DoubleErrorDataSet testDS) {
        int i;
        String binaryStr = binary ? "binary-based" : "string-based";
        for (i = 0; i < originalDS.getDataCount(); ++i) {
            if (originalDS.getDataLabel(i) == null && testDS.getDataLabel(i) == null || originalDS.getDataLabel(i) != testDS.getDataLabel(i)) continue;
            String msg = String.format("data set label do not match (%s): original(%d) ='%s' vs. copy(%d) ='%s' %n", binaryStr, i, originalDS.getDataLabel(i), i, testDS.getDataLabel(i));
            throw new IllegalStateException(msg);
        }
        for (i = 0; i < originalDS.getDataCount(); ++i) {
            if (originalDS.getStyle(i) == null && testDS.getStyle(i) == null || originalDS.getStyle(i) != testDS.getStyle(i)) continue;
            String msg = String.format("data set style do not match (%s): original(%d) ='%s' vs. copy(%d) ='%s' %n", binaryStr, i, originalDS.getStyle(i), i, testDS.getStyle(i));
            throw new IllegalStateException(msg);
        }
    }

    public void testIdentityMetaData(boolean binary, boolean asFloat32, DoubleErrorDataSet originalDS, DoubleErrorDataSet testDS) {
        String binaryStr;
        String string = binaryStr = binary ? "binary-based" : "string-based";
        if (!originalDS.getInfoList().equals(testDS.getInfoList())) {
            String msg = String.format("data set info lists do not match (%s): original ='%s' vs. copy ='%s' %n", binaryStr, originalDS.getInfoList(), testDS.getInfoList());
            throw new IllegalStateException(msg);
        }
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public void testPerformance(int iterations, boolean binary, boolean asFloat32) {
        long startTime = ProcessingProfiler.getTimeStamp();
        for (int i = 0; i < iterations; ++i) {
            DataSetUtils.writeDataSetToByteArray((DataSet)this.original, (ByteArrayOutputStream)this.byteOutput, (boolean)binary, (boolean)asFloat32);
            DoubleErrorDataSet dataSet = DataSetUtils.readDataSetFromByteArray((byte[])this.byteOutput.toByteArray());
            if (this.original.getName().equals(dataSet.getName())) continue;
            System.err.println("ERROR data set does not match -> potential streaming error at index = " + i);
            break;
        }
        long stopTime = ProcessingProfiler.getTimeDiff((long)startTime, (String)"generating data DataSet");
        double diffMillis = TimeUnit.NANOSECONDS.toMillis(stopTime - startTime);
        double byteCount = (double)iterations * ((double)this.byteOutput.size() / diffMillis * 1000.0);
        System.err.printf("average %s-bit binary-encoded DataSetUtils throughput with partial meta infos = %s/s%n", asFloat32 ? "32" : "64", DataSetToByteArraySample.humanReadableByteCount((long)byteCount, true));
    }

    public void testSerializerPerformance(int iterations, boolean withMetaInfos, boolean asFloat32) {
        DataSetSerialiser.setMetaDataSerialised((boolean)withMetaInfos);
        DataSetSerialiser.setDataLablesSerialised((boolean)withMetaInfos);
        long startTime = ProcessingProfiler.getTimeStamp();
        this.byteBuffer.reset();
        for (int i = 0; i < iterations; ++i) {
            this.byteBuffer.reset();
            DataSetSerialiser.writeDataSetToByteArray((DataSet)this.original, (FastByteBuffer)this.byteBuffer, (boolean)asFloat32);
            this.byteBuffer.reset();
            DataSet dataSet = DataSetSerialiser.readDataSetFromByteArray((FastByteBuffer)this.byteBuffer);
            if (this.original.getName().equals(dataSet.getName())) continue;
            System.err.println("ERROR data set does not match -> potential streaming error at index = " + i);
            break;
        }
        long stopTime = ProcessingProfiler.getTimeDiff((long)startTime, (String)"generating data DataSet");
        double diffMillis = TimeUnit.NANOSECONDS.toMillis(stopTime - startTime);
        double byteCount = (double)iterations * ((double)this.byteBuffer.getPosition() / diffMillis * 1000.0);
        System.err.printf("average %s-bit binary-encoded DataSetSerialiser throughput %s meta infos = %s/s%n", asFloat32 ? "32" : "64", withMetaInfos ? "with" : "w/o", DataSetToByteArraySample.humanReadableByteCount((long)byteCount, true));
    }

    private void generateData(DoubleErrorDataSet dataSet) {
        long startTime = ProcessingProfiler.getTimeStamp();
        dataSet.setAutoNotifaction(false);
        dataSet.clearData();
        dataSet.setName("data set name" + System.currentTimeMillis());
        double oldY = 0.0;
        for (int n = 0; n < 100000; ++n) {
            double x = n;
            double y = (oldY += RandomDataGenerator.random() - 0.5) + (n == 500000 ? 500.0 : 0.0);
            double eyNeg = 0.1;
            double eyPos = 10.0;
            dataSet.set(n, x, y, 0.1, 10.0);
            if (n != 5000) continue;
            dataSet.getDataLabelMap().put((Object)n, (Object)"special outlier");
            dataSet.getDataStyleMap().put((Object)n, (Object)"-stroke-color=red");
        }
        dataSet.getInfoList().add("standard info1");
        dataSet.getInfoList().add("standard info2");
        dataSet.getWarningList().add("standard warning");
        dataSet.getErrorList().add("standard error");
        dataSet.getMetaInfo().put("metaKey#1", "metaValue#1");
        dataSet.getMetaInfo().put("metaKey#2", "metaValue#2");
        dataSet.getMetaInfo().put("metaKey#3", "metaValue#3");
        dataSet.setAutoNotifaction(true);
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"generating data DataSet");
    }

    public void clearGarbage() {
        System.gc();
        System.gc();
        System.err.println("");
    }

    public static void main(String[] args) {
        boolean bit32;
        int n;
        int n2;
        int n3;
        Boolean[] booleanArray;
        boolean bit322;
        int n4;
        ProcessingProfiler.setVerboseOutputState((boolean)true);
        ProcessingProfiler.setLoggerOutputState((boolean)true);
        ProcessingProfiler.setDebugState((boolean)true);
        DataSetToByteArraySample sample = new DataSetToByteArraySample();
        Boolean[] booleanArray2 = new Boolean[]{true, false};
        int n5 = booleanArray2.length;
        for (n4 = 0; n4 < n5; ++n4) {
            bit322 = booleanArray2[n4];
            booleanArray = new Boolean[]{false, true};
            n3 = booleanArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                boolean binary = booleanArray[n2];
                sample.testDataSetUtilsIdentity(binary, bit322);
            }
        }
        sample.clearGarbage();
        booleanArray2 = new Boolean[]{true, false};
        n5 = booleanArray2.length;
        for (n4 = 0; n4 < n5; ++n4) {
            bit322 = booleanArray2[n4];
            booleanArray = new Boolean[]{false, true};
            n3 = booleanArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                boolean withMetaData = booleanArray[n2];
                sample.testDataSetSerialiserIdentity(withMetaData, bit322);
            }
        }
        sample.clearGarbage();
        sample.testPerformance(100, false, true);
        sample.testPerformance(100, false, false);
        sample.clearGarbage();
        int iterations = 4;
        int nLoops = 200;
        Boolean[] booleanArray3 = new Boolean[]{true, false};
        int n6 = booleanArray3.length;
        for (n = 0; n < n6; ++n) {
            bit32 = booleanArray3[n];
            for (int i = 0; i < 4; ++i) {
                sample.testPerformance(200, true, bit32);
            }
            sample.clearGarbage();
        }
        booleanArray3 = new Boolean[]{true, false};
        n6 = booleanArray3.length;
        for (n = 0; n < n6; ++n) {
            bit32 = booleanArray3[n];
            Boolean[] booleanArray4 = new Boolean[]{true, false};
            int n7 = booleanArray4.length;
            for (int i = 0; i < n7; ++i) {
                boolean header = booleanArray4[i];
                for (int i2 = 0; i2 < 4; ++i2) {
                    sample.testSerializerPerformance(200, header, bit32);
                }
                sample.clearGarbage();
            }
        }
    }
}

