/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.testdata.spi.CosineFunction;
import de.gsi.dataset.testdata.spi.GaussFunction;
import de.gsi.dataset.testdata.spi.RandomWalkFunction;
import de.gsi.dataset.testdata.spi.SineFunction;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

public class MultipleAxesSample
extends Application {
    private static final int N_SAMPLES = 10000;
    private static final int UPDATE_DELAY = 1000;
    private static final int UPDATE_PERIOD = 1000;
    private Timer timer;

    public void start(Stage primaryStage) {
        if (Platform.isSupported((ConditionalFeature)ConditionalFeature.TRANSPARENT_WINDOW)) {
            Application.setUserAgentStylesheet((String)Chart.class.getResource("solid-pick.css").toExternalForm());
        }
        ProcessingProfiler.setVerboseOutputState((boolean)true);
        ProcessingProfiler.setLoggerOutputState((boolean)true);
        ProcessingProfiler.setDebugState((boolean)false);
        BorderPane root = new BorderPane();
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        DefaultNumericAxis xAxis1 = new DefaultNumericAxis("x axis", "a.u.");
        xAxis1.setAnimated(false);
        DefaultNumericAxis yAxis1 = new DefaultNumericAxis("y axis (random)", "a.u.");
        yAxis1.setAnimated(false);
        DefaultNumericAxis yAxis2 = new DefaultNumericAxis("y axis (sine/cosine)", "a.u.");
        yAxis2.setSide(Side.RIGHT);
        yAxis2.setAnimated(false);
        DefaultNumericAxis yAxis3 = new DefaultNumericAxis("y axis (gauss)", "a.u.");
        yAxis3.setSide(Side.RIGHT);
        yAxis3.invertAxis(true);
        yAxis3.setAnimated(false);
        XYChart chart = new XYChart((Axis)xAxis1, (Axis)yAxis1);
        ErrorDataSetRenderer errorRenderer2 = new ErrorDataSetRenderer();
        errorRenderer2.getAxes().add((Object)yAxis2);
        ErrorDataSetRenderer errorRenderer3 = new ErrorDataSetRenderer();
        errorRenderer3.getAxes().add((Object)yAxis3);
        chart.getRenderers().addAll((Object[])new Renderer[]{errorRenderer2, errorRenderer3});
        Zoomer zoom = new Zoomer();
        chart.getPlugins().add((Object)zoom);
        chart.getPlugins().add((Object)new EditAxis());
        Button newDataSet = new Button("new DataSet");
        newDataSet.setOnAction(evt -> Platform.runLater((Runnable)this.getTask((Renderer)chart.getRenderers().get(0), (Renderer)errorRenderer2, (Renderer)errorRenderer3)));
        Button startTimer = new Button("timer");
        startTimer.setOnAction(evt -> {
            if (this.timer == null) {
                this.timer = new Timer();
                this.timer.scheduleAtFixedRate(this.getTask((Renderer)chart.getRenderers().get(0), (Renderer)errorRenderer2, (Renderer)errorRenderer3), 1000L, 1000L);
            } else {
                this.timer.cancel();
                this.timer = null;
            }
        });
        root.setTop((Node)new HBox(new Node[]{newDataSet, startTimer}));
        this.getTask((Renderer)chart.getRenderers().get(0), (Renderer)errorRenderer2, (Renderer)errorRenderer3).run();
        long startTime = ProcessingProfiler.getTimeStamp();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data to chart");
        startTime = ProcessingProfiler.getTimeStamp();
        root.setCenter((Node)chart);
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding chart into StackPane");
        startTime = ProcessingProfiler.getTimeStamp();
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> System.exit(0));
        primaryStage.show();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"for showing");
    }

    public TimerTask getTask(final Renderer renderer1, final Renderer renderer2, final Renderer renderer3) {
        return new TimerTask(){
            int updateCount;

            @Override
            public void run() {
                Platform.runLater(() -> {
                    renderer1.getDatasets().setAll((Object[])new DataSet[]{new RandomWalkFunction("random walk", 10000)});
                    renderer2.getDatasets().setAll((Object[])new DataSet[]{new CosineFunction("cosy", 10000, true), new SineFunction("siny", 10000, true)});
                    renderer3.getDatasets().setAll((Object[])new DataSet[]{new GaussFunction("gaussy", 10000)});
                    if (this.updateCount % 10 == 0) {
                        System.out.println("update iteration #" + this.updateCount);
                    }
                    ++this.updateCount;
                });
            }
        };
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

