/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.chart.plugins.TableViewer;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.utils.SimplePerformanceMeter;
import de.gsi.dataset.spi.DoubleDataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.testdata.spi.RandomDataGenerator;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.stage.Stage;

public class ErrorDataSetRendererSample
extends Application {
    private static final int DEBUG_UPDATE_RATE = 1000;
    private static final int N_SAMPLES = 1000000;
    private static final int UPDATE_DELAY = 1000;
    private static final int UPDATE_PERIOD = 200;
    final DoubleErrorDataSet dataSet = new DoubleErrorDataSet("TestData", 1000000);
    final DoubleDataSet dataSetNoError = new DoubleDataSet("TestDataNoErrors", 1000000);
    private Timer timer;

    public void start(Stage primaryStage) {
        ProcessingProfiler.setVerboseOutputState((boolean)true);
        ProcessingProfiler.setLoggerOutputState((boolean)true);
        ProcessingProfiler.setDebugState((boolean)false);
        BorderPane root = new BorderPane();
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        XYChart chart = new XYChart((Axis)new DefaultNumericAxis(), (Axis)new DefaultNumericAxis());
        chart.legendVisibleProperty().set(true);
        chart.getXAxis().setLabel("time");
        chart.getXAxis().setUnit("s");
        chart.getXAxis().setAutoUnitScaling(true);
        chart.getYAxis().setLabel("y-axis");
        chart.getYAxis().setAutoUnitScaling(true);
        chart.legendVisibleProperty().set(true);
        chart.getPlugins().add((Object)new ParameterMeasurements());
        chart.getPlugins().add((Object)new EditAxis());
        Zoomer zoomer = new Zoomer();
        zoomer.setUpdateTickUnit(true);
        chart.getPlugins().add((Object)zoomer);
        chart.getPlugins().add((Object)new TableViewer());
        chart.setAnimated(false);
        ErrorDataSetRenderer errorRenderer = new ErrorDataSetRenderer();
        chart.getRenderers().setAll((Object[])new Renderer[]{errorRenderer});
        errorRenderer.setErrorType(ErrorStyle.ERRORBARS);
        errorRenderer.setErrorType(ErrorStyle.ERRORCOMBO);
        errorRenderer.setDrawMarker(true);
        errorRenderer.setMarkerSize(1.0);
        root.setTop((Node)this.getHeaderBar(chart, scene));
        this.generateData(this.dataSet, this.dataSetNoError);
        long startTime = ProcessingProfiler.getTimeStamp();
        chart.getDatasets().add((Object)this.dataSet);
        chart.getDatasets().add((Object)this.dataSetNoError);
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data to chart");
        startTime = ProcessingProfiler.getTimeStamp();
        root.setCenter((Node)chart);
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding chart into StackPane");
        startTime = ProcessingProfiler.getTimeStamp();
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> System.exit(0));
        primaryStage.show();
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"for showing");
    }

    private HBox getHeaderBar(XYChart chart, Scene scene) {
        Button newDataSet = new Button("new DataSet");
        newDataSet.setOnAction(evt -> Platform.runLater((Runnable)this.getTimerTask(chart)));
        Button startTimer = new Button("timer");
        startTimer.setOnAction(evt -> {
            if (this.timer == null) {
                this.timer = new Timer();
                this.timer.scheduleAtFixedRate(this.getTimerTask(chart), 1000L, 200L);
            } else {
                this.timer.cancel();
                this.timer = null;
            }
        });
        Region spacer = new Region();
        spacer.setMinWidth(Double.NEGATIVE_INFINITY);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        SimplePerformanceMeter meter = new SimplePerformanceMeter(scene, 1000L);
        Label fxFPS = new Label();
        fxFPS.setFont(Font.font((String)"Monospaced", (double)12.0));
        Label chartFPS = new Label();
        chartFPS.setFont(Font.font((String)"Monospaced", (double)12.0));
        Label cpuLoadProcess = new Label();
        cpuLoadProcess.setFont(Font.font((String)"Monospaced", (double)12.0));
        Label cpuLoadSystem = new Label();
        cpuLoadSystem.setFont(Font.font((String)"Monospaced", (double)12.0));
        meter.fxFrameRateProperty().addListener((ch, o, n) -> {
            String fxRate = String.format("%4.1f", meter.getFxFrameRate());
            String actualRate = String.format("%4.1f", meter.getActualFrameRate());
            String cpuProcess = String.format("%5.1f", meter.getProcessCpuLoad());
            String cpuSystem = String.format("%5.1f", meter.getSystemCpuLoad());
            fxFPS.setText(String.format("%-6s: %4s %s", "JavaFX", fxRate, "FPS, "));
            chartFPS.setText(String.format("%-6s: %4s %s", "Actual", actualRate, "FPS, "));
            cpuLoadProcess.setText(String.format("%-11s: %4s %s", "Process-CPU", cpuProcess, "%"));
            cpuLoadSystem.setText(String.format("%-11s: %4s %s", "System -CPU", cpuSystem, "%"));
        });
        return new HBox(new Node[]{newDataSet, startTimer, spacer, new VBox(new Node[]{fxFPS, chartFPS}), new VBox(new Node[]{cpuLoadProcess, cpuLoadSystem})});
    }

    private TimerTask getTimerTask(XYChart chart) {
        return new TimerTask(){
            int updateCount = 0;

            @Override
            public void run() {
                Platform.runLater(() -> {
                    ErrorDataSetRendererSample.this.generateData(ErrorDataSetRendererSample.this.dataSet, ErrorDataSetRendererSample.this.dataSetNoError);
                    if (this.updateCount % 10 == 0) {
                        System.out.println("update iteration #" + this.updateCount);
                    }
                    ++this.updateCount;
                });
            }
        };
    }

    private void generateData(DoubleErrorDataSet dataSet, DoubleDataSet dataSetNoErrors) {
        long startTime = ProcessingProfiler.getTimeStamp();
        dataSet.setAutoNotifaction(false);
        dataSetNoErrors.setAutoNotifaction(false);
        dataSet.clearData();
        dataSetNoErrors.clearData();
        double oldY = 0.0;
        for (int n = 0; n < 1000000; ++n) {
            double x = n;
            double y = (oldY += RandomDataGenerator.random() - 0.5) + (n == 500000 ? 500.0 : 0.0);
            double ex = 0.1;
            double ey = 10.0;
            dataSet.set(n, x, y, 0.1, 10.0);
            dataSetNoErrors.set(n, x, y + 20.0);
            if (n != 500000) continue;
            dataSet.getDataLabelMap().put((Object)n, (Object)"special outlier");
            dataSetNoErrors.getDataLabelMap().put((Object)n, (Object)"special outlier");
        }
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"generating data DataSet");
        dataSetNoErrors.setAutoNotifaction(true);
        dataSet.setAutoNotifaction(true);
        dataSet.fireInvalidated(null);
        ProcessingProfiler.getTimeDiff((long)startTime, (String)"adding data into DataSet");
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

