/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.DataPointTooltip;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.EditDataSet;
import de.gsi.chart.plugins.Panner;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.EditConstraints;
import de.gsi.dataset.spi.DoubleDataSet;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class EditDataSetSample
extends Application {
    private static final int N_SAMPLES = 100;

    public void start(Stage primaryStage) {
        StackPane root = new StackPane();
        XYChart chart = new XYChart((Axis)new DefaultNumericAxis(), (Axis)new DefaultNumericAxis());
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new Panner());
        chart.getPlugins().add((Object)new EditAxis());
        chart.getPlugins().add((Object)new EditDataSet());
        chart.getPlugins().add((Object)new DataPointTooltip());
        root.getChildren().add((Object)chart);
        DoubleDataSet dataSet1 = new DoubleDataSet("data set #1 (full change)");
        final DoubleDataSet dataSet2 = new DoubleDataSet("data set #2 (modify y-only)");
        chart.getDatasets().addAll((Object[])new DataSet[]{dataSet1, dataSet2});
        double[] xValues = new double[100];
        double[] yValues1 = new double[100];
        double[] yValues2 = new double[100];
        for (int n = 0; n < 100; ++n) {
            xValues[n] = n;
            yValues1[n] = Math.cos(Math.toRadians(10.0 * (double)n));
            yValues2[n] = Math.sin(Math.toRadians(10.0 * (double)n));
        }
        dataSet1.set(xValues, yValues1);
        dataSet2.set(xValues, yValues2);
        dataSet2.setEditConstraints(new EditConstraints(){

            public boolean canDelete(int index) {
                return index > 4 && index < dataSet2.getDataCount() - 6 && index != 25;
            }

            public boolean canAdd(int index) {
                return true;
            }

            public boolean canChange(int index) {
                return index > 4 && index < dataSet2.getDataCount() - 6 && index != 25;
            }

            public boolean isXEditable() {
                return false;
            }

            public boolean isYEditable() {
                return true;
            }
        });
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest(evt -> System.exit(0));
        primaryStage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

