/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.chart.utils.GlyphFactory;
import de.gsi.chart.viewer.DataView;
import de.gsi.chart.viewer.DataViewPane;
import de.gsi.chart.viewer.DataViewer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DoubleDataSet;
import de.gsi.dataset.testdata.TestDataSet;
import de.gsi.dataset.testdata.spi.RandomStepFunction;
import de.gsi.dataset.testdata.spi.RandomWalkFunction;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import org.controlsfx.glyphfont.FontAwesome;

public class DataViewerSample
extends Application {
    private static final String TITLE = "DataViewer Sample";
    private static final int NUMBER_OF_POINTS = 10000;
    private static final int UPDATE_PERIOD = 1000;
    private static final int NUM_OF_POINTS = 20;

    public void start(Stage primaryStage) {
        ProcessingProfiler.setVerboseOutputState((boolean)false);
        primaryStage.setTitle(TITLE);
        XYChart energyChart = new XYChart((Axis)this.createXAxis(), (Axis)this.createYAxis());
        energyChart.setAnimated(false);
        energyChart.setLegendVisible(true);
        energyChart.getYAxis().setLabel("Energy");
        energyChart.getDatasets().addAll(this.createSeries());
        XYChart currentChart = new XYChart((Axis)this.createXAxis(), (Axis)this.createYAxis());
        currentChart.setAnimated(false);
        currentChart.getRenderers().clear();
        ErrorDataSetRenderer errorDataSetRenderer = new ErrorDataSetRenderer();
        errorDataSetRenderer.setErrorType(ErrorStyle.NONE);
        currentChart.getRenderers().add((Object)errorDataSetRenderer);
        ((Region)currentChart.getYAxis()).lookup(".axis-label").setStyle("-fx-text-fill: green;");
        currentChart.getYAxis().setLabel("Current");
        currentChart.getYAxis().setSide(Side.RIGHT);
        currentChart.getDatasets().addAll(this.createSeries());
        DataViewPane currentView = new DataViewPane("Current", currentChart);
        XYChart jDataViewerChart = this.createChart();
        DataViewPane jDataViewerPane = new DataViewPane("JDataViewerChart", jDataViewerChart);
        DataView view1 = new DataView("DV1");
        DataViewPane energyView = new DataViewPane("Energy", energyChart);
        energyView.setGraphic((Node)GlyphFactory.create((FontAwesome.Glyph)FontAwesome.Glyph.ADJUST));
        energyView.switchToTableView();
        view1.getChildren().addAll((Object[])new DataViewPane[]{energyView, currentView, jDataViewerPane});
        DataViewer viewer = new DataViewer();
        viewer.getViews().add((Object)view1);
        viewer.setExplorerVisible(true);
        BorderPane borderPane = new BorderPane((Node)viewer);
        Button newView = new Button("add new view");
        newView.setOnAction(evt -> {
            int count = viewer.getViews().size();
            XYChart jChart = this.createChart();
            DataViewPane newDataViewerPane = new DataViewPane("Chart" + count, jChart);
            view1.getChildren().add((Object)newDataViewerPane);
            viewer.requestLayout();
        });
        Button sortButton = new Button("sort");
        sortButton.setOnAction(evt -> viewer.sort());
        ComboBox sortChoice = new ComboBox();
        sortChoice.getItems().addAll((Object[])DataView.Layout.values());
        sortChoice.getSelectionModel().select((Object)viewer.getSelectedView().getLayout());
        sortChoice.setOnAction(evt -> viewer.getSelectedView().setLayout((DataView.Layout)sortChoice.getSelectionModel().getSelectedItem()));
        borderPane.setTop((Node)new HBox(new Node[]{newView, sortButton, sortChoice}));
        Scene scene = new Scene((Parent)borderPane, 800.0, 600.0);
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setOnCloseRequest(e -> {
            Platform.exit();
            System.exit(0);
        });
    }

    private DefaultNumericAxis createYAxis() {
        DefaultNumericAxis yAxis = this.createXAxis();
        yAxis.setAutoRangePadding(0.1);
        return yAxis;
    }

    private DefaultNumericAxis createXAxis() {
        DefaultNumericAxis xAxis = new DefaultNumericAxis();
        xAxis.setAnimated(false);
        xAxis.setForceZeroInRange(false);
        xAxis.setAutoRangeRounding(true);
        return xAxis;
    }

    private List<DataSet> createSeries() {
        ArrayList<DataSet> series = new ArrayList<DataSet>();
        for (int i = 0; i < 2; ++i) {
            series.add((DataSet)this.createData("Series " + i));
        }
        return series;
    }

    private DoubleDataSet createData(String name) {
        DoubleDataSet dataSet = new DoubleDataSet(name, 20);
        Random rnd = new Random();
        for (int i = 0; i < 20; ++i) {
            dataSet.set(i, (double)i, (double)(i * i) * rnd.nextDouble());
        }
        return dataSet;
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private XYChart createChart() {
        XYChart chart = new XYChart((Axis)new DefaultNumericAxis("X Values", ""), (Axis)new DefaultNumericAxis("y Values", ""));
        RandomWalkFunction dataset1 = new RandomWalkFunction("Test1", 10000);
        RandomWalkFunction dataset2 = new RandomWalkFunction("Test2", 10000);
        RandomStepFunction dataset3 = new RandomStepFunction("Test3", 10000);
        chart.getRenderers().clear();
        chart.getRenderers().add((Object)new ErrorDataSetRenderer());
        chart.getDatasets().addAll(Arrays.asList(dataset1, dataset2, dataset3));
        UpdateTask updateTask1 = new UpdateTask(chart, new TestDataSet[]{dataset1});
        UpdateTask updateTask2 = new UpdateTask(chart, new TestDataSet[]{dataset3});
        Timer timer = new Timer();
        timer.schedule((TimerTask)updateTask1, 2000L, 1000L);
        timer.schedule((TimerTask)updateTask2, 2000L, 1000L);
        return chart;
    }

    private class UpdateTask
    extends TimerTask {
        private final TestDataSet<?>[] dataSets;
        private final XYChart localChart;
        private int count;

        private UpdateTask(XYChart chart, TestDataSet<?> ... dataSet) {
            this.localChart = chart;
            this.dataSets = (TestDataSet[])dataSet.clone();
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            for (TestDataSet<?> dataSet : this.dataSets) {
                dataSet.update();
            }
            Platform.runLater(() -> {
                if (this.count % 10 == 0) {
                    long diff = System.currentTimeMillis() - start;
                    System.out.println(String.format("update #%d took %d ms", this.count, diff));
                }
                this.count = (this.count + 1) % 1000;
            });
        }
    }
}

