/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.misc.samples.plugins;

import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.math.TRandom;
import de.gsi.misc.samples.plugins.SnowFlake;
import java.util.ArrayList;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeType;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Snow
extends ChartPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(Snow.class);
    private static final TRandom RND = new TRandom(0L);
    private final Group circles = new Group();
    private final IntegerProperty numberOfFlakes = new SimpleIntegerProperty((Object)this, "numberOfFlakes", 100);
    private final DoubleProperty velocity = new SimpleDoubleProperty((Object)this, "velocity", 0.1);
    private final DoubleProperty meanSize = new SimpleDoubleProperty((Object)this, "meanSize", 10.0);
    private final DoubleProperty rmsSize = new SimpleDoubleProperty((Object)this, "rmsSize", 5.0);
    private final ObjectProperty<Color> snowColor = new SimpleObjectProperty((Object)this, "snowColor");
    private final BooleanProperty snow = new SimpleBooleanProperty((Object)this, "snow", true);
    private final ChangeListener changeListener = (ch, o, n) -> this.init();

    public Snow() {
        this(100, 10.0, 5.0, Color.web((String)"white", (double)0.7));
    }

    public Snow(int nSnowFlakes, double meanSnowFlakeSize, double rmsSnowFlakeSize, Color color) {
        this.numberOfFlakesProperty().set(nSnowFlakes);
        this.meanSizeProperty().set(meanSnowFlakeSize);
        this.rmsSizeProperty().set(rmsSnowFlakeSize);
        this.snowColorProperty().set((Object)color);
        this.init();
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)20.0), t -> {
            for (Node node : this.circles.getChildren()) {
                if (!(node instanceof PhysicalSnowFlake)) continue;
                PhysicalSnowFlake flake = (PhysicalSnowFlake)node;
                flake.animate();
            }
        }, new KeyValue[0])});
        timeline.setCycleCount(-1);
        timeline.play();
        this.chartProperty().addListener((ch, o, n) -> {
            if (o != null) {
                o.getCanvasForeground().getChildren().remove((Object)this.circles);
                o.getCanvas().widthProperty().removeListener(this.changeListener);
                o.getCanvas().heightProperty().removeListener(this.changeListener);
            }
            if (n != null) {
                n.getCanvasForeground().getChildren().add((Object)this.circles);
                n.getCanvas().widthProperty().addListener(this.changeListener);
                n.getCanvas().heightProperty().addListener(this.changeListener);
                this.init();
            }
        });
        this.snowProperty().addListener(this.changeListener);
        this.numberOfFlakesProperty().addListener(this.changeListener);
        this.meanSizeProperty().addListener(this.changeListener);
        this.rmsSizeProperty().addListener(this.changeListener);
        this.snowColorProperty().addListener(this.changeListener);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log("init Snow plugin");
        }
    }

    public DoubleProperty meanSizeProperty() {
        return this.meanSize;
    }

    public IntegerProperty numberOfFlakesProperty() {
        return this.numberOfFlakes;
    }

    public DoubleProperty rmsSizeProperty() {
        return this.rmsSize;
    }

    public ObjectProperty<Color> snowColorProperty() {
        return this.snowColor;
    }

    public BooleanProperty snowProperty() {
        return this.snow;
    }

    public DoubleProperty velocityProperty() {
        return this.velocity;
    }

    protected void init() {
        int n = this.numberOfFlakesProperty().get();
        ArrayList<PhysicalSnowFlake> list = new ArrayList<PhysicalSnowFlake>(n);
        if (this.snowProperty().get()) {
            for (int i = 0; i < n; ++i) {
                double radius = TRandom.Gaus((double)this.meanSizeProperty().get(), (double)this.rmsSizeProperty().get());
                PhysicalSnowFlake circle = new PhysicalSnowFlake(radius, (Paint)this.snowColorProperty().get());
                circle.setStrokeType(StrokeType.OUTSIDE);
                circle.setStroke((Paint)Color.web((String)"black", (double)0.16));
                circle.init();
                list.add(circle);
            }
        }
        this.circles.getChildren().setAll(list);
    }

    protected class PhysicalSnowFlake
    extends SnowFlake {
        private final double size;
        private double x;
        private double y;

        public PhysicalSnowFlake(double radius, Paint fill) {
            this(0.0, 0.0, radius, 2, fill);
        }

        protected PhysicalSnowFlake(double centerX, double centerY, double radius, int recursion, Paint fill) {
            super(centerX, centerY, radius, recursion, fill);
            this.size = radius;
            this.init();
        }

        public void animate() {
            if (Snow.this.getChart() == null) {
                return;
            }
            double yMax = Snow.this.getChart().getCanvas().getHeight();
            double yp = Snow.this.velocity.get() * Math.sqrt(Math.abs(this.size));
            double xp = (Math.random() - 0.5) * yp;
            this.x += xp;
            this.y += yp;
            if (this.y > yMax) {
                this.init();
                this.y = -this.size;
            }
            this.setTranslateX(this.x);
            this.setTranslateY(this.y);
        }

        protected void init() {
            if (Snow.this.getChart() == null) {
                return;
            }
            double xMax = Snow.this.getChart().getCanvas().getWidth();
            double yMax = Snow.this.getChart().getCanvas().getHeight();
            this.x = Math.random() * xMax;
            this.y = Math.random() * yMax;
            this.setTranslateX(this.x - this.size / 2.0);
            this.setTranslateY(this.y - this.size / 2.0);
        }
    }
}

