/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.misc.samples;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.ui.HiddenSidesPane;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.math.MathBaseFast;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class LimitsSample
extends Application {
    private static final int N_SAMPLES = 100;
    private static final int WIDTH = 1200;
    private static final int HEIGHT = 600;

    public void start(Stage primaryStage) {
        DefaultNumericAxis xAxis = new DefaultNumericAxis("time", "s");
        DefaultNumericAxis yAxis = new DefaultNumericAxis("y-value", "a.u.");
        XYChart chart = new XYChart(new Axis[]{xAxis, yAxis});
        HiddenSidesPane hiddenSidePane = chart.getPlotArea();
        hiddenSidePane.setTriggerDistance(0.0);
        chart.getPlugins().add((Object)new Zoomer());
        chart.getPlugins().add((Object)new EditAxis());
        ErrorDataSetRenderer rendererValue = (ErrorDataSetRenderer)chart.getRenderers().get(0);
        rendererValue.setDrawMarker(true);
        ErrorDataSetRenderer rendererLimits = new ErrorDataSetRenderer();
        rendererLimits.setErrorType(ErrorStyle.ERRORSURFACE);
        rendererLimits.setDrawMarker(false);
        chart.getRenderers().add((Object)rendererLimits);
        DoubleErrorDataSet upperLimit = new DoubleErrorDataSet("upper limit");
        upperLimit.setStyle("showInLegend=false; strokeColor=darkgreen");
        DoubleErrorDataSet lowerLimit = new DoubleErrorDataSet("lower limit");
        lowerLimit.setStyle("showInLegend=false; strokeColor=darkred");
        DoubleErrorDataSet dataSet = new DoubleErrorDataSet("some dataset");
        dataSet.setStyle("markerSize=3; markerColor=violet; markerType=diamond");
        rendererValue.getDatasets().add((Object)dataSet);
        rendererLimits.getDatasets().addAll((Object[])new DataSet[]{upperLimit, lowerLimit});
        for (int i = 0; i < 100; ++i) {
            double time = (double)i * 0.01;
            double value = MathBaseFast.sin((double)(Math.PI * 2 * time));
            double confidenceInterval = 0.2 * MathBaseFast.cos((double)(Math.PI * 2 * time));
            dataSet.add(time, value, confidenceInterval, confidenceInterval);
            upperLimit.add(time, value + 2.0, 0.0, Double.POSITIVE_INFINITY);
            lowerLimit.add(time, value - 2.0, Double.POSITIVE_INFINITY, 0.0);
        }
        Scene scene = new Scene((Parent)chart, 1200.0, 600.0);
        primaryStage.setTitle(LimitsSample.class.getSimpleName());
        primaryStage.setOnCloseRequest(evt -> Platform.exit());
        primaryStage.setScene(scene);
        primaryStage.show();
    }
}

