/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples;

import de.gsi.chart.renderer.spi.LabelledMarkerRenderer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.Formatter;
import de.gsi.dataset.spi.DoubleDataSet;
import de.gsi.dataset.testdata.spi.GaussFunction;
import de.gsi.math.DataSetMath;
import de.gsi.math.samples.EMDSample;
import de.gsi.math.samples.utils.AbstractDemoApplication;
import de.gsi.math.samples.utils.DemoChart;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeakWidthSample
extends AbstractDemoApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeakWidthSample.class);
    private static final String FILE_NAME = "./LongSchottkySIS18.dat";
    private static final String MEAS_STROKE_COLOUR = "strokeColor=lightGray";
    private static final String FONT_SIZE = "fontSize=20;";
    private static final char SIGMA_CHAR = '\u03c3';
    private static final int N_SAMPLES = 3000;
    private static final double A1 = 1.05;
    private static final double SIGMA1 = 0.65;
    private static final double A2 = 1.8;
    private static final double SIGMA2 = 0.18;
    private static final double MAX_INT_WIDTH = 3.0;
    private final DemoChart chart1 = new DemoChart();
    private final DemoChart chart2 = new DemoChart();

    @Override
    public Node getContent() {
        List<DataSet> rawData = this.readDemoData();
        List<DataSet> linearData = rawData.stream().map(x$0 -> DataSetMath.inversedbFunction((DataSet)x$0, (Formatter[])new Formatter[0])).collect(Collectors.toList());
        linearData.forEach(ds -> ds.setStyle(MEAS_STROKE_COLOUR));
        DoubleDataSet average = new DoubleDataSet("average", 3000);
        DoubleDataSet gauss1 = new DoubleDataSet("gauss1", 3000);
        DoubleDataSet gauss2 = new DoubleDataSet("gauss2", 3000);
        gauss1.setStyle("strokeColor=darkred");
        gauss2.setStyle("strokeColor=darkgreen");
        for (int i = 0; i < 3000; ++i) {
            double x = -3.0 + (double)i / 3000.0 * 6.0;
            double y = 0.0;
            for (DataSet ds2 : linearData) {
                y += ds2.getValue(1, new double[]{x}) / (double)linearData.size();
            }
            average.add(x, y);
            gauss1.add(x, 1.05 * GaussFunction.gauss((double)x, (double)0.0, (double)0.65) * 0.65);
            gauss2.add(x, 1.8 * GaussFunction.gauss((double)x, (double)0.0, (double)0.18) * 0.18);
        }
        double dataOffset = average.getAxisDescription(1).getMin();
        DataSet avgOffsetCompensated = DataSetMath.subtractFunction((DataSet)average, (double)dataOffset, (Formatter[])new Formatter[0]);
        avgOffsetCompensated.setStyle("strokeColor=black");
        List linDataOffsetCompensated = linearData.stream().map(ds -> DataSetMath.subtractFunction((DataSet)ds, (double)dataOffset, (Formatter[])new Formatter[0]).setStyle(MEAS_STROKE_COLOUR)).collect(Collectors.toList());
        this.chart1.getDatasets().addAll((Object[])new DataSet[]{avgOffsetCompensated, gauss1, gauss2});
        this.chart1.getDatasets().addAll(linDataOffsetCompensated);
        this.chart1.getXAxis().setName("dp/p");
        this.chart1.getXAxis().setUnit("1e-3");
        this.chart1.getYAxis().setName("amplitude");
        this.chart1.getYAxis().setUnit("a.u.");
        this.chart1.setLegendVisible(false);
        this.chart2.getXAxis().setName("dp/p [fs]");
        this.chart2.getXAxis().setUnit("1e-3");
        this.chart2.getYAxis().setName("norm. integral");
        this.chart2.getYAxis().setUnit(null);
        this.chart2.setLegendVisible(false);
        BiFunction<DataSet, Double, DataSet> integralWidth = (ds, offset) -> DataSetMath.integrateFromCentre((DataSet)DataSetMath.subtractFunction((DataSet)ds, (double)offset, (Formatter[])new Formatter[0]), (double)Double.NaN, (double)3.0, (boolean)true, (Formatter[])new Formatter[0]);
        List intData = linearData.stream().map(ds -> (DataSet)integralWidth.apply((DataSet)ds, dataOffset)).map(ds -> ds.setStyle(MEAS_STROKE_COLOUR)).collect(Collectors.toList());
        DataSet intAverage = DataSetMath.integrateFromCentre((DataSet)avgOffsetCompensated, (double)Double.NaN, (double)3.0, (boolean)true, (Formatter[])new Formatter[0]);
        DataSet intGauss1 = DataSetMath.integrateFromCentre((DataSet)gauss1, (double)Double.NaN, (double)3.0, (boolean)true, (Formatter[])new Formatter[0]);
        DataSet intGauss2 = DataSetMath.integrateFromCentre((DataSet)gauss2, (double)Double.NaN, (double)3.0, (boolean)true, (Formatter[])new Formatter[0]);
        intGauss1.setStyle("strokeColor=darkred");
        intGauss2.setStyle("strokeColor=darkgreen");
        this.chart2.getDatasets().addAll((Object[])new DataSet[]{intAverage, intGauss1, intGauss2});
        this.chart2.getDatasets().addAll(intData);
        LabelledMarkerRenderer labelRenderer = new LabelledMarkerRenderer();
        DoubleDataSet marker1 = new DoubleDataSet("marker1");
        marker1.setStyle("strokeColor=darkRed; fillColor=darkRed;fontSize=20;");
        for (int i = 1; i < 3; ++i) {
            marker1.add((double)i * 0.65, 1.0, i + "\u03c3");
        }
        DoubleDataSet marker1b = new DoubleDataSet("marker1b");
        marker1b.setStyle("strokeColor=red; fillColor=red;fontSize=20;");
        double sigma1 = DataSetMath.integralWidth((DataSet)gauss1, (double)Double.NaN, (double)3.0, (double)0.683);
        double sigma2 = DataSetMath.integralWidth((DataSet)gauss1, (double)Double.NaN, (double)3.0, (double)0.955);
        marker1b.add(sigma1, 1.0, " ");
        marker1b.add(sigma2, 1.0, " ");
        LOGGER.atInfo().addArgument((Object)0.65).addArgument((Object)sigma1).log("sigma {} (def) vs {} (meas)");
        LOGGER.atInfo().addArgument((Object)1.3).addArgument((Object)sigma2).log("sigma {} (def) vs {} (meas)");
        DoubleDataSet marker2 = new DoubleDataSet("marker2");
        marker2.setStyle("strokeColor=darkBlue; fillColor=darkBlue;fontSize=20;");
        marker2.add(DataSetMath.integralWidth((DataSet)avgOffsetCompensated, (double)Double.NaN, (double)3.0, (double)0.683), 1.0, "1\u03c3");
        marker2.add(DataSetMath.integralWidth((DataSet)avgOffsetCompensated, (double)Double.NaN, (double)3.0, (double)0.955), 1.0, "2\u03c3");
        labelRenderer.getDatasets().addAll((Object[])new DataSet[]{marker1, marker1b, marker2});
        this.chart2.getRenderers().add((Object)labelRenderer);
        return new VBox(new Node[]{this.chart1, this.chart2});
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private List<DataSet> readDemoData() {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(EMDSample.class.getResourceAsStream(FILE_NAME)));){
            String line = reader.readLine();
            assert (line != null);
            while ((line = reader.readLine()) != null) {
                String header = StringUtils.split((String)line, (String)" ")[1];
                int harmonic = Integer.parseInt(StringUtils.split((String)header, (String)"#")[1]);
                String xValues = reader.readLine();
                String[] x = StringUtils.split((String)xValues, (String)",");
                String yValues = reader.readLine();
                String[] y = StringUtils.split((String)yValues, (String)",");
                assert (x.length == y.length);
                DoubleDataSet dataSet = new DoubleDataSet("h=" + harmonic, x.length - 1);
                for (int i = 1; i < x.length; ++i) {
                    dataSet.add(Double.parseDouble(x[i]), Double.parseDouble(y[i]));
                }
                dataSet.recomputeLimits(1);
                if (harmonic <= 100 || !(dataSet.getAxisDescription(1).getMax() < 5.0) || harmonic == 159 || harmonic == 154) continue;
                dataSet.setStyle(MEAS_STROKE_COLOUR);
                dataSets.add((DataSet)dataSet);
            }
        }
        catch (Exception e) {
            LOGGER.atError().setCause((Throwable)e).log("read data error");
        }
        return dataSets;
    }
}

