/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.Formatter;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.math.DataSetMath;
import de.gsi.math.filter.iir.Bessel;
import de.gsi.math.filter.iir.Butterworth;
import de.gsi.math.filter.iir.ChebyshevI;
import de.gsi.math.filter.iir.ChebyshevII;
import de.gsi.math.samples.utils.AbstractDemoApplication;
import de.gsi.math.samples.utils.DemoChart;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.layout.FlowPane;

public class IIRFrequencyFilterSample
extends AbstractDemoApplication {
    private static final String LOW_PASS = "Low-Pass";
    private static final String BAND_STOP = "Band-Stop";
    private static final String BAND_PASS = "Band-Pass";
    private static final String HIGH_PASS = "High-Pass";
    private static final int N_SAMPLES = 32768;
    private static final int N_SAMPLE_RATE = 1000;
    private static final int ORDER = 6;
    private static final double F_CUT_LOW = 0.2;
    private static final double F_CUT_HIGH = 0.3;
    private static final double ALLOWED_IN_BAND_RIPPLE_DB = 3.0;
    private static final double ALLOWED_OUT_OF_BAND_RIPPLE_DB = 20.0;
    private final DataSet2D demoDataSet = IIRFrequencyFilterSample.generateDemoDataSet();

    public IIRFrequencyFilterSample() {
        super(1600.0, 800.0);
    }

    @Override
    public Node getContent() {
        FlowPane flowPane = new FlowPane();
        flowPane.getChildren().add((Object)this.getDemoChartButterworth());
        flowPane.getChildren().add((Object)this.getDemoChartBessel());
        flowPane.getChildren().add((Object)this.getDemoChartChebychevI());
        flowPane.getChildren().add((Object)this.getDemoChartChebychevII());
        return flowPane;
    }

    private DemoChart getDemoChart(String title) {
        DemoChart defaultChart = new DemoChart();
        defaultChart.setTitle(title);
        defaultChart.getXAxis().setName("frequency");
        defaultChart.getYAxis().setName("magnitude");
        defaultChart.getYAxis().setUnit("dB");
        defaultChart.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)this.demoDataSet, (Formatter[])new Formatter[0])});
        defaultChart.getYAxis().setAutoRanging(false);
        defaultChart.getYAxis().setMin(-35.0);
        defaultChart.getYAxis().setMax(5.0);
        defaultChart.setPrefSize(800.0, 400.0);
        return defaultChart;
    }

    private DemoChart getDemoChartBessel() {
        String filterType = "Bessel - (6th-order)";
        DefaultDataSet lowPass = new DefaultDataSet(LOW_PASS);
        DefaultDataSet highPass = new DefaultDataSet(HIGH_PASS);
        DefaultDataSet bandPass = new DefaultDataSet(BAND_PASS);
        DefaultDataSet bandStop = new DefaultDataSet(BAND_STOP);
        Bessel iirLowPass = new Bessel();
        iirLowPass.lowPass(6, 1.0, 0.3);
        Bessel iirHighPass = new Bessel();
        iirHighPass.highPass(6, 1.0, 0.2);
        Bessel iirBandPass = new Bessel();
        iirBandPass.bandPass(6, 1.0, 0.25, 0.09999999999999998);
        Bessel iirBandStop = new Bessel();
        iirBandStop.bandStop(6, 1.0, 0.25, 0.09999999999999998);
        for (int i = 0; i < this.demoDataSet.getDataCount(); ++i) {
            double x = this.demoDataSet.getX(i);
            double y = this.demoDataSet.getY(i);
            lowPass.add(x, iirLowPass.filter(y));
            highPass.add(x, iirHighPass.filter(y));
            bandPass.add(x, iirBandPass.filter(y));
            bandStop.add(x, iirBandStop.filter(y));
        }
        DemoChart chart = this.getDemoChart("Bessel - (6th-order)");
        chart.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)lowPass, (Formatter[])new Formatter[0]), DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)highPass, (Formatter[])new Formatter[0]), DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)bandPass, (Formatter[])new Formatter[0]), DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)bandStop, (Formatter[])new Formatter[0])});
        return chart;
    }

    private DemoChart getDemoChartButterworth() {
        String filterType = "Butterworth - (6th-order)";
        DefaultDataSet lowPass = new DefaultDataSet(LOW_PASS);
        DefaultDataSet highPass = new DefaultDataSet(HIGH_PASS);
        DefaultDataSet bandPass = new DefaultDataSet(BAND_PASS);
        DefaultDataSet bandStop = new DefaultDataSet(BAND_STOP);
        Butterworth iirLowPass = new Butterworth();
        iirLowPass.lowPass(6, 1.0, 0.3);
        Butterworth iirHighPass = new Butterworth();
        iirHighPass.highPass(6, 1.0, 0.2);
        Butterworth iirBandPass = new Butterworth();
        iirBandPass.bandPass(6, 1.0, 0.25, 0.09999999999999998);
        Butterworth iirBandStop = new Butterworth();
        iirBandStop.bandStop(6, 1.0, 0.25, 0.09999999999999998);
        for (int i = 0; i < this.demoDataSet.getDataCount(); ++i) {
            double x = this.demoDataSet.getX(i);
            double y = this.demoDataSet.getY(i);
            lowPass.add(x, iirLowPass.filter(y));
            highPass.add(x, iirHighPass.filter(y));
            bandPass.add(x, iirBandPass.filter(y));
            bandStop.add(x, iirBandStop.filter(y));
        }
        DemoChart chart = this.getDemoChart("Butterworth - (6th-order)");
        chart.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)lowPass, (Formatter[])new Formatter[0]), DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)highPass, (Formatter[])new Formatter[0]), DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)bandPass, (Formatter[])new Formatter[0]), DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)bandStop, (Formatter[])new Formatter[0])});
        return chart;
    }

    private DemoChart getDemoChartChebychevI() {
        String filterType = "ChebyshevI - (6th-order, 3.0 dB ripple)";
        DefaultDataSet lowPass = new DefaultDataSet(LOW_PASS);
        DefaultDataSet highPass = new DefaultDataSet(HIGH_PASS);
        DefaultDataSet bandPass = new DefaultDataSet(BAND_PASS);
        DefaultDataSet bandStop = new DefaultDataSet(BAND_STOP);
        ChebyshevI iirLowPass = new ChebyshevI();
        iirLowPass.lowPass(6, 1.0, 0.3, 3.0);
        ChebyshevI iirHighPass = new ChebyshevI();
        iirHighPass.highPass(6, 1.0, 0.2, 3.0);
        ChebyshevI iirBandPass = new ChebyshevI();
        iirBandPass.bandPass(6, 1.0, 0.25, 0.09999999999999998, 3.0);
        ChebyshevI iirBandStop = new ChebyshevI();
        iirBandStop.bandStop(6, 1.0, 0.25, 0.09999999999999998, 3.0);
        for (int i = 0; i < this.demoDataSet.getDataCount(); ++i) {
            double x = this.demoDataSet.getX(i);
            double y = this.demoDataSet.getY(i);
            lowPass.add(x, iirLowPass.filter(y));
            highPass.add(x, iirHighPass.filter(y));
            bandPass.add(x, iirBandPass.filter(y));
            bandStop.add(x, iirBandStop.filter(y));
        }
        DemoChart chart = this.getDemoChart("ChebyshevI - (6th-order, 3.0 dB ripple)");
        chart.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)lowPass, (Formatter[])new Formatter[0]), DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)highPass, (Formatter[])new Formatter[0]), DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)bandPass, (Formatter[])new Formatter[0]), DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)bandStop, (Formatter[])new Formatter[0])});
        return chart;
    }

    private DemoChart getDemoChartChebychevII() {
        String filterType = "ChebyshevII - (6th-order, 20.0 dB ripple)";
        DefaultDataSet lowPass = new DefaultDataSet(LOW_PASS);
        DefaultDataSet highPass = new DefaultDataSet(HIGH_PASS);
        DefaultDataSet bandPass = new DefaultDataSet(BAND_PASS);
        DefaultDataSet bandStop = new DefaultDataSet(BAND_STOP);
        ChebyshevII iirLowPass = new ChebyshevII();
        iirLowPass.lowPass(6, 1.0, 0.3, 20.0);
        ChebyshevII iirHighPass = new ChebyshevII();
        iirHighPass.highPass(6, 1.0, 0.2, 20.0);
        ChebyshevII iirBandPass = new ChebyshevII();
        iirBandPass.bandPass(6, 1.0, 0.25, 0.09999999999999998, 20.0);
        ChebyshevII iirBandStop = new ChebyshevII();
        iirBandStop.bandStop(6, 1.0, 0.25, 0.09999999999999998, 20.0);
        for (int i = 0; i < this.demoDataSet.getDataCount(); ++i) {
            double x = this.demoDataSet.getX(i);
            double y = this.demoDataSet.getY(i);
            lowPass.add(x, iirLowPass.filter(y));
            highPass.add(x, iirHighPass.filter(y));
            bandPass.add(x, iirBandPass.filter(y));
            bandStop.add(x, iirBandStop.filter(y));
        }
        DemoChart chart = this.getDemoChart("ChebyshevII - (6th-order, 20.0 dB ripple)");
        chart.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)lowPass, (Formatter[])new Formatter[0]), DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)highPass, (Formatter[])new Formatter[0]), DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)bandPass, (Formatter[])new Formatter[0]), DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)bandStop, (Formatter[])new Formatter[0])});
        return chart;
    }

    private static DataSet2D generateDemoDataSet() {
        double[] xValues = new double[32768];
        double[] yValues = new double[32768];
        double fs = 1000.0;
        for (int i = 0; i < 32768; ++i) {
            xValues[i] = (double)i / fs;
        }
        yValues[16384] = 16384.0;
        return new DefaultDataSet("dirac", xValues, yValues, xValues.length, true);
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

