/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DefaultDataSet;
import de.gsi.dataset.spi.DefaultErrorDataSet;
import de.gsi.math.MathBase;
import de.gsi.math.fitter.NonLinearRegressionFitter;
import de.gsi.math.functions.AbstractFunction1D;
import de.gsi.math.functions.Function1D;
import de.gsi.math.samples.utils.AbstractDemoApplication;
import de.gsi.math.samples.utils.DemoChart;
import javafx.application.Application;
import javafx.scene.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaussianFitSample
extends AbstractDemoApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(GaussianFitSample.class);
    private static final int MAX_POINTS = 101;
    private DataSet fmodel;
    private DataSet fdataOrig;
    private DataSet fdataFitted;

    @Override
    public Node getContent() {
        this.initData();
        DemoChart chart = new DemoChart();
        chart.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{this.fmodel, this.fdataOrig, this.fdataFitted});
        return chart;
    }

    private void initData() {
        MyGaussianFunction func = new MyGaussianFunction("gauss1", new double[]{-3.0, 1.0, 10.0});
        LOGGER.atInfo().log("before fit");
        func.printParameters();
        double[] xValues = new double[101];
        double[] yValues = new double[101];
        double[] yModel = new double[101];
        double[] yErrors = new double[101];
        for (int i = 0; i < xValues.length; ++i) {
            double value;
            double error = 0.5 * RANDOM.nextGaussian();
            xValues[i] = ((double)i - (double)xValues.length / 2.0) * 30.0 / 101.0;
            yModel[i] = value = func.getValue(xValues[i]);
            yValues[i] = value + error;
            yErrors[i] = Math.abs(error);
        }
        NonLinearRegressionFitter fitter = new NonLinearRegressionFitter(xValues, yValues, yErrors);
        double[] start = new double[]{0.0, 1.0, 0.6};
        double[] step = new double[]{0.6, 0.05, 0.1};
        fitter.simplex((Function1D)func, start, step);
        double[] fittedParameter = fitter.getBestEstimates();
        double[] fittedParameterError = fitter.getBestEstimatesErrors();
        func.setParameterValues(fittedParameter);
        for (int i = 0; i < func.getParameterCount(); ++i) {
            double value = fittedParameter[i];
            double error = fittedParameterError[i];
            func.setParameterRange(i, value - error, value + error);
        }
        double[] yPredicted = func.getValues(xValues);
        double[] yPredictedError = new double[yPredicted.length];
        LOGGER.atInfo().log("after fit");
        func.printParameters();
        LOGGER.atInfo().log("fit results chi^2 =" + fitter.getChiSquare() + ":");
        for (int i = 0; i < 3; ++i) {
            LOGGER.atInfo().addArgument((Object)func.getParameterName(i)).addArgument((Object)start[i]).addArgument((Object)fittedParameter[i]).addArgument((Object)fittedParameterError[i]).log("fitted-parameter  '{}' = {} -> {} +- {}");
        }
        this.fmodel = new DefaultDataSet("design model", xValues, yModel, xValues.length, true);
        this.fdataOrig = new DefaultErrorDataSet("data seed with errors", xValues, yValues, yErrors, yErrors, xValues.length, true);
        this.fdataFitted = new DefaultErrorDataSet("fitted model", xValues, yPredicted, yPredictedError, yPredictedError, xValues.length, true);
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    protected static class MyGaussianFunction
    extends AbstractFunction1D {
        public MyGaussianFunction(String name, double[] parameter) {
            super(name, new double[3]);
            this.setParameterName(0, "mu");
            this.setParameterName(1, "sigma");
            this.setParameterName(2, "scale");
            if (parameter == null) {
                this.setParameterValue(0, 0.0);
                this.setParameterValue(0, 1.0);
                this.setParameterValue(0, 1.0);
                return;
            }
            int maxIndex = MathBase.min((int)parameter.length, (int)this.getParameterCount());
            for (int i = 0; i < maxIndex; ++i) {
                this.setParameterValue(i, parameter[i]);
            }
        }

        public double getValue(double x) {
            double mu = this.fparameter[0];
            double sigma = this.fparameter[1];
            double scale = this.fparameter[2];
            return scale / (Math.sqrt(Math.PI * 2) * sigma) * Math.exp(-0.5 * Math.pow((x - mu) / sigma, 2.0));
        }
    }
}

