/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples;

import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.Formatter;
import de.gsi.math.DataSetMath;
import de.gsi.math.functions.TrigCosineFunction;
import de.gsi.math.functions.TrigSineFunction;
import de.gsi.math.samples.utils.AbstractDemoApplication;
import de.gsi.math.samples.utils.DemoChart;
import de.gsi.math.spectra.Apodization;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.layout.VBox;

public class DataSetSpectrumSample
extends AbstractDemoApplication {
    private static final int N_SAMPLES = 200;
    private static boolean unequalSampling;

    @Override
    public Node getContent() {
        DemoChart chart = new DemoChart();
        chart.getRenderer(0).setDrawMarker(false);
        chart.getRenderer(0).setErrorType(ErrorStyle.ERRORSURFACE);
        TrigSineFunction sineFunction = new TrigSineFunction("sine"){

            public double getValue(double x) {
                return super.getValue(x) + 0.001 * RANDOM.nextGaussian();
            }
        };
        sineFunction.setParameterValue(1, 1.0);
        TrigCosineFunction cosineFunction = new TrigCosineFunction("cos");
        cosineFunction.setParameterValue(1, 3.0);
        DataSet dataSet1 = sineFunction.getDataSetEstimate(-10.0, 10.0, 200);
        DataSet dataSet2 = unequalSampling ? cosineFunction.getDataSetEstimate(-8.0, 8.0, 200) : cosineFunction.getDataSetEstimate(-10.0, 10.0, 200);
        DataSet dataSet = DataSetMath.addFunction((DataSet)dataSet1, (DataSet)dataSet2, (Formatter[])new Formatter[0]);
        chart.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{dataSet1, dataSet2, dataSet});
        boolean normaliseFrequency = false;
        boolean dbScale = false;
        DemoChart chart2 = new DemoChart(2);
        chart2.getRenderer(0).setDrawMarker(true);
        chart2.getRenderer(0).setErrorType(ErrorStyle.ERRORSURFACE);
        chart2.getXAxis().setName("frequency");
        chart2.getXAxis().setUnit("Hz");
        chart2.getYAxis().setName("magnitude");
        chart2.getYAxis().setUnit("a.u.");
        chart2.getYAxis(1).setName("magnitude");
        chart2.getYAxis(1).setUnit("dB");
        chart2.getYAxis().setLogAxis(true);
        chart2.getYAxis().setLogarithmBase(10.0);
        DataSet magnitudeSpectrum = DataSetMath.magnitudeSpectrum((DataSet)dataSet, (Apodization)Apodization.Hann, (boolean)false, (boolean)false, (Formatter[])new Formatter[0]);
        magnitudeSpectrum.setStyle("strokeColor=red;fillColor=red;strokeWidth=1");
        chart2.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{magnitudeSpectrum});
        DataSet magnitudeSpectrumDecibel = DataSetMath.dbFunction((DataSet)magnitudeSpectrum, (Formatter[])new Formatter[0]);
        magnitudeSpectrumDecibel.setStyle("strokeColor=darkgreen;fillColor=darkgreen;strokeWidth=1");
        chart2.getRenderer(1).getDatasets().addAll((Object[])new DataSet[]{magnitudeSpectrumDecibel});
        DataSet control = DataSetMath.magnitudeSpectrumDecibel((DataSet)dataSet);
        control.setStyle("strokeColor=cyan;fillColor=cyan;strokeWidth=1");
        chart2.getRenderer(1).getDatasets().addAll((Object[])new DataSet[]{control});
        return new VBox(new Node[]{chart, chart2});
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

