/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples;

import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.Formatter;
import de.gsi.math.DataSetMath;
import de.gsi.math.functions.GaussianFunction;
import de.gsi.math.samples.utils.AbstractDemoApplication;
import de.gsi.math.samples.utils.DemoChart;
import javafx.application.Application;
import javafx.scene.Node;

public class DataSetFilterSample
extends AbstractDemoApplication {
    private static final int N_SAMPLES = 1000;
    private static final double FILTER_BW = 0.2;

    @Override
    public Node getContent() {
        DemoChart chart = new DemoChart();
        chart.getRenderer(0).setDrawMarker(false);
        chart.getRenderer(0).setErrorType(ErrorStyle.ERRORSURFACE);
        GaussianFunction gaussFunction = new GaussianFunction("gauss"){

            public double getValue(double x) {
                double spike = RANDOM.nextDouble() > 0.98 ? 1.0 : 0.0;
                return spike == 0.0 ? super.getValue(x) + 0.01 * RANDOM.nextGaussian() : spike;
            }
        };
        gaussFunction.setParameterValue(0, 0.0);
        gaussFunction.setParameterValue(1, 0.8);
        gaussFunction.setParameterValue(2, 1.0);
        DataSet dataSet = gaussFunction.getDataSetEstimate(-10.0, 10.0, 1000);
        dataSet.setStyle("strokeColor=darkblue;fillColor=darkblue;strokeWidth=1.0");
        chart.getRenderer(0).getDatasets().add((Object)dataSet);
        DataSet lowPassFiltered = DataSetMath.lowPassFilterFunction((DataSet)dataSet, (double)0.2, (Formatter[])new Formatter[0]);
        lowPassFiltered.setStyle("strokeColor=red;fillColor=red;strokeWidth=2");
        chart.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{lowPassFiltered});
        DataSet medianFiltered = DataSetMath.medianFilteredFunction((DataSet)dataSet, (double)0.2, (Formatter[])new Formatter[0]);
        medianFiltered.setStyle("strokeColor=green;fillColor=green;strokeWidth=2");
        chart.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{medianFiltered});
        DataSet control = DataSetMath.lowPassFilterFunction((DataSet)medianFiltered, (double)0.2, (Formatter[])new Formatter[0]);
        control.setStyle("strokeColor=cyan;fillColor=cyan;strokeWidth=8");
        chart.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{control});
        DataSet lowPassFiltered2 = DataSetMath.iirLowPassFilterFunction((DataSet)medianFiltered, (double)0.2, (Formatter[])new Formatter[0]);
        lowPassFiltered2.setStyle("strokeColor=orange;fillColor=red;strokeWidth=2");
        chart.getRenderer(0).getDatasets().addAll((Object[])new DataSet[]{lowPassFiltered2});
        return chart;
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

