/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.samples;

import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.LineStyle;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.Formatter;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.utils.LimitedQueue;
import de.gsi.math.DataSetMath;
import de.gsi.math.functions.SigmoidFunction;
import de.gsi.math.samples.utils.AbstractDemoApplication;
import de.gsi.math.samples.utils.DemoChart;
import java.util.Collection;
import java.util.List;
import javafx.application.Application;
import javafx.beans.property.Property;
import javafx.scene.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetAverageSample
extends AbstractDemoApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetAverageSample.class);
    private static final int N_GRAPHS = 20;
    private static final int N_SAMPLES = 100;
    private DataSet oldAverageDataSet;
    private final DataSet oldAverageDataSet2 = new DoubleErrorDataSet("var2");

    @Override
    public Node getContent() {
        DemoChart chart = new DemoChart(2);
        chart.getRenderer(0).setPolyLineStyle(LineStyle.NONE);
        chart.getRenderer(0).setErrorType(ErrorStyle.NONE);
        chart.getRenderer(1).setErrorType(ErrorStyle.ERRORSURFACE);
        chart.getYAxis(1).setAutoRanging(false);
        chart.getYAxis().maxProperty().bindBidirectional((Property)chart.getYAxis(1).maxProperty());
        chart.getYAxis().minProperty().bindBidirectional((Property)chart.getYAxis(1).minProperty());
        chart.getYAxis().tickUnitProperty().bindBidirectional((Property)chart.getYAxis(1).tickUnitProperty());
        LimitedQueue lastDataSets = new LimitedQueue(20);
        for (int i = 0; i < 400; ++i) {
            SigmoidFunction sigmoidFunction = new SigmoidFunction("sigmoid"){

                public double getValue(double x) {
                    return 10.0 + super.getValue(x) + 0.05 * RANDOM.nextGaussian();
                }
            };
            DataSet dataSet = sigmoidFunction.getDataSetEstimate(-10.0, 10.0, 100);
            dataSet.setStyle("strokeColor=darkblue;fillColor=darkblue;strokeWidth=0.5");
            lastDataSets.add((Object)dataSet);
            this.oldAverageDataSet = DataSetMath.averageDataSetsIIR((DataSet)this.oldAverageDataSet, (DataSet)this.oldAverageDataSet2, (DataSet)dataSet, (int)20, (Formatter[])new Formatter[0]);
        }
        chart.getRenderer(0).getDatasets().setAll((Collection)lastDataSets);
        DataSet filteredFIR = DataSetMath.averageDataSetsFIR((List)lastDataSets, (int)20, (Formatter[])new Formatter[0]);
        filteredFIR.setStyle("strokeColor=red;fillColor=red;strokeWidth=1");
        this.oldAverageDataSet.setStyle("strokeColor=darkOrange;fillColor=darkOrange;strokeWidth=2");
        chart.getRenderer(1).getDatasets().addAll((Object[])new DataSet[]{filteredFIR, this.oldAverageDataSet});
        LOGGER.atInfo().log("value at zero = " + filteredFIR.get(1, 0));
        return chart;
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

