/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service.footprint;

import de.gsi.chart.renderer.spi.financial.FootprintRenderer;
import de.gsi.chart.renderer.spi.financial.service.footprint.FootprintRendererAttributes;
import de.gsi.chart.renderer.spi.financial.service.footprint.NbColumnColorGroup;
import de.gsi.dataset.spi.financial.api.ohlcv.IOhlcvItem;
import de.gsi.financial.samples.dos.OHLCVItem;
import de.gsi.financial.samples.service.footprint.NbColumnColorGroupService;
import java.util.Collection;

public class FootprintRenderedAPIAdapter
implements FootprintRenderer.IFootprintRenderedAPI {
    private final FootprintRendererAttributes footprintAttrs;
    private final NbColumnColorGroupService nbColumnColorGroupService;

    public FootprintRenderedAPIAdapter(FootprintRendererAttributes footprintAttrs, NbColumnColorGroupService nbColumnColorGroupService) {
        this.footprintAttrs = footprintAttrs;
        this.nbColumnColorGroupService = nbColumnColorGroupService;
    }

    public FootprintRendererAttributes getFootprintAttributes() {
        return this.footprintAttrs;
    }

    public boolean isFootprintAvailable(IOhlcvItem ohlcvItem) {
        return ((OHLCVItem)ohlcvItem).getExtended() != null;
    }

    public Collection<Double[]> getPriceVolumeList(IOhlcvItem ohlcvItem) {
        return ((OHLCVItem)ohlcvItem).getExtended().getPriceVolumeContainer().getCompletedPriceVolume();
    }

    public double getPocPrice(IOhlcvItem ohlcvItem) {
        return ((OHLCVItem)ohlcvItem).getExtended().getPriceVolumeContainer().getPocPrice();
    }

    public IOhlcvItem getPullbackColumn(IOhlcvItem ohlcvItem) {
        return ((OHLCVItem)ohlcvItem).getExtended().getPullbackOhlcvItem();
    }

    public Object getLock(IOhlcvItem ohlcvItem) {
        return ((OHLCVItem)ohlcvItem).getExtended().lock;
    }

    public NbColumnColorGroup getColumnColorGroup(IOhlcvItem ohlcvItem) {
        return this.nbColumnColorGroupService.calculate(((OHLCVItem)ohlcvItem).getExtended().getPriceVolumeContainer());
    }
}

