/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service.footprint;

import de.gsi.chart.renderer.spi.financial.service.footprint.FootprintRendererAttributes;
import de.gsi.chart.renderer.spi.financial.service.footprint.NbColumnColorGroup;
import de.gsi.financial.samples.dos.PriceVolumeContainer;
import de.gsi.financial.samples.service.footprint.NbColumnColorGroupService;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public class DiagonalDominantNbColumnColorGroupService
implements NbColumnColorGroupService {
    private final boolean columnColoringFeatureActive;
    private final Color[][] columnColorGroupSettings;
    private final Double[] columnColorGroupThresholds;
    private final Font[] bidAskVolumeFonts;
    private final Double bidAskBoldThreshold;

    public DiagonalDominantNbColumnColorGroupService(FootprintRendererAttributes footprintAttrs) {
        this.columnColoringFeatureActive = (Boolean)footprintAttrs.getAttribute(FootprintRendererAttributes.COLUMN_COLORING_FEATURE_ACTIVE);
        this.columnColorGroupSettings = (Color[][])footprintAttrs.getAttribute(FootprintRendererAttributes.COLUMN_COLOR_GROUP_SETTINGS);
        this.columnColorGroupThresholds = (Double[])footprintAttrs.getAttribute(FootprintRendererAttributes.COLUMN_COLOR_GROUP_THRESHOLDS);
        this.bidAskBoldThreshold = (Double)footprintAttrs.getAttribute(FootprintRendererAttributes.BID_ASK_BOLD_THRESHOLD);
        this.bidAskVolumeFonts = (Font[])footprintAttrs.getAttribute(FootprintRendererAttributes.BID_ASK_VOLUME_FONTS);
    }

    @Override
    public NbColumnColorGroup calculate(PriceVolumeContainer priceVolumeContainer) {
        Color prevBidColor;
        if (!this.columnColoringFeatureActive) {
            return null;
        }
        NbColumnColorGroup result = new NbColumnColorGroup();
        Double[] prevPriceVolume = null;
        Color prevAskColor = null;
        Font bidVolumeFont = null;
        Font askVolumeFont = null;
        for (Double[] priceVolume : priceVolumeContainer.getCompletedPriceVolume()) {
            double bidVolume = priceVolume[1];
            double askVolume = priceVolume[2];
            if (prevPriceVolume != null) {
                double prevBidVolume = prevPriceVolume[1].doubleValue();
                double prevBidPercentage = prevBidVolume / askVolume * 100.0;
                double askPercentage = askVolume / prevBidVolume * 100.0;
                prevBidColor = this.getColumnColorGroup(prevBidPercentage, 0);
                Color askColor = this.getColumnColorGroup(askPercentage, 1);
                result.fontColorMap.put(prevPriceVolume[0], new NbColumnColorGroup.FontColor(bidVolumeFont, prevBidColor, askVolumeFont, prevAskColor));
                prevAskColor = askColor;
                bidVolumeFont = this.getFontForBidAskVolume(bidVolume);
                askVolumeFont = this.getFontForBidAskVolume(askVolume);
            } else {
                prevAskColor = this.columnColorGroupSettings[1][1];
                bidVolumeFont = this.getFontForBidAskVolume(bidVolume);
                askVolumeFont = this.getFontForBidAskVolume(askVolume);
            }
            prevPriceVolume = priceVolume;
        }
        prevBidColor = this.columnColorGroupSettings[0][1];
        if (prevPriceVolume != null) {
            result.fontColorMap.put(prevPriceVolume[0], new NbColumnColorGroup.FontColor(bidVolumeFont, prevBidColor, askVolumeFont, prevAskColor));
        }
        return result;
    }

    private Font getFontForBidAskVolume(double volume) {
        if (volume >= this.bidAskBoldThreshold) {
            return this.bidAskVolumeFonts[1];
        }
        return this.bidAskVolumeFonts[0];
    }

    private Color getColumnColorGroup(double percentage, int bidOrAsk) {
        if (percentage < this.columnColorGroupThresholds[0]) {
            return this.columnColorGroupSettings[bidOrAsk][0];
        }
        if (percentage >= this.columnColorGroupThresholds[0] && percentage < this.columnColorGroupThresholds[1]) {
            return this.columnColorGroupSettings[bidOrAsk][1];
        }
        if (percentage >= this.columnColorGroupThresholds[1] && percentage < this.columnColorGroupThresholds[2]) {
            return this.columnColorGroupSettings[bidOrAsk][2];
        }
        if (percentage >= this.columnColorGroupThresholds[2]) {
            return this.columnColorGroupSettings[bidOrAsk][3];
        }
        return null;
    }
}

