/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service.footprint;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.renderer.spi.financial.FootprintRenderer;
import de.gsi.chart.renderer.spi.financial.service.DataSetAware;
import de.gsi.chart.renderer.spi.financial.service.OhlcvRendererEpData;
import de.gsi.chart.renderer.spi.financial.service.RendererPaintAfterEP;
import de.gsi.chart.utils.StyleParser;
import de.gsi.dataset.DataSet;
import de.gsi.financial.samples.dos.Interval;
import de.gsi.financial.samples.dos.OHLCVItem;
import de.gsi.financial.samples.dos.OHLCVItemExtended;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class AbsorptionClusterRendererPaintAfterEP
implements RendererPaintAfterEP,
DataSetAware {
    public static final String DATASET_ABSORPTION_ASK_COLOR = "absorptionAskColor";
    public static final String DATASET_ABSORPTION_BID_COLOR = "absorptionAskColor";
    public static final String DATASET_ABSORPTION_ASK_TRANS_COLOR = "absorptionAskTransColor";
    public static final String DATASET_ABSORPTION_BID_TRANS_COLOR = "absorptionBidTransColor";
    protected final DataSet ds;
    protected final XYChart chart;
    protected final Axis xAxis;
    protected final Axis yAxis;
    private Color absorptionAskColor;
    private Color absorptionBidColor;
    private Color absorptionAskTransColor;
    private Color absorptionBidTransColor;
    private double xFrom;
    private double xTo;
    private double xDiff;

    public AbsorptionClusterRendererPaintAfterEP(DataSet ohlcvDataSet, XYChart chart) {
        this.ds = ohlcvDataSet;
        this.chart = chart;
        this.xAxis = chart.getXAxis();
        this.yAxis = chart.getYAxis();
    }

    public DataSet getDataSet() {
        return this.ds;
    }

    protected void initByDatasetFxStyle() {
        String style = this.ds.getStyle();
        this.absorptionAskColor = StyleParser.getColorPropertyValue((String)style, (String)"absorptionAskColor", (Color)Color.rgb((int)255, (int)128, (int)128));
        this.absorptionBidColor = StyleParser.getColorPropertyValue((String)style, (String)"absorptionAskColor", (Color)Color.GREEN);
        this.absorptionAskTransColor = StyleParser.getColorPropertyValue((String)style, (String)DATASET_ABSORPTION_ASK_TRANS_COLOR, (Color)Color.rgb((int)255, (int)128, (int)128, (double)0.2));
        this.absorptionBidTransColor = StyleParser.getColorPropertyValue((String)style, (String)DATASET_ABSORPTION_BID_TRANS_COLOR, (Color)Color.rgb((int)0, (int)255, (int)0, (double)0.2));
    }

    public void paintAfter(OhlcvRendererEpData d) {
        OHLCVItemExtended itemExtended;
        if (d.index == d.minIndex) {
            this.initByDatasetFxStyle();
        }
        if ((itemExtended = ((OHLCVItem)d.ohlcvItem).getExtended()) == null || itemExtended.getAbsorptionClusterDO() == null) {
            return;
        }
        double x0 = d.xCenter;
        FootprintRenderer.EpDataAddon dd = (FootprintRenderer.EpDataAddon)d.addon;
        d.gc.save();
        this.xFrom = x0 - dd.maxWidthTextBid - dd.fontGap - dd.basicGap;
        this.xTo = x0 + dd.maxWidthTextBid + dd.fontGap + dd.basicGap;
        this.xDiff = this.xTo - this.xFrom;
        d.gc.setLineWidth(2.5);
        d.gc.setStroke((Paint)this.absorptionAskColor);
        d.gc.setFill((Paint)this.absorptionAskTransColor);
        for (Interval<Double> bidCluster : itemExtended.getAbsorptionClusterDO().getBidClusters()) {
            this.paintCluster(d, dd, bidCluster);
        }
        d.gc.setStroke((Paint)this.absorptionBidColor);
        d.gc.setFill((Paint)this.absorptionBidTransColor);
        for (Interval<Double> askCluster : itemExtended.getAbsorptionClusterDO().getAskClusters()) {
            this.paintCluster(d, dd, askCluster);
        }
        d.gc.restore();
    }

    private void paintCluster(OhlcvRendererEpData d, FootprintRenderer.EpDataAddon dd, Interval<Double> bidCluster) {
        double bidFrom = this.yAxis.getDisplayPosition(((Double)bidCluster.from).doubleValue()) - dd.heightText / 2.0 - 3.0 * dd.basicGap;
        double bidTo = this.yAxis.getDisplayPosition(((Double)bidCluster.to).doubleValue()) + dd.heightText / 2.0 + 4.0 * dd.basicGap;
        d.gc.strokeLine(this.xFrom, bidFrom, this.xTo, bidFrom);
        d.gc.strokeLine(this.xFrom, bidTo, this.xTo, bidTo);
        d.gc.fillRect(this.xFrom, bidFrom, this.xDiff, bidTo - bidFrom);
    }
}

