/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service.execution;

import de.gsi.dataset.spi.financial.api.attrs.AttributeModel;
import de.gsi.financial.samples.dos.Order;
import de.gsi.financial.samples.dos.OrderContainer;
import de.gsi.financial.samples.dos.OrderExpression;
import de.gsi.financial.samples.dos.Position;
import de.gsi.financial.samples.dos.PositionContainer;
import de.gsi.financial.samples.service.StandardTradePlanAttributes;
import de.gsi.financial.samples.service.execution.ExecutionPlatform;
import de.gsi.financial.samples.service.execution.ExecutionResult;
import de.gsi.financial.samples.service.order.InternalOrderIdGenerator;
import java.util.Date;
import java.util.Set;

public class BasicOrderExecutionService {
    private final AttributeModel context;
    private OrderContainer orderContainer;
    private PositionContainer positionContainer;
    private String accountId;
    private final ExecutionPlatform executionPlatform;

    public BasicOrderExecutionService(AttributeModel context, ExecutionPlatform executionPlatform) {
        this.context = context;
        this.executionPlatform = executionPlatform;
        this.afterPropertiesSet();
    }

    private void afterPropertiesSet() {
        this.orderContainer = (OrderContainer)this.context.getRequiredAttribute(StandardTradePlanAttributes.ORDERS);
        this.positionContainer = (PositionContainer)this.context.getRequiredAttribute(StandardTradePlanAttributes.POSITIONS);
        this.accountId = (String)this.context.getAttribute(StandardTradePlanAttributes.ACCOUNT_ID, (Object)"account");
    }

    public Order createOrder(String name, Date entryTime, String asset, OrderExpression orderExpression) {
        Integer orderId = InternalOrderIdGenerator.generateId();
        return new Order(orderId, null, name, entryTime, asset, orderExpression, this.accountId);
    }

    public ExecutionResult performOrder(String name, Date entryTime, String asset, OrderExpression orderExpression) {
        return this.performOrder(this.createOrder(name, entryTime, asset, orderExpression));
    }

    public ExecutionResult performOrder(Date entryTime, String asset, OrderExpression orderExpression) {
        return this.performOrder(this.createOrder(null, entryTime, asset, orderExpression));
    }

    public ExecutionResult performOrder(Order order) {
        return this.executionPlatform.performOrder(order);
    }

    public ExecutionResult cancelOrder(int orderId) {
        return this.executionPlatform.cancelOrder(orderId);
    }

    public ExecutionResult cancelOrder(Order order) {
        return this.executionPlatform.cancelOrder(order);
    }

    public void flatPositions(String asset) {
        Set<Position> openedPositions = this.positionContainer.getFastOpenedPositionByMarketSymbol(asset);
        for (Position position : openedPositions) {
            if (position.getPositionType() == 1) {
                this.performOrder(position.getEntryTime(), position.getSymbol(), OrderExpression.sellMarket(position.getPositionQuantity()));
                continue;
            }
            this.performOrder(position.getEntryTime(), position.getSymbol(), OrderExpression.buyMarket(position.getPositionQuantity()));
        }
    }
}

