/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service.execution;

import de.gsi.dataset.spi.financial.api.attrs.AttributeModel;
import de.gsi.financial.samples.dos.Order;
import de.gsi.financial.samples.dos.OrderContainer;
import de.gsi.financial.samples.dos.PositionContainer;
import de.gsi.financial.samples.service.StandardTradePlanAttributes;
import de.gsi.financial.samples.service.execution.ExecutionPlatform;
import de.gsi.financial.samples.service.execution.ExecutionPlatformListener;
import de.gsi.financial.samples.service.execution.ExecutionResult;
import de.gsi.financial.samples.service.execution.OrderEvent;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractExecutionPlatform
implements ExecutionPlatform {
    protected AttributeModel context;
    protected OrderContainer orders = null;
    protected PositionContainer positions = null;
    private final Set<ExecutionPlatformListener> listeners = new LinkedHashSet<ExecutionPlatformListener>();

    public void setContext(AttributeModel context) {
        this.context = context;
    }

    @Override
    public void addExecutionPlatformListener(ExecutionPlatformListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeExecutionPlatformListener(ExecutionPlatformListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireOrderFilled(Order order) {
        OrderEvent event = new OrderEvent(this, order);
        for (ExecutionPlatformListener listener : this.listeners) {
            listener.orderFilled(event);
        }
    }

    protected void fireOrderCancelled(Order order) {
        OrderEvent event = new OrderEvent(this, order);
        for (ExecutionPlatformListener listener : this.listeners) {
            listener.orderCancelled(event);
        }
    }

    @Override
    public ExecutionResult performOrder(Order order) {
        ExecutionResult result = this.setRequiredOrderAttributes(order);
        if (ExecutionResult.ExecutionResultEnum.ERROR.equals((Object)result.getResult())) {
            return result;
        }
        this.storeOrder(order);
        return this.processOrder(order);
    }

    @Override
    public ExecutionResult cancelOrder(int orderId) {
        Order order = this.orders.getOrderById(orderId);
        if (order == null) {
            ExecutionResult result = new ExecutionResult(order);
            result.setResult(ExecutionResult.ExecutionResultEnum.ERROR);
            result.setErrorMessage("The order " + orderId + " doesn't exist.");
            return result;
        }
        return this.cancelOrder(order);
    }

    @Override
    public ExecutionResult cancelOrder(Order order) {
        return this.executeOrderCancellation(order);
    }

    protected ExecutionResult setRequiredOrderAttributes(Order order) {
        return this.ensureRequiredOrderAttributes(order);
    }

    protected void storeOrder(Order order) {
        if (this.orders == null) {
            this.orders = (OrderContainer)this.context.getAttribute(StandardTradePlanAttributes.ORDERS);
            if (this.orders == null) {
                this.orders = new OrderContainer();
                this.context.setAttribute(StandardTradePlanAttributes.ORDERS, (Object)this.orders);
            }
            this.positions = (PositionContainer)this.context.getAttribute(StandardTradePlanAttributes.POSITIONS);
            if (this.positions == null) {
                this.positions = new PositionContainer();
                this.context.setAttribute(StandardTradePlanAttributes.POSITIONS, (Object)this.positions);
            }
        }
        this.orders.addOrder(order);
    }

    protected ExecutionResult processOrder(Order order) {
        return this.executeOrder(order);
    }

    protected abstract ExecutionResult ensureRequiredOrderAttributes(Order var1);

    protected abstract ExecutionResult executeOrder(Order var1);

    protected abstract ExecutionResult executeOrderCancellation(Order var1);
}

