/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service.consolidate;

import de.gsi.financial.samples.dos.Interval;
import de.gsi.financial.samples.dos.OHLCVItem;
import de.gsi.financial.samples.service.consolidate.AbstractIncrementalOhlcvConsolidation;
import de.gsi.financial.samples.service.consolidate.OhlcvConsolidationAddon;
import de.gsi.financial.samples.service.consolidate.OhlcvTimeframeConsolidation;
import de.gsi.financial.samples.service.period.IntradayPeriod;
import java.util.Calendar;

public class VolumeIncrementalOhlcvConsolidation
extends AbstractIncrementalOhlcvConsolidation {
    private double volumeDiff;
    private final double volumePeriod;

    public VolumeIncrementalOhlcvConsolidation(OhlcvTimeframeConsolidation.OhlcvConsolidationComputation consolidationComputation, IntradayPeriod period, Interval<Calendar> tt, OhlcvConsolidationAddon[] _ohlcvConsolidationAddons) {
        super(consolidationComputation, period, tt, _ohlcvConsolidationAddons);
        this.volumePeriod = period.getPeriodValue();
    }

    @Override
    protected void defineConsolidationConditionAfterAddition(OHLCVItem finalItem) {
        this.defineConsolidationCondition(finalItem);
    }

    @Override
    protected void defineConsolidationConditionAfterUpdate(OHLCVItem finalItem) {
        this.defineConsolidationCondition(finalItem);
    }

    @Override
    protected boolean checkConsolidationCondition(OHLCVItem lastItem, OHLCVItem incrementItem) {
        return incrementItem.getVolume() <= this.volumeDiff;
    }

    private void defineConsolidationCondition(OHLCVItem finalItem) {
        this.volumeDiff = this.volumePeriod - finalItem.getVolume();
    }
}

