/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.financial.samples.service.consolidate;

import de.gsi.financial.samples.dos.Interval;
import de.gsi.financial.samples.dos.OHLCVItem;
import de.gsi.financial.samples.service.consolidate.AbstractIncrementalOhlcvConsolidation;
import de.gsi.financial.samples.service.consolidate.OhlcvConsolidationAddon;
import de.gsi.financial.samples.service.consolidate.OhlcvTimeframeConsolidation;
import de.gsi.financial.samples.service.period.IntradayPeriod;
import java.util.Calendar;

public class RangeBarsIncrementalOhlcvConsolidation
extends AbstractIncrementalOhlcvConsolidation {
    private final double rangeBarsLength;
    private boolean hasLength = true;
    private double low;
    private double high;

    public RangeBarsIncrementalOhlcvConsolidation(OhlcvTimeframeConsolidation.OhlcvConsolidationComputation consolidationComputation, IntradayPeriod period, double minMoveTick, Interval<Calendar> tt, OhlcvConsolidationAddon[] ohlcvConsolidationAddons) {
        super(consolidationComputation, period, tt, ohlcvConsolidationAddons);
        this.rangeBarsLength = period.getPeriodValue() * minMoveTick;
    }

    @Override
    protected void defineConsolidationConditionAfterAddition(OHLCVItem finalItem) {
        this.defineConsolidationCondition(finalItem);
    }

    @Override
    protected void defineConsolidationConditionAfterUpdate(OHLCVItem finalItem) {
        this.defineConsolidationCondition(finalItem);
    }

    @Override
    protected boolean checkConsolidationCondition(OHLCVItem lastItem, OHLCVItem incrementItem) {
        return !this.hasLength || incrementItem.getLow() >= this.low && incrementItem.getHigh() <= this.high;
    }

    private void defineConsolidationCondition(OHLCVItem finalItem) {
        this.low = finalItem.getLow();
        this.high = finalItem.getHigh();
        this.hasLength = this.rangeBarsLength <= this.high - this.low;
    }
}

